/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.adapter.fipa.AMSAgentDescription;
import jadex.adapter.fipa.AgentIdentifier;
import jadex.adapter.fipa.SearchConstraints;
import jadex.runtime.BDIFailureException;
import jadex.runtime.IExternalAccess;
import jadex.runtime.IGoal;
import jadex.tools.common.AgentIdentifierPanel;
import jadex.tools.common.AgentTreeTable;
import jadex.tools.common.GuiProperties;
import jadex.tools.common.jtreetable.DefaultTreeTableNode;
import jadex.util.SGUI;
import jadex.util.SUtil;
import jadex.util.jtable.ResizeableTableHeader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.List;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIDefaults;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.tree.TreePath;

public class AgentSelectorDialog {
    protected static UIDefaults icons = new UIDefaults(new Object[]{"arrow_right", SGUI.makeIcon((Class)AgentSelectorDialog.class, (String)"/jadex/tools/common/images/arrow_right.png")});
    protected Component parent;
    protected IExternalAccess agent;
    protected AgentTreeTable tree;
    protected AgentTreeTable seltree;
    protected AgentIdentifierPanel aidpanel;
    protected boolean singleselection;
    protected JDialog dia;
    protected boolean aborted;
    protected List sellist;
    protected JButton select;
    protected JButton newaid;
    protected JButton remove;
    protected JButton removeall;
    protected JButton ok;
    protected JButton cancel;
    protected JButton help;

    public AgentSelectorDialog(Component parent, IExternalAccess agent) {
        this.parent = parent;
        this.agent = agent;
        this.sellist = new LinkedList();
    }

    public AgentIdentifier selectAgent(AgentIdentifier def) {
        this.singleselection = true;
        this.sellist.clear();
        if (def != null) {
            this.sellist.add(def);
        }
        this.dia = this.createDialog();
        this.refreshAgentTree();
        this.refreshSelectedTree();
        if (this.sellist.size() > 0) {
            this.seltree.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.aidpanel.setEditable(false);
        }
        this.aborted = false;
        this.dia.setVisible(true);
        this.singleselection = false;
        return !this.aborted && this.sellist.size() > 0 ? (AgentIdentifier)this.sellist.get(0) : null;
    }

    public AgentIdentifier[] selectAgents(AgentIdentifier[] receivers) {
        this.sellist.clear();
        for (int i = 0; receivers != null && i < receivers.length; ++i) {
            this.sellist.add(receivers[i]);
        }
        this.dia = this.createDialog();
        this.refreshAgentTree();
        this.refreshSelectedTree();
        if (this.sellist.size() > 0) {
            this.seltree.getTreetable().getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.aidpanel.setEditable(false);
        }
        this.aborted = false;
        this.dia.setVisible(true);
        return this.aborted ? null : this.sellist.toArray(new AgentIdentifier[this.sellist.size()]);
    }

    protected void refreshAgentTree() {
        try {
            IGoal search = this.agent.getGoalbase().createGoal("ams_search_agents");
            search.getParameter("description").setValue((Object)new AMSAgentDescription());
            SearchConstraints constraints = new SearchConstraints();
            constraints.setMaxResults(-1);
            search.getParameter("constraints").setValue((Object)constraints);
            this.agent.dispatchTopLevelGoalAndWait(search, 10000L);
            AMSAgentDescription[] descs = (AMSAgentDescription[])search.getParameterSet("result").getValues();
            this.tree.removeAgents();
            for (int i = 0; i < descs.length; ++i) {
                this.tree.addAgent(descs[i]);
            }
            ((ResizeableTableHeader)this.tree.getTreetable().getTableHeader()).resizeAllColumns();
            Dimension pref = this.tree.getTreetable().getPreferredSize();
            this.tree.getTreetable().setPreferredScrollableViewportSize(new Dimension(Math.min(pref.width, 400), Math.max(100, (int)Math.min((double)pref.height * 1.25, 300.0))));
        }
        catch (BDIFailureException e) {
            String text = SUtil.wrapText((String)("Could not refresh agent list: " + e.getMessage()));
            JOptionPane.showMessageDialog(SGUI.getWindowParent((Component)this.parent), text, "Agent List Problem", 1);
        }
    }

    protected void refreshSelectedTree() {
        int row = this.seltree.getTreetable().getSelectionModel().getMinSelectionIndex();
        this.seltree.removeAgents();
        for (int i = 0; i < this.sellist.size(); ++i) {
            this.seltree.addAgent(new AMSAgentDescription((AgentIdentifier)this.sellist.get(i)));
        }
        this.seltree.getTreetable().tableChanged(new TableModelEvent(this.seltree.getTreetable().getModel(), -1));
        ((ResizeableTableHeader)this.seltree.getTreetable().getTableHeader()).resizeAllColumns();
        Dimension pref = this.seltree.getTreetable().getPreferredSize();
        this.seltree.getTreetable().setPreferredScrollableViewportSize(new Dimension(Math.min(pref.width, 400), Math.max(100, (int)Math.min((double)pref.height * 1.25, 300.0))));
        if (this.sellist.size() > 0) {
            row = Math.min(row, this.sellist.size() - 1);
            this.seltree.getTreetable().getSelectionModel().setSelectionInterval(row, row);
            this.seltree.getTreetable().scrollRectToVisible(this.seltree.getTreetable().getCellRect(row + 1, this.seltree.getTreetable().convertColumnIndexToView(0), true));
        }
    }

    protected JDialog createDialog() {
        this.select = new JButton(icons.getIcon("arrow_right"));
        this.newaid = new JButton("New");
        this.remove = new JButton("Delete");
        this.removeall = new JButton("Clear");
        this.ok = new JButton("Ok");
        this.cancel = new JButton("Cancel");
        this.help = new JButton("Help");
        this.select.setToolTipText("Use selected agent.");
        this.newaid.setToolTipText("Add new (empty) agent identifier.");
        this.remove.setToolTipText("Remove selected agent.");
        this.removeall.setToolTipText("Remove all agents.");
        this.ok.setToolTipText("Close dialog using current selection.");
        this.cancel.setToolTipText("Abort dialog.");
        this.help.setToolTipText("Show online documentation about this dialog.");
        this.select.setMargin(new Insets(1, 1, 1, 1));
        this.newaid.setMinimumSize(this.cancel.getMinimumSize());
        this.newaid.setPreferredSize(this.cancel.getPreferredSize());
        this.removeall.setMinimumSize(this.cancel.getMinimumSize());
        this.removeall.setPreferredSize(this.cancel.getPreferredSize());
        this.ok.setMinimumSize(this.cancel.getMinimumSize());
        this.ok.setPreferredSize(this.cancel.getPreferredSize());
        this.help.setMinimumSize(this.cancel.getMinimumSize());
        this.help.setPreferredSize(this.cancel.getPreferredSize());
        this.select.setEnabled(false);
        this.newaid.setEnabled(!this.singleselection || this.sellist.size() == 0);
        this.remove.setEnabled(false);
        this.removeall.setEnabled(this.sellist.size() > 0);
        this.ok.setEnabled(!this.singleselection || this.sellist.size() > 0);
        this.tree = new AgentTreeTable();
        this.tree.setPreferredSize(new Dimension(200, 100));
        this.tree.getTreetable().setSelectionMode(0);
        this.seltree = new AgentTreeTable();
        this.seltree.setPreferredSize(new Dimension(200, 100));
        this.seltree.getTreetable().setSelectionMode(0);
        this.seltree.getTreetable().getTree().setRootVisible(false);
        this.aidpanel = new AgentIdentifierPanel(null){

            protected void aidChanged() {
                AgentSelectorDialog.this.refreshSelectedTree();
            }
        };
        JPanel treepanel = new JPanel(new GridBagLayout());
        treepanel.setBorder(new TitledBorder(new EtchedBorder(1), " Known Agents "));
        treepanel.add((Component)this.tree, new GridBagConstraints(0, 0, 1, 0, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        treepanel.add((Component)this.select, new GridBagConstraints(1, 0, 0, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        treepanel.add((Component)new JLabel(), new GridBagConstraints(1, 1, 0, 0, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        JPanel seltreepanel = new JPanel(new BorderLayout());
        seltreepanel.add("Center", this.seltree);
        seltreepanel.setBorder(new TitledBorder(new EtchedBorder(1), " Selected Agents "));
        this.aidpanel.setBorder(new TitledBorder(new EtchedBorder(1), " Agent Identifier "));
        this.tree.getTreetable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    boolean selectenabled = false;
                    if (!AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().isSelectionEmpty()) {
                        int row = AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().getMinSelectionIndex();
                        Object val = ((DefaultTreeTableNode)AgentSelectorDialog.this.tree.getTreetable().getTree().getPathForRow(row).getLastPathComponent()).getUserObject();
                        if (val instanceof AMSAgentDescription) {
                            selectenabled = !AgentSelectorDialog.this.singleselection || AgentSelectorDialog.this.sellist.size() == 0;
                        }
                    }
                    AgentSelectorDialog.this.select.setEnabled(selectenabled);
                }
            }
        });
        this.seltree.getTreetable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    AgentIdentifier selected = null;
                    if (!AgentSelectorDialog.this.seltree.getTreetable().getSelectionModel().isSelectionEmpty()) {
                        int row = AgentSelectorDialog.this.seltree.getTreetable().getSelectionModel().getMinSelectionIndex();
                        Object val = ((DefaultTreeTableNode)AgentSelectorDialog.this.seltree.getTreetable().getTree().getPathForRow(row).getLastPathComponent()).getUserObject();
                        if (val instanceof AMSAgentDescription) {
                            selected = ((AMSAgentDescription)val).getName();
                        }
                    }
                    AgentSelectorDialog.this.aidpanel.setAgentIdentifier(selected);
                    AgentSelectorDialog.this.aidpanel.setEditable(selected != null);
                    AgentSelectorDialog.this.remove.setEnabled(selected != null);
                }
            }
        });
        this.tree.getTreetable().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                Object val;
                TreePath path;
                if (e.getClickCount() == 2 && (path = AgentSelectorDialog.this.tree.getTreetable().getTree().getPathForLocation(e.getX(), e.getY())) != null && (val = ((DefaultTreeTableNode)path.getLastPathComponent()).getUserObject()) instanceof AMSAgentDescription) {
                    AgentSelectorDialog.this.addSelectedAgent((AgentIdentifier)((AMSAgentDescription)val).getName().clone());
                }
            }
        });
        this.parent = SGUI.getWindowParent((Component)this.parent);
        final JDialog dia = this.parent instanceof Frame ? new JDialog((Frame)this.parent, "Select/Enter Agent Identifier", true) : new JDialog((Dialog)this.parent, "Select/Enter Agent Identifier", true);
        dia.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AgentSelectorDialog.this.aborted = true;
            }
        });
        HelpBroker hb = GuiProperties.setupHelp(dia, "conversationcenter.aidselector");
        if (hb != null) {
            this.help.addActionListener((ActionListener)new CSH.DisplayHelpFromSource(hb));
        }
        this.select.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object val;
                if (!AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().isSelectionEmpty() && (val = ((DefaultTreeTableNode)AgentSelectorDialog.this.tree.getTreetable().getTree().getPathForRow(AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().getMinSelectionIndex()).getLastPathComponent()).getUserObject()) instanceof AMSAgentDescription) {
                    AgentSelectorDialog.this.addSelectedAgent((AgentIdentifier)((AMSAgentDescription)val).getName().clone());
                }
            }
        });
        this.newaid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentSelectorDialog.this.addSelectedAgent(new AgentIdentifier(""));
            }
        });
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!AgentSelectorDialog.this.seltree.getTreetable().getSelectionModel().isSelectionEmpty()) {
                    int row = AgentSelectorDialog.this.seltree.getTreetable().getSelectionModel().getMinSelectionIndex();
                    Object val = ((DefaultTreeTableNode)AgentSelectorDialog.this.seltree.getTreetable().getTree().getPathForRow(row).getLastPathComponent()).getUserObject();
                    if (val instanceof AMSAgentDescription) {
                        AgentSelectorDialog.this.sellist.remove(row);
                        AgentSelectorDialog.this.refreshSelectedTree();
                        AgentSelectorDialog.this.removeall.setEnabled(AgentSelectorDialog.this.sellist.size() > 0);
                        if (AgentSelectorDialog.this.singleselection) {
                            AgentSelectorDialog.this.newaid.setEnabled(true);
                            AgentSelectorDialog.this.ok.setEnabled(false);
                            if (!AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().isSelectionEmpty()) {
                                AgentSelectorDialog.this.select.setEnabled(true);
                            }
                        }
                    }
                }
            }
        });
        this.removeall.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentSelectorDialog.this.sellist.clear();
                AgentSelectorDialog.this.refreshSelectedTree();
                AgentSelectorDialog.this.removeall.setEnabled(false);
                if (AgentSelectorDialog.this.singleselection) {
                    AgentSelectorDialog.this.newaid.setEnabled(true);
                    AgentSelectorDialog.this.ok.setEnabled(false);
                    if (!AgentSelectorDialog.this.tree.getTreetable().getSelectionModel().isSelectionEmpty()) {
                        AgentSelectorDialog.this.select.setEnabled(true);
                    }
                }
            }
        });
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dia.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AgentSelectorDialog.this.aborted = true;
                dia.dispose();
            }
        });
        JPanel topright = new JPanel(new GridBagLayout());
        topright.add((Component)seltreepanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        topright.add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        topright.add((Component)this.newaid, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 4, 4, 2), 0, 0));
        topright.add((Component)this.remove, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 2), 0, 0));
        topright.add((Component)this.removeall, new GridBagConstraints(3, 1, 0, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 4), 0, 0));
        JSplitPane right = new JSplitPane(0, true, topright, this.aidpanel);
        right.setOneTouchExpandable(true);
        right.setResizeWeight(1.0);
        JSplitPane center = new JSplitPane(1, true, treepanel, right);
        center.setOneTouchExpandable(true);
        center.setResizeWeight(0.5);
        dia.getContentPane().setLayout(new GridBagLayout());
        dia.getContentPane().add((Component)center, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)new JLabel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        dia.getContentPane().add((Component)this.ok, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 4, 4, 2), 0, 0));
        dia.getContentPane().add((Component)this.cancel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 2), 0, 0));
        dia.getContentPane().add((Component)this.help, new GridBagConstraints(3, 1, 0, 1, 0.0, 0.0, 10, 3, new Insets(4, 2, 4, 4), 0, 0));
        dia.pack();
        dia.setLocation(SGUI.calculateMiddlePosition((Window)((Window)this.parent), (Window)dia));
        return dia;
    }

    protected void addSelectedAgent(AgentIdentifier agent) {
        this.removeall.setEnabled(true);
        if (!this.singleselection || this.sellist.size() == 0) {
            this.sellist.add(agent);
            this.refreshSelectedTree();
            this.seltree.getTreetable().getSelectionModel().setSelectionInterval(this.sellist.size() - 1, this.sellist.size() - 1);
            if (this.singleselection) {
                this.select.setEnabled(false);
                this.newaid.setEnabled(false);
                this.ok.setEnabled(true);
            }
        }
    }
}

