/*
 * Decompiled with CFR 0.152.
 */
package jadex.tools.common;

import jadex.adapter.fipa.AgentIdentifier;
import jadex.tools.common.EditableList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class AgentIdentifierPanel
extends JPanel {
    protected AgentIdentifier aid;
    protected JTextField tfname;
    protected DocumentListener namelistener;
    protected boolean nameediting;
    protected EditableList taddresses;
    protected boolean editable;

    public AgentIdentifierPanel(AgentIdentifier aid) {
        this.aid = aid != null ? aid : new AgentIdentifier();
        this.editable = true;
        int row = 0;
        GridBagConstraints leftcons = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(1, 1, 1, 1), 0, 0);
        GridBagConstraints rightcons = (GridBagConstraints)leftcons.clone();
        rightcons.gridx = 1;
        rightcons.gridwidth = 0;
        rightcons.weightx = 1.0;
        GridBagConstraints fullcons = (GridBagConstraints)rightcons.clone();
        fullcons.gridx = 0;
        fullcons.weighty = 1.0;
        fullcons.fill = 1;
        this.setLayout(new GridBagLayout());
        this.tfname = new JTextField(this.aid.getName(), 20);
        this.namelistener = new NameListener();
        this.tfname.getDocument().addDocumentListener(this.namelistener);
        fullcons.gridy = row++;
        rightcons.gridy = fullcons.gridy;
        leftcons.gridy = fullcons.gridy;
        this.add((Component)new JLabel("Name: "), leftcons);
        this.add((Component)this.tfname, rightcons);
        this.taddresses = new EditableList("Addresses");
        this.taddresses.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                AgentIdentifierPanel.this.aid.setAddresses(AgentIdentifierPanel.this.taddresses.getEntries());
                AgentIdentifierPanel.this.aidChanged();
            }
        });
        JScrollPane scroll = new JScrollPane(this.taddresses);
        fullcons.gridy = row++;
        rightcons.gridy = fullcons.gridy;
        leftcons.gridy = fullcons.gridy;
        this.add((Component)scroll, fullcons);
    }

    protected void aidChanged() {
    }

    public AgentIdentifier getAgentIdentifier() {
        return this.aid;
    }

    public void setAgentIdentifier(AgentIdentifier aid) {
        this.aid = aid != null ? aid : new AgentIdentifier();
        this.taddresses.setEntries(this.aid.getAddresses());
        this.refresh();
    }

    public void setEditable(boolean editable) {
        if (this.editable != editable) {
            this.editable = editable;
            this.tfname.setEditable(editable);
            this.refresh();
        }
    }

    protected void refresh() {
        if (!this.nameediting) {
            this.tfname.getDocument().removeDocumentListener(this.namelistener);
            this.tfname.setText(this.aid.getName());
            this.tfname.getDocument().addDocumentListener(this.namelistener);
        }
        this.taddresses.refresh();
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public class NameListener
    implements DocumentListener {
        public void changedUpdate(DocumentEvent e) {
            AgentIdentifierPanel.this.nameediting = true;
            AgentIdentifierPanel.this.aid.setName(AgentIdentifierPanel.this.tfname.getText());
            AgentIdentifierPanel.this.aidChanged();
            AgentIdentifierPanel.this.nameediting = false;
        }

        public void insertUpdate(DocumentEvent e) {
            AgentIdentifierPanel.this.nameediting = true;
            AgentIdentifierPanel.this.aid.setName(AgentIdentifierPanel.this.tfname.getText());
            AgentIdentifierPanel.this.aidChanged();
            AgentIdentifierPanel.this.nameediting = false;
        }

        public void removeUpdate(DocumentEvent e) {
            AgentIdentifierPanel.this.nameediting = true;
            AgentIdentifierPanel.this.aid.setName(AgentIdentifierPanel.this.tfname.getText());
            AgentIdentifierPanel.this.aidChanged();
            AgentIdentifierPanel.this.nameediting = false;
        }
    }
}

