/*
 * Decompiled with CFR 0.152.
 */
package nuggets.util;

import java.io.Serializable;
import java.util.Arrays;

public class IdentityHashMap
implements Serializable,
Cloneable {
    private static final Object NULL = null;
    private Object[] objects;
    private Object[] values;
    private double load;
    private int mask;
    private int limit;
    private int size;

    public IdentityHashMap() {
        this(8, 0.5);
    }

    public IdentityHashMap(int capacity, double load) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("Initial capacity too low: 0>=" + capacity);
        }
        if (load <= 0.0) {
            throw new IllegalArgumentException("Load factor out of range: 0>=" + load);
        }
        if (load > 1.0) {
            throw new IllegalArgumentException("Load factor out of range: 1.0<" + load);
        }
        this.init(capacity);
        this.load = load;
    }

    public Object put(Object key, Object value) {
        int a;
        int i = a = this.hash(key);
        do {
            Object tKey;
            if ((tKey = this.objects[i]) == null) {
                this.objects[i] = key;
                this.values[i] = value;
                if (++this.size > this.limit) {
                    this.rehash();
                }
                return NULL;
            }
            if (tKey == key) {
                this.objects[i] = key;
                Object tValue = this.values[i];
                this.values[i] = value;
                return tValue;
            }
            if (--i >= 0) continue;
            i = this.mask;
        } while (i != a);
        this.rehash();
        this.reinsert(key, value);
        return NULL;
    }

    public Object get(Object key) {
        Object tKey;
        int a;
        int i = a = this.hash(key);
        for (i = a; i >= 0; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return NULL;
            }
            if (tKey != key) continue;
            return this.values[i];
        }
        for (i = this.mask; i > a; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return NULL;
            }
            if (tKey != key) continue;
            return this.values[i];
        }
        return NULL;
    }

    public boolean containsKey(Object key) {
        Object tKey;
        int a;
        int i = a = this.hash(key);
        for (i = a; i >= 0; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return false;
            }
            if (tKey != key) continue;
            return true;
        }
        for (i = this.mask; i > a; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return false;
            }
            if (tKey != key) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        int a;
        int i = a = this.hash(key);
        do {
            Object tKey;
            if ((tKey = this.objects[i]) == null) {
                return NULL;
            }
            if (tKey == key) {
                this.objects[i] = null;
                Object tValue = this.values[i];
                this.values[i] = NULL;
                --this.size;
                this.rehashFrom(i - 1);
                return tValue;
            }
            if (--i >= 0) continue;
            i = this.mask;
        } while (i != a);
        return NULL;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.objects, null);
        Arrays.fill(this.values, NULL);
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.objects.length >> 1;
    }

    public Object clone() {
        try {
            IdentityHashMap t = (IdentityHashMap)super.clone();
            t.objects = (Object[])this.objects.clone();
            return t;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e + " in a clonable hashtable");
        }
    }

    protected void rehash() {
        Object[] tObjects = this.objects;
        Object[] tIds = this.values;
        this.init(this.objects.length << 1);
        int i = tObjects.length;
        while (i > 0) {
            Object tKey;
            if ((tKey = tObjects[--i]) == null) continue;
            this.reinsert(tKey, tIds[i]);
        }
    }

    protected void init(int capacity) {
        this.objects = new Object[capacity];
        this.values = new Object[capacity];
        this.mask = capacity - 1;
        this.limit = (int)Math.ceil(this.load * (double)this.objects.length);
    }

    protected void rehashFrom(int a) {
        Object tValue;
        Object tKey;
        int i = a;
        for (i = a; i >= 0; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return;
            }
            this.objects[i] = null;
            tValue = this.values[i];
            this.values[i] = NULL;
            this.reinsert(tKey, tValue);
        }
        for (i = this.mask; i > a; --i) {
            tKey = this.objects[i];
            if (tKey == null) {
                return;
            }
            this.objects[i] = null;
            tValue = this.values[i];
            this.values[i] = NULL;
            this.reinsert(tKey, tValue);
        }
    }

    protected final void reinsert(Object key, Object value) {
        int a;
        int i;
        for (i = a = this.hash(key); i >= 0; --i) {
            if (this.objects[i] != null) continue;
            this.objects[i] = key;
            this.values[i] = value;
            return;
        }
        for (i = this.mask; i > a; --i) {
            if (this.objects[i] != null) continue;
            this.objects[i] = key;
            this.values[i] = value;
            return;
        }
    }

    protected int hash(Object key) {
        return System.identityHashCode(key) % this.objects.length;
    }
}

