/*
 * Decompiled with CFR 0.152.
 */
package nuggets.util;

import java.io.IOException;
import java.io.Writer;
import nuggets.util.ICharStream;

public class CharStream
implements ICharStream {
    protected char[] buffer;
    protected int count;

    public CharStream() {
        this(32);
    }

    public CharStream(int initialSize) {
        this.buffer = new char[initialSize];
    }

    public void write(int c) {
        this.assureCapacity(this.count + 1);
        this.buffer[this.count++] = (char)c;
    }

    public void write(char c) {
        this.assureCapacity(this.count + 1);
        this.buffer[this.count++] = c;
    }

    public void write(String string) {
        int len = string.length();
        this.assureCapacity(this.count + len);
        string.getChars(0, len, this.buffer, this.count);
        this.count += len;
    }

    public void write(char[] chars) {
        this.write(chars, 0, chars.length);
    }

    public void write(char[] c, int off, int len) {
        if (len == 0) {
            return;
        }
        this.assureCapacity(this.count + len);
        System.arraycopy(c, off, this.buffer, this.count, len);
        this.count += len;
    }

    public void write(String str, int off, int len) {
        this.assureCapacity(this.count + len);
        str.getChars(off, off + len, this.buffer, this.count);
        this.count += len;
    }

    private final void assureCapacity(int cap) {
        if (cap > this.buffer.length) {
            int new_length = this.buffer.length << 1;
            if (new_length < cap) {
                new_length = cap;
            }
            char[] newbuf = new char[new_length];
            System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
            this.buffer = newbuf;
        }
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buffer, 0, this.count);
        out.flush();
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        char[] newbuf = new char[this.count];
        System.arraycopy(this.buffer, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }

    public void flush() {
    }

    public void close() {
    }
}

