/*
 * Decompiled with CFR 0.152.
 */
package nuggets.delegate;

import java.lang.reflect.Array;
import nuggets.IAssembler;
import nuggets.ICruncher;
import nuggets.IDelayedOperation;
import nuggets.IDelegate;
import nuggets.InstanceNotAvailableException;
import nuggets.delegate.ADelegate;

public class DObjectArray
extends ADelegate
implements IDelegate {
    public void persist(Object o, ICruncher mill) {
        int l;
        int i = l = Array.getLength(o);
        while (i > 0) {
            mill.declare(Array.get(o, --i));
        }
        mill.startConcept(o);
        mill.put("type", o.getClass().getName());
        mill.put("length", Integer.toString(l));
        while (i < l) {
            mill.add(Array.get(o, i++));
        }
    }

    public Object getInstance(Class clazz, IAssembler asm) throws Exception {
        int l = Integer.parseInt((String)asm.getAttributeValue("length"));
        return Array.newInstance(clazz.getComponentType(), l);
    }

    public void assemble(Object obj, IAssembler asm) throws Exception {
        String id;
        int i = 0;
        while ((id = asm.nextToken()) != null) {
            try {
                Array.set(obj, i, asm.getValue(id));
            }
            catch (InstanceNotAvailableException nae) {
                asm.delay(new ArrayDelayedSet(obj, i, id));
            }
            ++i;
        }
    }

    public static final class ArrayDelayedSet
    implements IDelayedOperation {
        private final int i;
        private final String id;
        private final Object obj;

        public ArrayDelayedSet(Object obj, int i, String id) {
            this.obj = obj;
            this.i = i;
            this.id = id;
        }

        public void perform(IAssembler asm) throws Exception {
            Array.set(this.obj, this.i, asm.getValue(this.id));
        }
    }
}

