/*
 * Decompiled with CFR 0.152.
 */
package nuggets.delegate;

import java.util.Iterator;
import java.util.Map;
import nuggets.IAssembler;
import nuggets.ICruncher;
import nuggets.IDelayedOperation;
import nuggets.InstanceNotAvailableException;
import nuggets.PersistenceException;
import nuggets.delegate.ADelegate;

public class DMap
extends ADelegate {
    public void persist(Object o, ICruncher mill) {
        Map map = (Map)o;
        this.declareReferences(map, mill);
        mill.startConcept(o);
        this.addReferences(map, mill);
    }

    protected void addReferences(Map map, ICruncher mill) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            mill.add(key);
            Object value = map.get(key);
            mill.add(value);
        }
    }

    protected void declareReferences(Map map, ICruncher mill) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            mill.declare(key);
            Object value = map.get(key);
            mill.declare(value);
        }
    }

    public void assemble(Object obj, IAssembler asm) throws Exception {
        String key;
        Map c = (Map)obj;
        while ((key = asm.nextToken()) != null) {
            String value = asm.nextToken();
            if (value == null) {
                throw new PersistenceException("No value for a key found");
            }
            try {
                c.put(asm.getValue(key), asm.getValue(value));
            }
            catch (InstanceNotAvailableException inae) {
                asm.delay(new MapDelayedAdd(c, key, value));
            }
        }
    }

    public static final class MapDelayedAdd
    implements IDelayedOperation {
        private final String key;
        private final Map col;
        private final String value;

        public MapDelayedAdd(Map col, String key, String value) {
            this.col = col;
            this.key = key;
            this.value = value;
        }

        public void perform(IAssembler asm) throws Exception {
            this.col.put(asm.getValue(this.key), asm.getValue(this.value));
        }
    }
}

