/*
 * Decompiled with CFR 0.152.
 */
package nuggets.delegate;

import java.util.List;
import nuggets.IAssembler;
import nuggets.IDelayedOperation;
import nuggets.InstanceNotAvailableException;
import nuggets.delegate.DCollection;

public class DList
extends DCollection {
    public Object getInstance(Class clazz, IAssembler asm) throws Exception {
        return clazz.newInstance();
    }

    public void assemble(Object obj, IAssembler asm) throws Exception {
        String token;
        List l = (List)obj;
        int i = 0;
        while ((token = asm.nextToken()) != null) {
            try {
                l.add(asm.getValue(token));
            }
            catch (InstanceNotAvailableException nae) {
                asm.delay(new ListDelayedAdd(l, i, token));
            }
            ++i;
        }
    }

    public static final class ListDelayedAdd
    implements IDelayedOperation {
        private final int i;
        private final String id;
        private final List l;

        public ListDelayedAdd(List l, int i, String id) {
            this.l = l;
            this.i = i;
            this.id = id;
        }

        public void perform(IAssembler asm) throws Exception {
            this.l.set(this.i, asm.getValue(this.id));
        }
    }
}

