/*
 * Decompiled with CFR 0.152.
 */
package nuggets.delegate;

import java.util.Collection;
import java.util.Iterator;
import nuggets.IAssembler;
import nuggets.ICruncher;
import nuggets.IDelayedOperation;
import nuggets.InstanceNotAvailableException;
import nuggets.delegate.ADelegate;

public class DCollection
extends ADelegate {
    public void persist(Object o, ICruncher mill) {
        Iterator it = ((Collection)o).iterator();
        while (it.hasNext()) {
            mill.declare(it.next());
        }
        mill.startConcept(o);
        it = ((Collection)o).iterator();
        while (it.hasNext()) {
            mill.add(it.next());
        }
    }

    public Object getInstance(Class clazz, IAssembler asm) throws Exception {
        return clazz.newInstance();
    }

    public void assemble(Object obj, IAssembler asm) throws Exception {
        String token;
        Collection c = (Collection)obj;
        while ((token = asm.nextToken()) != null) {
            try {
                c.add(asm.getValue(token));
            }
            catch (InstanceNotAvailableException nae) {
                asm.delay(new CollectionDelayedAdd(c, token));
            }
        }
    }

    public static final class CollectionDelayedAdd
    implements IDelayedOperation {
        private final String id;
        private final Collection col;

        public CollectionDelayedAdd(Collection col, String id) {
            this.col = col;
            this.id = id;
        }

        public void perform(IAssembler asm) throws Exception {
            this.col.add(asm.getValue(this.id));
        }
    }
}

