/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nuggets.BeanProperty;
import nuggets.IBeanIntrospector;
import nuggets.PersistenceException;

public class ReflectionIntrospector
implements IBeanIntrospector {
    public Map getBeanProperties(Class clazz) {
        try {
            Method[] ms = clazz.getMethods();
            HashMap<String, Method> getters = new HashMap<String, Method>();
            ArrayList<Method> setters = new ArrayList<Method>();
            for (int k = 0; k < ms.length; ++k) {
                String method_name = ms[k].getName();
                if (method_name.startsWith("is") || method_name.startsWith("get")) {
                    getters.put(method_name, ms[k]);
                    continue;
                }
                if (!method_name.startsWith("set")) continue;
                setters.add(ms[k]);
            }
            HashMap<String, BeanProperty> props = new HashMap<String, BeanProperty>();
            Iterator it = setters.iterator();
            while (it.hasNext()) {
                Class<?>[] setter_param_type;
                Method setter = (Method)it.next();
                String setter_name = setter.getName();
                String property_name = setter_name.substring(3);
                Method getter = (Method)getters.get("get" + property_name);
                if (getter == null) {
                    getter = (Method)getters.get("is" + property_name);
                }
                if (getter == null || (setter_param_type = setter.getParameterTypes()).length != 1) continue;
                String property_java_name = Character.toLowerCase(property_name.charAt(0)) + property_name.substring(1);
                props.put(property_java_name, new BeanProperty(property_java_name, getter.getReturnType(), getter, setter, setter_param_type[0]));
            }
            return props;
        }
        catch (Exception e) {
            throw new PersistenceException(e.getMessage());
        }
    }
}

