/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.util.Collection;
import java.util.Map;
import nuggets.BeanProperty;
import nuggets.ICruncher;
import nuggets.IDelegate;
import nuggets.IDelegateGenerator;
import nuggets.PersistenceException;
import nuggets.PersistenceHelper;
import nuggets.delegate.AGeneratedDelegate;

public class ReflectionGenerator
implements IDelegateGenerator {
    public ReflectionGenerator() {
        System.out.println("Using ReflectionGenerator for generating delegates.");
    }

    public IDelegate generateDelegate(Class clazz, Map props) {
        return new ReflectionDelegate(clazz, props);
    }

    static class ReflectionDelegate
    extends AGeneratedDelegate {
        private final Map props;
        private final BeanProperty[] bp;
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

        ReflectionDelegate(Class clazz, Map props) {
            this.props = props;
            Collection values = props.values();
            this.bp = values.toArray(new BeanProperty[values.size()]);
        }

        public void persist(Object o, ICruncher cruncher) {
            this.persist_recursive(o, cruncher, this.bp.length);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void persist_recursive(Object o, ICruncher c, int i) {
            IDelegate del;
            if (i == 0) {
                c.startConcept(o);
                return;
            }
            if ((del = PersistenceHelper.getDefaultDelegate(this.bp[--i].getType())).isSimple()) {
                this.persist_recursive(o, c, i);
                try {
                    if (this.bp[i].getType().isPrimitive()) {
                        c.put(this.bp[i].getName(), del.marshall(this.bp[i].getType(), this.bp[i].getGetter().invoke(o, EMPTY_OBJECT_ARRAY)));
                        return;
                    }
                    Object val = this.bp[i].getGetter().invoke(o, EMPTY_OBJECT_ARRAY);
                    if (val == null) return;
                    c.put(this.bp[i].getName(), del.marshall(this.bp[i].getType(), val));
                    return;
                }
                catch (Exception e) {
                    throw new PersistenceException(e);
                }
            }
            int id = 0;
            try {
                id = c.declare(this.bp[i].getGetter().invoke(o, EMPTY_OBJECT_ARRAY));
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
            this.persist_recursive(o, c, i);
            if (id == 0) return;
            c.put(this.bp[i].getName(), id);
        }

        public void set(Object object, String attribute, Object value) throws Exception {
            BeanProperty bp = (BeanProperty)this.props.get(attribute);
            if (bp == null) {
                throw new PersistenceException("No such attribute: " + attribute);
            }
            Class param_clazz = bp.getSetterType();
            IDelegate del = PersistenceHelper.getDefaultDelegate(param_clazz);
            bp.getSetter().invoke(object, del.unmarshall(param_clazz, value));
        }
    }
}

