/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import [Ljava.lang.Boolean;;
import [Ljava.lang.Byte;;
import [Ljava.lang.Character;;
import [Ljava.lang.Double;;
import [Ljava.lang.Float;;
import [Ljava.lang.Integer;;
import [Ljava.lang.Long;;
import [Ljava.lang.Short;;
import java.util.HashMap;
import java.util.Map;
import nuggets.IBeanIntrospector;
import nuggets.IDelegate;
import nuggets.IDelegateGenerator;
import nuggets.INugget;
import nuggets.ReflectionGenerator;
import nuggets.ReflectionIntrospector;
import nuggets.delegate.ADelegate;
import nuggets.delegate.DBoolean;
import nuggets.delegate.DBooleanArray;
import nuggets.delegate.DBooleanObject;
import nuggets.delegate.DBooleanObjectArray;
import nuggets.delegate.DByte;
import nuggets.delegate.DByteArray;
import nuggets.delegate.DByteObject;
import nuggets.delegate.DByteObjectArray;
import nuggets.delegate.DChar;
import nuggets.delegate.DCharArray;
import nuggets.delegate.DCharObject;
import nuggets.delegate.DCharObjectArray;
import nuggets.delegate.DClass;
import nuggets.delegate.DDouble;
import nuggets.delegate.DDoubleArray;
import nuggets.delegate.DDoubleObject;
import nuggets.delegate.DDoubleObjectArray;
import nuggets.delegate.DFloat;
import nuggets.delegate.DFloatArray;
import nuggets.delegate.DFloatObject;
import nuggets.delegate.DFloatObjectArray;
import nuggets.delegate.DInteger;
import nuggets.delegate.DIntegerArray;
import nuggets.delegate.DIntegerObject;
import nuggets.delegate.DIntegerObjectArray;
import nuggets.delegate.DLong;
import nuggets.delegate.DLongArray;
import nuggets.delegate.DLongObject;
import nuggets.delegate.DLongObjectArray;
import nuggets.delegate.DNugget;
import nuggets.delegate.DObjectArray;
import nuggets.delegate.DShort;
import nuggets.delegate.DShortArray;
import nuggets.delegate.DShortObject;
import nuggets.delegate.DShortObjectArray;
import nuggets.delegate.DString;
import nuggets.delegate.DStringBuffer;
import nuggets.util.IdentityHashMap;

public class PersistenceHelper {
    private static final IDelegate DEFAULT_DELEGATE = new ADelegate();
    static final IBeanIntrospector INTROSPECTOR = PersistenceHelper.getIntrospector();
    static final IDelegateGenerator GENERATOR = PersistenceHelper.getGenerator();
    private static final IDelegate ARRAY_DELEGATE = new DObjectArray();
    private static final IdentityHashMap fast_map = new IdentityHashMap();
    private static final HashMap string_map = new HashMap();

    public static String toString(boolean flag) {
        return flag ? "true" : "false";
    }

    public static String toString(Class clazz) {
        return clazz.getName();
    }

    public static IDelegate getDelegate(Class clazz) {
        IDelegate m = PersistenceHelper.lookUpDelegate(clazz);
        if (m == null) {
            m = PersistenceHelper.createPersistenceDelegate(clazz);
            PersistenceHelper.registerDelegate(clazz, m);
        }
        return m;
    }

    public static IDelegate getDefaultDelegate(Class clazz) {
        IDelegate m = PersistenceHelper.lookUpDelegate(clazz);
        if (m == null) {
            return DEFAULT_DELEGATE;
        }
        return m;
    }

    static IDelegate lookUpDelegate(Class clazz) {
        Class c = clazz;
        IDelegate m = null;
        m = (IDelegate)fast_map.get(c);
        if (m == null) {
            if (clazz.isArray()) {
                return ARRAY_DELEGATE;
            }
            Class<?>[] ints = c.getInterfaces();
            for (int i = 0; i < ints.length; ++i) {
                m = (IDelegate)fast_map.get(ints[i]);
                if (m == null) continue;
                PersistenceHelper.registerDelegate(clazz, m);
                break;
            }
        }
        return m;
    }

    private static IDelegate createPersistenceDelegate(Class clazz) {
        try {
            Map props = INTROSPECTOR.getBeanProperties(clazz);
            return GENERATOR.generateDelegate(clazz, props);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static IDelegateGenerator getGenerator() {
        try {
            return (IDelegateGenerator)Class.forName("nuggets.JaninoGenerator", true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception exception) {
            return new ReflectionGenerator();
        }
    }

    private static IBeanIntrospector getIntrospector() {
        try {
            return (IBeanIntrospector)Class.forName("nuggets.BeanInfoIntrospector", true, Thread.currentThread().getContextClassLoader()).newInstance();
        }
        catch (Exception exception) {
            return new ReflectionIntrospector();
        }
    }

    public static IDelegate getDefaultDelegate(String clazz) {
        IDelegate m = PersistenceHelper.lookUpDelegate(clazz);
        if (m == null) {
            return DEFAULT_DELEGATE;
        }
        return m;
    }

    static IDelegate lookUpDelegate(String clazz) {
        return (IDelegate)string_map.get(clazz);
    }

    public static void registerDelegate(Class clazz, IDelegate delegate) {
        try {
            String cn = clazz.getName();
            fast_map.put(clazz, delegate);
            string_map.put(cn, delegate);
            if (cn.startsWith("java.lang.") && cn.lastIndexOf(46) == 9) {
                string_map.put(cn.substring(10), delegate);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void registerDelegate(String class_name, String delegate_name) {
        try {
            PersistenceHelper.registerDelegate(Class.forName(class_name), (IDelegate)Class.forName(delegate_name, true, Thread.currentThread().getContextClassLoader()).newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        PersistenceHelper.registerDelegate(INugget.class, new DNugget());
        PersistenceHelper.registerDelegate(Boolean.class, new DBooleanObject());
        PersistenceHelper.registerDelegate(Boolean.TYPE, new DBoolean());
        PersistenceHelper.registerDelegate(Byte.class, new DByteObject());
        PersistenceHelper.registerDelegate(Byte.TYPE, new DByte());
        PersistenceHelper.registerDelegate(Character.class, new DCharObject());
        PersistenceHelper.registerDelegate(Character.TYPE, new DChar());
        PersistenceHelper.registerDelegate(Double.class, new DDoubleObject());
        PersistenceHelper.registerDelegate(Double.TYPE, new DDouble());
        PersistenceHelper.registerDelegate(Float.class, new DFloatObject());
        PersistenceHelper.registerDelegate(Float.TYPE, new DFloat());
        PersistenceHelper.registerDelegate(Integer.class, new DIntegerObject());
        PersistenceHelper.registerDelegate(Integer.TYPE, new DInteger());
        PersistenceHelper.registerDelegate(Long.class, new DLongObject());
        PersistenceHelper.registerDelegate(Long.TYPE, new DLong());
        PersistenceHelper.registerDelegate(Short.class, new DShortObject());
        PersistenceHelper.registerDelegate(Short.TYPE, new DShort());
        PersistenceHelper.registerDelegate([Z.class, new DBooleanArray());
        PersistenceHelper.registerDelegate(Boolean;.class, new DBooleanObjectArray());
        PersistenceHelper.registerDelegate([B.class, new DByteArray());
        PersistenceHelper.registerDelegate(Byte;.class, new DByteObjectArray());
        PersistenceHelper.registerDelegate([C.class, new DCharArray());
        PersistenceHelper.registerDelegate(Character;.class, new DCharObjectArray());
        PersistenceHelper.registerDelegate([D.class, new DDoubleArray());
        PersistenceHelper.registerDelegate(Double;.class, new DDoubleObjectArray());
        PersistenceHelper.registerDelegate([F.class, new DFloatArray());
        PersistenceHelper.registerDelegate(Float;.class, new DFloatObjectArray());
        PersistenceHelper.registerDelegate([I.class, new DIntegerArray());
        PersistenceHelper.registerDelegate(Integer;.class, new DIntegerObjectArray());
        PersistenceHelper.registerDelegate([J.class, new DLongArray());
        PersistenceHelper.registerDelegate(Long;.class, new DLongObjectArray());
        PersistenceHelper.registerDelegate([S.class, new DShortArray());
        PersistenceHelper.registerDelegate(Short;.class, new DShortObjectArray());
        PersistenceHelper.registerDelegate(Class.class, new DClass());
        PersistenceHelper.registerDelegate(String.class, new DString());
        PersistenceHelper.registerDelegate(StringBuffer.class, new DStringBuffer());
        PersistenceHelper.registerDelegate("java.util.BitSet", "nuggets.delegate.DBitSet");
        PersistenceHelper.registerDelegate("java.util.Calendar", "nuggets.delegate.DCalendar");
        PersistenceHelper.registerDelegate("java.util.GregorianCalendar", "nuggets.delegate.DCalendar");
        PersistenceHelper.registerDelegate("java.util.Collection", "nuggets.delegate.DCollection");
        PersistenceHelper.registerDelegate("java.util.List", "nuggets.delegate.DCollection");
        PersistenceHelper.registerDelegate("java.util.Set", "nuggets.delegate.DCollection");
        PersistenceHelper.registerDelegate("java.util.Date", "nuggets.delegate.DDate");
        PersistenceHelper.registerDelegate("java.util.Locale", "nuggets.delegate.DLocale");
        PersistenceHelper.registerDelegate("java.util.Map", "nuggets.delegate.DMap");
        PersistenceHelper.registerDelegate("java.util.Properties", "nuggets.delegate.DProperties");
        PersistenceHelper.registerDelegate("java.util.TimeZone", "nuggets.delegate.DTimeZone");
        PersistenceHelper.registerDelegate("java.util.TreeMap", "nuggets.delegate.DTreeMap");
        PersistenceHelper.registerDelegate("java.util.TreeSet", "nuggets.delegate.DTreeSet");
        PersistenceHelper.registerDelegate("java.io.File", "nuggets.delegate.DFile");
        PersistenceHelper.registerDelegate("java.net.URL", "nuggets.delegate.DURL");
        PersistenceHelper.registerDelegate("java.net.InetAddress", "nuggets.delegate.DInetAddress");
        PersistenceHelper.registerDelegate("java.sql.Date", "nuggets.delegate2.DSQLDate");
        PersistenceHelper.registerDelegate("java.sql.Time", "nuggets.delegate2.DSQLTime");
        PersistenceHelper.registerDelegate("java.sql.Timestamp", "nuggets.delegate2.DSQLTimestamp");
        PersistenceHelper.registerDelegate("java.math.BigDecimal", "nuggets.delegate2.DBigDecimal");
        PersistenceHelper.registerDelegate("java.math.BigInteger", "nuggets.delegate2.DBigInteger");
    }
}

