/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.util.Arrays;
import java.util.Random;

public class PerfectHash {
    private static final int DEFAULT_PERFECT_SIZE = 23;
    protected String[] keys;
    protected int n;
    protected int[] rnd_tab;
    protected int[] hash_cols;
    protected int minlen;
    protected int maxlen;
    private int perfect_size = 23;
    private static final Random rnd = new Random(System.currentTimeMillis());

    public PerfectHash() {
    }

    public PerfectHash(String[] keys) {
        this.setKeys(keys);
    }

    public PerfectHash(String[] keys, int perfect_size) {
        this.perfect_size = perfect_size;
        this.setKeys(keys);
    }

    public void setKeys(String[] keys) {
        int keys_length;
        this.keys = keys;
        this.maxlen = 0;
        this.minlen = Integer.MAX_VALUE;
        int k = keys_length = keys.length;
        while (k > 0) {
            int l;
            if ((l = keys[--k].length()) > this.maxlen) {
                this.maxlen = l;
            }
            if (l >= this.minlen) continue;
            this.minlen = l;
        }
        char[][] k_tab = new char[keys_length][];
        k = keys_length;
        while (k > 0) {
            k_tab[--k] = new char[this.maxlen];
            System.arraycopy(keys[k].toCharArray(), 0, k_tab[k], 0, keys[k].length());
        }
        int[] sort_cols = new int[this.maxlen];
        int sort_coli = 0;
        int keys_left = keys_length;
        while (keys_left > 1) {
            int col = this.maxlen;
            int min_c = -1;
            int min_dupl = Integer.MAX_VALUE;
            block3: while (col > 0) {
                --col;
                for (int tmp = 0; tmp < sort_coli; ++tmp) {
                    if (col == sort_cols[tmp]) continue block3;
                }
                k = keys_left;
                int same_ch = 0;
                while (k > 0) {
                    char ch = k_tab[--k][col];
                    int k2 = k;
                    while (k2 > 0) {
                        if (ch != k_tab[--k2][col]) continue;
                        ++same_ch;
                        break;
                    }
                    if (same_ch <= min_dupl) continue;
                    continue block3;
                }
                min_c = col;
                min_dupl = same_ch;
            }
            sort_cols[sort_coli++] = min_c;
            k = keys_left;
            block7: while (k > 0) {
                --k;
                int k2 = keys_left;
                while (k2 > 0) {
                    if (--k2 == k) continue;
                    boolean same = true;
                    for (int tmp = 0; tmp < sort_coli; ++tmp) {
                        int sc = sort_cols[tmp];
                        if (k_tab[k][sc] == k_tab[k2][sc]) continue;
                        same = false;
                        break;
                    }
                    if (!same) continue;
                    continue block7;
                }
                k_tab[k] = k_tab[--keys_left];
                k_tab[keys_left] = null;
            }
        }
        this.hash_cols = new int[sort_coli];
        System.arraycopy(sort_cols, 0, this.hash_cols, 0, sort_coli);
        Arrays.sort(this.hash_cols);
        this.rnd_tab = new int[sort_coli];
        this.n = keys_length;
        if (this.n >= this.perfect_size) {
            this.n = (int)((double)this.n * Math.log(this.n - this.perfect_size + 3));
        }
        Object[] inv = new String[this.n];
        block10: while (true) {
            int j = this.rnd_tab.length;
            while (j > 0) {
                this.rnd_tab[--j] = Integer.MAX_VALUE & rnd.nextInt();
            }
            Arrays.fill(inv, null);
            k = keys.length;
            while (k > 0) {
                int h;
                if (inv[h = this.hash(keys[--k])] != null) continue block10;
                inv[h] = keys[k];
            }
            break;
        }
        this.keys = inv;
    }

    public int hash(String name) {
        int h = 0;
        int c = name.length();
        int i = this.hash_cols.length;
        while (i > 0) {
            if (this.hash_cols[--i] >= c) continue;
            h += this.rnd_tab[i] * name.charAt(this.hash_cols[i]);
        }
        return (h >>> 15) % this.n;
    }

    public String getHashMethodString() {
        String method = "\nprivate static final int hash(String name) {\n";
        if (this.hash_cols.length == 0) {
            return method + "  return 0;\n}\n";
        }
        method = this.hash_cols[this.hash_cols.length - 1] < this.minlen ? method + this.shortHashMethod() : method + this.longHashMethod();
        return method + "}\n";
    }

    protected String longHashMethod() {
        String s = "  int h=0;\n  int c=name.length();\n";
        for (int i = 0; i < this.hash_cols.length; ++i) {
            int col = this.hash_cols[i];
            if (col >= this.minlen) {
                s = i > 0 ? s + "   if (c<=" + col + ") return (h>>>15)%" + this.n + ";\n" : s + "   if (c<=" + col + ") return 0;\n";
            }
            s = s + "   h += " + this.rnd_tab[i] + "*" + "name.charAt(" + col + ");\n";
        }
        return s + "   return (h>>>15)%" + this.n + ";\n";
    }

    protected String shortHashMethod() {
        String s = "   return ((";
        int i = this.hash_cols.length;
        while (i > 1) {
            s = s + this.rnd_tab[--i] + "*" + "name.charAt(" + this.hash_cols[i] + ")+";
        }
        return s + this.rnd_tab[0] + "*" + "name.charAt(" + this.hash_cols[0] + "))>>>15)%" + this.n + ";\n";
    }

    public String[] getKeys() {
        return this.keys;
    }

    public int getHashRange() {
        return this.keys.length;
    }
}

