/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import nuggets.IWriter;
import nuggets.util.Base64;
import nuggets.util.ICharStream;

public class JavaXMLWriter
implements IWriter {
    private final ICharStream out;
    private boolean open_tag;
    private static final char[] N_ROOT = "<n:root xmlns:n=\"nuggets_xml_encoder\"  xmlns:r=\"reference_ids\"".toCharArray();
    private static final char[] END_N_ROOT = "\n</n:root>\n".toCharArray();
    static final char[] REFERENCE = "r:".toCharArray();
    static final char[] NUGGET_ID = "n:id".toCharArray();

    public JavaXMLWriter(ICharStream out) {
        this.out = out;
    }

    public void start(String o) {
        this.out.write(N_ROOT);
        if (o != null) {
            this.out.write(" xmlns=\"");
            this.out.write(o);
            this.out.write('\"');
        }
        this.out.write('>');
        this.open_tag = false;
    }

    public void end() {
        this.out.write(END_N_ROOT);
        this.out.flush();
    }

    public void start(String tag, String id) {
        this.closeTag();
        this.out.write('\n');
        this.out.write('<');
        this.writeIdentifier(tag);
        if (id != null) {
            this.out.write(' ');
            this.out.write(NUGGET_ID);
            this.out.write('=');
            this.out.write('\"');
            this.out.write(id);
            this.out.write('\"');
        }
        this.open_tag = true;
    }

    public void end(String tag) {
        if (this.open_tag) {
            this.out.write("/>");
        } else {
            this.out.write('<');
            this.out.write('/');
            this.writeIdentifier(tag);
            this.out.write('>');
        }
        this.open_tag = false;
    }

    public void put(String name, String value) {
        this.out.write(' ');
        this.out.write(name);
        this.out.write('=');
        this.out.write('\"');
        this.writeAttributeValue(value);
        this.out.write('\"');
    }

    public void putRef(String name, String value) {
        this.out.write(' ');
        this.out.write(REFERENCE);
        this.out.write(name);
        this.out.write('=');
        this.out.write('\"');
        this.out.write(value);
        this.out.write('\"');
    }

    public void addToken(String token) {
        if (this.open_tag) {
            this.closeTag();
        } else {
            this.out.write(' ');
        }
        this.out.write(token);
    }

    public void write(String text) {
        if (text.length() > 0) {
            this.closeTag();
            this.writeValue(text);
        }
    }

    public void write(char[] chars, int start, int len) {
        if (len > 0) {
            this.closeTag();
            this.writeValue(chars, start, len);
        }
    }

    public void write(byte[] ba) {
        if (ba.length > 0) {
            this.closeTag();
            Base64.encode(ba, this.out);
        }
    }

    private void closeTag() {
        if (this.open_tag) {
            this.out.write('>');
            this.open_tag = false;
        }
    }

    void writeIdentifier(String value) {
        int len = value.length();
        char c = value.charAt(0);
        if (c == '_') {
            this.out.write('_');
            this.out.write('_');
        } else if (Character.isUnicodeIdentifierStart(c)) {
            this.out.write(c);
        } else {
            this.out.write('_');
            this.out.write(Integer.toHexString(c));
            this.out.write('_');
        }
        for (int i = 1; i < len; ++i) {
            c = value.charAt(i);
            if (c == '_') {
                this.out.write('_');
                this.out.write('_');
                continue;
            }
            if (c == '.' || Character.isUnicodeIdentifierPart(c)) {
                this.out.write(c);
                continue;
            }
            this.out.write('_');
            this.out.write(Integer.toHexString(c));
            this.out.write('_');
        }
    }

    void writeAttributeValue(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                this.out.write('\\');
                this.out.write('\\');
                continue;
            }
            if (JavaXMLWriter.isAttributeValueChar(c)) {
                this.out.write(c);
                continue;
            }
            this.out.write('\\');
            this.out.write('u');
            String h = Integer.toHexString(c);
            for (int j = h.length(); j < 4; ++j) {
                this.out.write('0');
            }
            this.out.write(h);
        }
    }

    void writeValue(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\\') {
                this.out.write('\\');
                this.out.write('\\');
                continue;
            }
            if (JavaXMLWriter.isValueChar(c)) {
                this.out.write(c);
                continue;
            }
            this.out.write('\\');
            this.out.write('u');
            String h = Integer.toHexString(c);
            for (int j = h.length(); j < 4; ++j) {
                this.out.write('0');
            }
            this.out.write(h);
        }
    }

    void writeValue(char[] chars, int start, int len) {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c == '\\') {
                this.out.write('\\');
                this.out.write('\\');
                continue;
            }
            if (JavaXMLWriter.isValueChar(c)) {
                this.out.write(c);
                continue;
            }
            this.out.write('\\');
            this.out.write('u');
            String h = Integer.toHexString(c);
            for (int j = h.length(); j < 4; ++j) {
                this.out.write('0');
            }
            this.out.write(h);
        }
    }

    private static final boolean isValueChar(char c) {
        return (c >= ' ' && c < '\u007f' || c >= '\u00a0' && c < '\ud800' || c >= '\ue000' && c < '\ufdd0') && c != '<' && c != '>' && c != '&';
    }

    private static final boolean isAttributeValueChar(char c) {
        return (c >= ' ' && c < '\u007f' || c >= '\u00a0' && c < '\ud800' || c >= '\ue000' && c < '\ufdd0') && c != '<' && c != '>' && c != '&' && c != '\"';
    }
}

