/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.io.IOException;
import java.io.Reader;
import nuggets.IReader;
import nuggets.JavaXMLWriter;
import nuggets.PersistenceException;
import nuggets.util.Base64;
import nuggets.util.CharStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class JavaXMLReader
implements IReader {
    private XmlPullParser xpp;
    private final CharStream cs = new CharStream();
    final IReader.Buffer buffer = new IReader.Buffer();
    final int[] oAndL = new int[2];
    private String[] attributes;
    private static final String NUGGET_ID = new String(JavaXMLWriter.NUGGET_ID);
    private static final String REFERENCE = new String(JavaXMLWriter.REFERENCE);
    private static final int REFERENCE_LENGTH = REFERENCE.length();

    public JavaXMLReader() {
        try {
            XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
            this.xpp = factory.newPullParser();
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
    }

    public void start(Reader rdr) {
        try {
            int i;
            this.xpp.setInput(rdr);
            while ((i = this.xpp.next()) != 2) {
                if (i != 1) continue;
                throw new PersistenceException("Input ended befor the first element");
            }
            String name = this.xpp.getName();
            if (!"n:root".equals(name)) {
                throw new PersistenceException("Encountered wrong element: " + name);
            }
            this.attributes = this.readAttributes();
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public IReader.Buffer getText() {
        try {
            int i;
            while ((i = this.xpp.next()) != 4) {
                if (i != 1 && i != 3) continue;
                this.buffer.set(null, 0, 0);
                return this.buffer;
            }
            this.buffer.set(this.xpp.getTextCharacters(this.oAndL), this.oAndL[0], this.oAndL[1]);
            return this.buffer;
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public byte[] getData() {
        try {
            int i;
            while ((i = this.xpp.next()) != 4) {
                if (i != 1) continue;
                return null;
            }
            this.buffer.set(this.xpp.getTextCharacters(this.oAndL), this.oAndL[0], this.oAndL[1]);
            return Base64.decode(this.buffer.chars, this.buffer.start, this.buffer.len);
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    public String nextElement() {
        try {
            int i;
            while ((i = this.xpp.next()) != 2) {
                if (i != 1) continue;
                return null;
            }
            this.attributes = this.readAttributes();
            return this.decodeTag(this.xpp.getName());
        }
        catch (XmlPullParserException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private String[] readAttributes() {
        int count = this.xpp.getAttributeCount();
        String[] attr = new String[count];
        for (int i = 0; i < count; ++i) {
            String a = this.xpp.getAttributeName(i);
            if (a.equals(NUGGET_ID)) continue;
            attr[i] = a.startsWith(REFERENCE) ? a.substring(REFERENCE_LENGTH) : a;
        }
        return attr;
    }

    public String getID() {
        return this.xpp.getAttributeValue(null, NUGGET_ID);
    }

    public int getAttributeCount() {
        return this.attributes.length;
    }

    public String getAttributeValue(String attribute) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] != attribute && !attribute.equals(this.attributes[i])) continue;
            return this.decodeText(this.xpp.getAttributeValue(i));
        }
        return null;
    }

    public int getAttributeIndex(String attribute) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] != attribute && !attribute.equals(this.attributes[i])) continue;
            return i;
        }
        return -1;
    }

    public String getAttributeName(int i) {
        return this.attributes[i];
    }

    public boolean isReferenceAttribute(int i) {
        String a = this.xpp.getAttributeName(i);
        return a != null && a.startsWith(REFERENCE);
    }

    public String getAttributeValue(int i) {
        return this.decodeText(this.xpp.getAttributeValue(i));
    }

    String decodeTag(String name) {
        this.cs.reset();
        int len = name.length();
        block0: for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c == '_' && i + 1 < len) {
                if (name.charAt(i + 1) != '_') {
                    for (int j = i + 1; j < len; ++j) {
                        if (name.charAt(j) != '_') continue;
                        this.cs.write((char)Integer.parseInt(name.substring(i + 1, j), 16));
                        i = j;
                        continue block0;
                    }
                } else {
                    ++i;
                }
            }
            this.cs.write(c);
        }
        return this.cs.toString();
    }

    public String decodeText(char[] chars, int start, int len) {
        this.cs.reset();
        int end = start + len;
        int x = start;
        while (x < end) {
            char aChar;
            if ((aChar = chars[x++]) == '\\') {
                if ((aChar = chars[x++]) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = chars[x++];
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + aChar + 10 - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + aChar + 10 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    this.cs.write((char)value);
                    continue;
                }
                this.cs.write(aChar);
                continue;
            }
            this.cs.write(aChar);
        }
        return this.cs.toString();
    }

    public String decodeText(String string) {
        this.cs.reset();
        int end = string.length();
        int x = 0;
        while (x < end) {
            char aChar;
            if ((aChar = string.charAt(x++)) == '\\') {
                if ((aChar = string.charAt(x++)) == 'u') {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = string.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + aChar + 10 - 97;
                                continue block6;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + aChar + 10 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    this.cs.write((char)value);
                    continue;
                }
                this.cs.write(aChar);
                continue;
            }
            this.cs.write(aChar);
        }
        return this.cs.toString();
    }
}

