/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import nuggets.BeanProperty;
import nuggets.IAssembler;
import nuggets.ICruncher;
import nuggets.IDelegate;
import nuggets.IDelegateGenerator;
import nuggets.PerfectHash;
import nuggets.PersistenceException;
import nuggets.PersistenceHelper;
import nuggets.delegate.AGeneratedDelegate;
import org.codehaus.janino.ClassBodyEvaluator;
import org.codehaus.janino.Scanner;

public class JaninoGenerator
implements IDelegateGenerator {
    static final String ICRUNCHER_INTERFACE = ICruncher.class.getName();
    static final String IASSEMBLER_INTERFACE = IAssembler.class.getName();

    public JaninoGenerator() {
        System.out.println("Using JaninoGenerator for generating delegates.");
    }

    public IDelegate generateDelegate(Class clazz, Map props) {
        String classbody = JaninoGenerator.createDelegateClassBody(clazz, props);
        try {
            return (IDelegate)ClassBodyEvaluator.createFastClassBodyEvaluator((Scanner)new Scanner("<generated>", (Reader)new StringReader(classbody)), (String)("persistence.Delegate" + clazz.getName()), (Class)AGeneratedDelegate.class, (Class[])new Class[]{IDelegate.class}, (ClassLoader)Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
    }

    private static String createDelegateClassBody(Class clazz, Map props) {
        try {
            String clazzname = clazz.getName();
            String classbody = "";
            int size = props.size();
            String[] keys = props.keySet().toArray(new String[size]);
            String persist_body = "";
            String reference_body = "";
            int ref_counter = 0;
            for (int k = 0; k < size; ++k) {
                BeanProperty bp = (BeanProperty)props.get(keys[k]);
                Class getter_type = bp.getGetterType();
                IDelegate getter_del = PersistenceHelper.getDefaultDelegate(getter_type);
                if (getter_del.isSimple()) {
                    if (getter_type.isPrimitive()) {
                        persist_body = persist_body + "   c.put(\"" + bp.getName() + "\"," + getter_del.getMarshallString("x." + bp.getGetterName() + "()") + ");\n";
                        continue;
                    }
                    persist_body = persist_body + "   {" + JaninoGenerator.getClassName(getter_type) + " t = x." + bp.getGetterName() + "(); " + "if (t!=null) c.put(\"" + bp.getName() + "\"," + getter_del.getMarshallString("t") + ");}\n";
                    continue;
                }
                reference_body = reference_body + "   int id" + ++ref_counter + " = c.declare(x." + bp.getGetterName() + "());\n";
                persist_body = persist_body + "   if (id" + ref_counter + "!=0) c.put(\"" + bp.getName() + "\", id" + ref_counter + ");\n";
            }
            classbody = classbody + "\npublic void persist(Object o, " + ICRUNCHER_INTERFACE + " c) throws Exception {\n" + "   " + clazzname + " x=(" + clazzname + ")o;\n" + reference_body + "   c.startConcept(o);\n" + persist_body + "}\n";
            classbody = classbody + "\npublic void set(Object o, String attribute, Object value) throws Exception {\n   " + clazzname + " x=(" + clazzname + ")o;\n";
            if (size > 1) {
                classbody = classbody + "   switch(hash(attribute)) {\n";
                PerfectHash ph = new PerfectHash(keys);
                keys = ph.getKeys();
                for (int k = 0; k < keys.length; ++k) {
                    String name = keys[k];
                    if (name == null) continue;
                    BeanProperty bp = (BeanProperty)props.get(name);
                    classbody = classbody + "   case " + k + ":";
                    Class param_clazz = bp.getSetterType();
                    IDelegate del = PersistenceHelper.getDefaultDelegate(param_clazz);
                    classbody = classbody + " x." + bp.getSetterName() + "(" + del.getUnmarshallString(JaninoGenerator.getClassName(param_clazz), "value") + "); return; \n";
                }
                classbody = classbody + "}}\n";
                classbody = classbody + ph.getHashMethodString();
            } else if (size == 1) {
                BeanProperty bp = (BeanProperty)props.get(keys[0]);
                Class param_clazz = bp.getSetterType();
                IDelegate del = PersistenceHelper.getDefaultDelegate(param_clazz);
                classbody = classbody + "   x." + bp.getSetterName() + "(" + del.getUnmarshallString(JaninoGenerator.getClassName(param_clazz), "value") + ");\n}\n";
            } else {
                classbody = classbody + "}\n";
            }
            classbody = classbody + "\npublic Object getInstance(Class clazz, " + IASSEMBLER_INTERFACE + " asm) throws Exception {\n" + "   return new " + clazzname + "();\n}\n";
            return classbody;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
    }

    private static String getClassName(Class ret) {
        if (ret.isArray()) {
            return JaninoGenerator.getClassName(ret.getComponentType()) + "[]";
        }
        return ret.getName();
    }
}

