/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import nuggets.ICruncher;
import nuggets.IDelegate;
import nuggets.IWriter;
import nuggets.PersistenceException;
import nuggets.PersistenceHelper;
import nuggets.util.IdHashMap;

public class BeanCruncher
implements ICruncher {
    private IWriter codec;
    private String ontology;
    private final IdHashMap ids = new IdHashMap();
    static final int MAX_VALUE_LENGTH = 256;
    protected int seq;

    public BeanCruncher(IWriter codec) {
        this.codec = codec;
    }

    public int declare(Object obj) {
        if (obj != null) {
            return this.persist_recursive(obj);
        }
        return 0;
    }

    public void put(String attr, int id) {
        this.codec.putRef(attr, Integer.toHexString(id));
    }

    public void add(Object value) {
        this.codec.addToken(Integer.toHexString(this.getID(value)));
    }

    public void put(String attr, String value) {
        if (value == null) {
            this.codec.put(attr, "0");
        } else if (value.length() > 256) {
            this.codec.put(attr, Integer.toHexString(this.getID(value)));
        } else {
            this.codec.put(attr, value);
        }
    }

    public void addToken(String value) {
        this.codec.addToken(value);
    }

    public void setData(byte[] ba) {
        this.codec.write(ba);
    }

    public void setText(String text) {
        this.codec.write(text);
    }

    public void setText(char[] chars, int start, int len) {
        this.codec.write(chars, start, len);
    }

    public void persist(Object root) {
        this.clear();
        if (root != null) {
            this.setOntology(root.getClass());
        }
        this.codec.start(this.ontology);
        this.persist_recursive(root);
        this.codec.end();
    }

    public void clear() {
        this.ontology = null;
        this.ids.clear();
        this.seq = 1;
    }

    protected int persist_recursive(Object o) {
        int id = this.ids.get(o);
        if (id == 0) {
            id = this.seq++;
            this.ids.put(o, id);
            Class<?> clazz = o.getClass();
            IDelegate m = PersistenceHelper.getDelegate(clazz);
            try {
                m.persist(o, this);
                this.codec.end(this.getTag(clazz));
            }
            catch (Exception e) {
                throw new PersistenceException(e);
            }
        }
        return id;
    }

    public void startConcept(Object o) {
        this.codec.start(this.getTag(o.getClass()), Integer.toHexString(this.getID(o)));
    }

    protected String getTag(Class clazz) {
        if (clazz.isArray()) {
            return "array";
        }
        String cn = clazz.getName();
        if (cn.startsWith(this.ontology + '.')) {
            return cn.substring(this.ontology.length() + 1);
        }
        return cn;
    }

    protected int getID(Object o) {
        if (o == null) {
            return 0;
        }
        int id = this.ids.get(o);
        if (id == 0) {
            id = this.seq++;
            this.ids.put(o, id);
        }
        return id;
    }

    private void setOntology(Class clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            return;
        }
        String clazz_name = clazz.getName();
        String tpck = "";
        int i = clazz_name.lastIndexOf(46);
        if (i > 0) {
            tpck = clazz_name.substring(0, i);
        }
        if (this.ontology == null || this.ontology.length() > tpck.length()) {
            this.ontology = tpck;
        }
    }
}

