/*
 * Decompiled with CFR 0.152.
 */
package nuggets;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import nuggets.AttributeSetOperation;
import nuggets.IAssembler;
import nuggets.IDelayedOperation;
import nuggets.IDelegate;
import nuggets.IReader;
import nuggets.InstanceNotAvailableException;
import nuggets.PersistenceException;
import nuggets.PersistenceHelper;

public class BeanAssembler
implements IAssembler {
    private static final int OBJECT_ARRAY_LENGTH = 512;
    private Object[] objects = new Object[512];
    private final ArrayList delayed = new ArrayList();
    private IReader reader;
    private String ontology;
    protected IReader.Buffer buffer;
    protected int token_offset;
    private IDelegate delegate;
    private Object object;

    public void setReader(IReader reader) {
        this.reader = reader;
    }

    public Object assemble(Reader rdr) {
        try {
            this.clear();
            this.parse(rdr);
            this.perform_delayed();
        }
        catch (Exception e) {
            throw new PersistenceException(e);
        }
        return this.get(1);
    }

    public void clear() {
        this.delayed.clear();
        Arrays.fill(this.objects, null);
    }

    public Object getAttributeValue(String attribute) {
        int i = this.reader.getAttributeIndex(attribute);
        if (i < 0) {
            return null;
        }
        if (!this.reader.isReferenceAttribute(i)) {
            return this.reader.getAttributeValue(i);
        }
        String str_id = this.reader.getAttributeValue(i);
        int id = Integer.parseInt(str_id, 16);
        if (this.has(id)) {
            return this.get(id);
        }
        this.delay(new AttributeSetOperation(this.delegate, this.object, attribute, str_id));
        return null;
    }

    public String getText() {
        if (this.buffer == null) {
            this.buffer = this.reader.getText();
            if (this.buffer == null) {
                return null;
            }
        }
        return this.reader.decodeText(this.buffer.chars, this.buffer.start, this.buffer.len);
    }

    public byte[] getData() {
        return this.reader.getData();
    }

    public String nextToken() {
        if (this.buffer == null) {
            this.buffer = this.reader.getText();
            if (this.buffer == null) {
                return null;
            }
            this.token_offset = this.buffer.start;
        }
        int end = this.buffer.start + this.buffer.len;
        for (int i = this.token_offset; i < end; ++i) {
            char c = this.buffer.chars[i];
            if (c != ' ') continue;
            if (i > this.token_offset) {
                String ret = new String(this.buffer.chars, this.token_offset, i - this.token_offset);
                this.token_offset = i + 1;
                return ret;
            }
            this.token_offset = i + 1;
        }
        if (end > this.token_offset) {
            String ret = new String(this.buffer.chars, this.token_offset, end - this.token_offset);
            this.token_offset = end;
            return ret;
        }
        return null;
    }

    public Object getValue(String sid) throws InstanceNotAvailableException {
        try {
            int id = Integer.parseInt(sid, 16);
            if (id == 0) {
                return null;
            }
            Object ret = this.objects[id];
            if (ret == null) {
                throw new InstanceNotAvailableException(sid);
            }
            return ret;
        }
        catch (NumberFormatException nfe) {
            throw new PersistenceException(nfe);
        }
    }

    public void delay(IDelayedOperation op) {
        this.delayed.add(op);
    }

    public IReader getReader() {
        return this.reader;
    }

    private boolean has(int id) {
        return id == 0 || id < this.objects.length && this.objects[id] != null;
    }

    private Object get(int id) {
        return id < this.objects.length ? this.objects[id] : null;
    }

    private void parse(Reader rdr) throws Exception {
        String tag;
        this.reader.start(rdr);
        this.ontology = this.reader.getAttributeValue("xmlns");
        while ((tag = this.reader.nextElement()) != null) {
            this.buffer = null;
            int id = Integer.parseInt(this.reader.getID(), 16);
            Class clazz = this.getClass(tag);
            this.delegate = PersistenceHelper.getDelegate(clazz);
            this.object = this.delegate.getInstance(clazz, this);
            this.set(id, this.object);
            this.delegate.assemble(this.object, this);
        }
    }

    private void set(int id, Object obj) {
        if (this.objects.length <= id) {
            Object[] tmp = new Object[Math.max(id + 64, this.objects.length << 1)];
            System.arraycopy(this.objects, 0, tmp, 0, this.objects.length);
            this.objects = tmp;
        }
        this.objects[id] = obj;
    }

    private void perform_delayed() {
        int len = this.delayed.size();
        for (int i = 0; i < len; ++i) {
            IDelayedOperation l = (IDelayedOperation)this.delayed.get(i);
            try {
                l.perform(this);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.delayed.clear();
    }

    private Class getClass(String tag) {
        if (tag.startsWith("array")) {
            tag = this.reader.getAttributeValue("type");
        }
        try {
            if (this.ontology != null && tag.indexOf(46) < 0) {
                return Class.forName(this.ontology + '.' + tag, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException e1) {
            // empty catch block
        }
        try {
            return Class.forName(tag, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceException(e);
        }
    }
}

