/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.util.ArrayList;
import org.apache.bcel.generic.Type;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchTarget;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.MethodBuilder;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BaseMappingWrapper;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.ObjectBinding;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class MappingDefinition
extends MappingBase {
    private static final String ADAPTERCLASS_SUFFIX = "_access";
    private static final String MARSHAL_METHODNAME = "marshal";
    private static final String BASEMARSHAL_METHODNAME = "baseMarshal";
    private static final String UNMARSHAL_METHODNAME = "unmarshal";
    private static final String ISPRESENT_METHODNAME = "isPresent";
    private static final String UNMARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.UnmarshallingContext";
    private static final String MARSHALCONTEXT_CLASS = "org.jibx.runtime.impl.MarshallingContext";
    private static final String UNMARSHAL_ISATMETHOD = "org.jibx.runtime.IUnmarshallingContext.isAt";
    private static final String UNMARSHAL_ISATSIGNATURE = "(Ljava/lang/String;Ljava/lang/String;)Z";
    private static final String CHECKEXTENDS_METHOD = "org.jibx.runtime.IMarshaller.isExtension";
    private static final String GETINDEX_METHOD = "org.jibx.runtime.IMarshallable.JiBX_getIndex";
    private static final String UNMARSHALLERPRESENT_METHOD = "org.jibx.runtime.IUnmarshaller.isPresent";
    private static final String UNMARSHALLERPRESENT_SIGNATURE = "(Lorg/jibx/runtime/IUnmarshallingContext;)Z";
    private static final String UNMARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IUnmarshallingContext";
    private static final String MARSHALCONTEXT_INTERFACE = "org.jibx.runtime.IMarshallingContext";
    private static final String CURRENTELEMENT_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.currentNameString";
    private static final String CURRENTELEMENT_SIGNATURE = "()Ljava/lang/String;";
    private static final String PARSERNEXT_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.next";
    private static final String PARSERNEXT_SIGNATURE = "()I";
    private static final String CLOSESTART_METHOD = "org.jibx.runtime.impl.MarshallingContext.closeStartContent";
    private static final String CLOSESTART_SIGNATURE = "()Lorg/jibx/runtime/impl/MarshallingContext;";
    private static final String ADDUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.addUnmarshalling";
    private static final String ADDUNMARSHALLER_SIGNATURE = "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V";
    private static final String REMOVEUNMARSHALLER_METHOD = "org.jibx.runtime.impl.UnmarshallingContext.removeUnmarshalling";
    private static final String REMOVEUNMARSHALLER_SIGNATURE = "(I)V";
    private static final String ADDMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.addMarshalling";
    private static final String ADDMARSHALLER_SIGNATURE = "(ILjava/lang/String;)V";
    private static final String REMOVEMARSHALLER_METHOD = "org.jibx.runtime.impl.MarshallingContext.removeMarshalling";
    private static final String REMOVEMARSHALLER_SIGNATURE = "(I)V";
    private static final Type[] ISPRESENT_METHOD_ARGS = new Type[]{ClassItem.typeFromName("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] UNMARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, ClassItem.typeFromName("org.jibx.runtime.IUnmarshallingContext")};
    private static final Type[] MARSHAL_METHOD_ARGS = new Type[]{Type.OBJECT, ClassItem.typeFromName("org.jibx.runtime.IMarshallingContext")};
    static final String[] UNMARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller"};
    static final String[] MARSHALLER_INTERFACES = new String[]{"org.jibx.runtime.IMarshaller"};
    static final String[] BOTH_INTERFACES = new String[]{"org.jibx.runtime.IUnmarshaller", "org.jibx.runtime.IMarshaller"};
    private final IContainer m_container;
    private final DefinitionContext m_defContext;
    private final BoundClass m_class;
    private final NameDefinition m_name;
    private final boolean m_isAbstract;
    private final String m_baseType;
    private IMapping m_baseMapping;
    private IComponent m_thisBinding;
    private ClassFile m_marshaller;
    private ClassFile m_unmarshaller;
    private ArrayList m_extensions;
    private String m_referenceType;

    public MappingDefinition(IContainer contain, DefinitionContext defc, String type, NameDefinition name, String tname, boolean abs, String base, ObjectBinding bind, boolean nillable) throws JiBXException {
        super(contain, type, tname);
        IComponent tref = new ObjectBinding(bind);
        if (name == null) {
            this.setWrappedComponent(bind);
        } else {
            this.setWrappedComponent(new ElementWrapper(defc, name, bind, nillable));
            tref = new ElementWrapper(defc, name, tref, nillable);
        }
        this.m_thisBinding = tref;
        this.m_container = contain;
        this.m_defContext = defc;
        this.m_class = BoundClass.getInstance(type, null);
        this.m_referenceType = type == null ? "java.lang.Object" : type;
        this.m_name = name;
        this.m_isAbstract = abs;
        this.m_baseType = base;
    }

    boolean hasNamespace() {
        return this.m_defContext.hasNamespace();
    }

    void genLoadNamespaces(MethodBuilder mb) {
        this.m_defContext.genLoadNamespaces(mb);
    }

    public BoundClass getBoundClass() {
        return this.m_class;
    }

    public void linkMappings() throws JiBXException {
        if (this.m_baseType != null) {
            this.m_baseMapping = this.m_defContext.getClassMapping(this.m_baseType);
            if (this.m_baseMapping == null) {
                throw new JiBXException("Mapping for base class " + this.m_baseType + " not defined");
            }
            this.m_baseMapping.addExtension(this);
        }
        this.m_defContext.linkMappings();
    }

    public String getBoundType() {
        return this.m_class.getClassName();
    }

    public String getReferenceType() {
        return this.m_referenceType;
    }

    public IComponent getImplComponent() {
        return this.m_component;
    }

    public ClassFile getMarshaller() {
        return this.m_marshaller;
    }

    public ClassFile getUnmarshaller() {
        return this.m_unmarshaller;
    }

    public NameDefinition getName() {
        return this.m_name;
    }

    public void addNamespace(NamespaceDefinition ns) throws JiBXException {
        this.m_defContext.addNamespace(ns);
    }

    public boolean isAbstract() {
        return this.m_isAbstract;
    }

    public boolean isBase() {
        return this.m_extensions != null && this.m_extensions.size() > 0;
    }

    public void addExtension(MappingDefinition mdef) throws JiBXException {
        ClassFile cf;
        if (this.m_extensions == null) {
            this.m_extensions = new ArrayList();
        }
        if (!this.m_extensions.contains(mdef)) {
            this.m_extensions.add(mdef);
        }
        if (!(cf = mdef.getBoundClass().getClassFile()).isSuperclass(this.m_referenceType) && !cf.isImplements(this.m_referenceType)) {
            this.m_referenceType = "java.lang.Object";
        }
    }

    public IComponent buildRef(IContainer parent, IContextObj objc, String type, PropertyDefinition prop) throws JiBXException {
        if (prop.isThis()) {
            return new BaseMappingWrapper(this.m_thisBinding);
        }
        if (this.m_isAbstract && this.m_extensions == null) {
            return new ComponentProperty(prop, this.m_component, false);
        }
        DirectObject dobj = new DirectObject(this.m_container, null, this.m_class.getClassFile(), this.m_isAbstract || this.m_extensions != null, this.m_marshaller, this.m_unmarshaller, this.getIndex(), null);
        return new DirectProperty(prop, dobj);
    }

    public ArrayList getNamespaces() {
        return this.m_defContext.getNamespaces();
    }

    public void generateCode(boolean force) throws JiBXException {
        ContextMethodBuilder mb;
        boolean hasname;
        this.m_defContext.generateCode(false, false);
        if (!force && this.m_isAbstract && this.m_extensions == null) {
            return;
        }
        BindingDefinition def = this.m_container.getBindingRoot();
        String name = this.m_class.deriveClassName(def.getPrefix(), ADAPTERCLASS_SUFFIX);
        ClassFile base = ClassCache.getClassFile("java.lang.Object");
        String[] intfs = def.isInput() ? (def.isOutput() ? BOTH_INTERFACES : UNMARSHALLER_INTERFACES) : MARSHALLER_INTERFACES;
        ClassFile cf = new ClassFile(name, this.m_class.getMungedFile().getRoot(), base, 1, intfs);
        cf.addDefaultConstructor();
        boolean hasattr = this.m_component.hasAttribute();
        boolean hascont = this.m_component.hasContent();
        boolean bl = hasname = !this.m_isAbstract && this.m_name != null;
        if (def.isInput()) {
            mb = new ContextMethodBuilder(ISPRESENT_METHODNAME, Type.BOOLEAN, ISPRESENT_METHOD_ARGS, cf, 17, -1, null, 1, UNMARSHALCONTEXT_INTERFACE);
            if (hasname) {
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                this.m_name.genPushUriPair(mb);
                mb.appendCallInterface(UNMARSHAL_ISATMETHOD, UNMARSHAL_ISATSIGNATURE);
            }
            if (this.m_extensions != null) {
                BranchWrapper ifthis = null;
                if (hasname) {
                    ifthis = mb.appendIFNE(this);
                }
                mb.addException("org.jibx.runtime.JiBXException");
                BranchWrapper[] iffounds = new BranchWrapper[this.m_extensions.size()];
                for (int i = 0; i < iffounds.length; ++i) {
                    IMapping map = (IMapping)this.m_extensions.get(i);
                    mb.loadContext();
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallInterface("org.jibx.runtime.IUnmarshallingContext.getUnmarshaller", "(I)Lorg/jibx/runtime/IUnmarshaller;");
                    mb.loadContext();
                    mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                    iffounds[i] = mb.appendIFNE(this);
                }
                mb.appendICONST_0();
                mb.appendReturn("int");
                mb.initStackState(iffounds[0]);
                BranchTarget found = mb.appendTargetLoadConstant(1);
                if (ifthis != null) {
                    ifthis.setTarget(found, mb);
                }
                for (int i = 0; i < iffounds.length; ++i) {
                    iffounds[i].setTarget(found, mb);
                }
            } else if (!hasname) {
                mb.appendICONST_1();
            }
            mb.appendReturn("int");
            mb.codeComplete(false);
            mb.addMethod();
            String type = this.m_class.getClassName();
            mb = new ContextMethodBuilder(UNMARSHAL_METHODNAME, Type.OBJECT, UNMARSHAL_METHOD_ARGS, cf, 17, 1, type, 2, UNMARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            mb.loadObject();
            BranchWrapper ifnnull = mb.appendIFNONNULL(this);
            if (this.m_extensions != null) {
                BranchWrapper ifthis = null;
                if (hasname) {
                    mb.addException("org.jibx.runtime.JiBXException");
                    mb.loadContext();
                    this.m_name.genPushUriPair(mb);
                    mb.appendCallInterface(UNMARSHAL_ISATMETHOD, UNMARSHAL_ISATSIGNATURE);
                    ifthis = mb.appendIFNE(this);
                }
                BranchWrapper[] iffounds = new BranchWrapper[this.m_extensions.size()];
                for (int i = 0; i < iffounds.length; ++i) {
                    IMapping map = (IMapping)this.m_extensions.get(i);
                    mb.loadContext();
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallInterface("org.jibx.runtime.IUnmarshallingContext.getUnmarshaller", "(I)Lorg/jibx/runtime/IUnmarshaller;");
                    mb.appendDUP();
                    mb.loadContext();
                    mb.appendCallInterface(UNMARSHALLERPRESENT_METHOD, UNMARSHALLERPRESENT_SIGNATURE);
                    iffounds[i] = mb.appendIFNE(this);
                    mb.appendPOP();
                }
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.appendDUP();
                mb.appendLoadConstant("Element ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.appendDUP();
                mb.loadContext(UNMARSHALCONTEXT_CLASS);
                mb.appendCallVirtual(CURRENTELEMENT_METHOD, CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendDUP();
                mb.appendLoadConstant(" has no mapping that extends " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
                if (iffounds.length > 0) {
                    mb.initStackState(iffounds[0]);
                    BranchTarget found = mb.appendTargetACONST_NULL();
                    for (int i = 0; i < iffounds.length; ++i) {
                        iffounds[i].setTarget(found, mb);
                    }
                    mb.loadContext();
                    mb.appendCallInterface("org.jibx.runtime.IUnmarshaller.unmarshal", "(Ljava/lang/Object;Lorg/jibx/runtime/IUnmarshallingContext;)Ljava/lang/Object;");
                    mb.appendReturn("java.lang.Object");
                }
                if (ifthis != null) {
                    mb.targetNext(ifthis);
                }
            } else if (this.m_isAbstract) {
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP();
                mb.appendLoadConstant("Abstract mapping requires instance to be supplied for class " + this.m_class.getClassName());
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
            }
            if (hasname) {
                this.genNewInstance(mb);
                mb.storeObject();
            }
            mb.targetNext(ifnnull);
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    IMapping map = (IMapping)maps.get(i);
                    if (map.isAbstract() && !map.isBase()) continue;
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    mb.appendLoadConstant(map.getIndex());
                    NameDefinition mname = map.getName();
                    if (mname == null) {
                        mb.appendACONST_NULL();
                        mb.appendACONST_NULL();
                    } else {
                        map.getName().genPushUriPair(mb);
                    }
                    mb.appendLoadConstant(map.getUnmarshaller().getName());
                    mb.appendCallVirtual(ADDUNMARSHALLER_METHOD, ADDUNMARSHALLER_SIGNATURE);
                }
            }
            mb.loadObject();
            mb.appendCreateCast(type);
            if (hasattr) {
                this.m_component.genAttributeUnmarshal(mb);
            }
            if (hasattr || !hasname) {
                mb.loadContext(UNMARSHALCONTEXT_CLASS);
                mb.appendCallVirtual(PARSERNEXT_METHOD, PARSERNEXT_SIGNATURE);
                mb.appendPOP();
            }
            if (hascont) {
                this.m_component.genContentUnmarshal(mb);
            }
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    IMapping map = (IMapping)maps.get(i);
                    if (map.isAbstract() && !map.isBase()) continue;
                    mb.loadContext(UNMARSHALCONTEXT_CLASS);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallVirtual(REMOVEUNMARSHALLER_METHOD, "(I)V");
                }
            }
            mb.appendReturn("java.lang.Object");
            mb.codeComplete(false);
            mb.addMethod();
            if (hasname && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIUnmarshallableMethod();
            }
        }
        if (def.isOutput()) {
            IMapping map;
            mb = new ContextMethodBuilder(MARSHAL_METHODNAME, Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
            mb.addException("org.jibx.runtime.JiBXException");
            ArrayList maps = this.m_defContext.getMappings();
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    map = (IMapping)maps.get(i);
                    if (map.isAbstract() && !map.isBase()) continue;
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendLoadConstant(map.getMarshaller().getName());
                    mb.appendCallVirtual(ADDMARSHALLER_METHOD, ADDMARSHALLER_SIGNATURE);
                }
            }
            if (hasattr || hascont) {
                mb.loadObject(this.m_class.getClassName());
                if (hasattr) {
                    if (hascont) {
                        mb.appendDUP();
                    }
                    this.m_component.genAttributeMarshal(mb);
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    mb.appendCallVirtual(CLOSESTART_METHOD, CLOSESTART_SIGNATURE);
                    mb.appendPOP();
                }
                if (hascont) {
                    this.m_component.genContentMarshal(mb);
                }
            }
            if (maps != null && maps.size() > 0) {
                for (int i = 0; i < maps.size(); ++i) {
                    map = (IMapping)maps.get(i);
                    if (map.isAbstract() && !map.isBase()) continue;
                    mb.loadContext(MARSHALCONTEXT_CLASS);
                    mb.appendLoadConstant(map.getIndex());
                    mb.appendCallVirtual(REMOVEMARSHALLER_METHOD, "(I)V");
                }
            }
            mb.appendReturn();
            mb.codeComplete(false);
            mb.addMethod();
            ExceptionMethodBuilder xb = new ExceptionMethodBuilder("isExtension", "(I)Z", cf, 17);
            xb.appendLoadLocal(1);
            xb.appendLoadConstant(this.getIndex());
            xb.appendISUB();
            BranchWrapper ifident = xb.appendIFEQ(this);
            if (this.m_baseMapping != null) {
                xb.appendLoadLocal(1);
                xb.appendLoadConstant(this.m_baseMapping.getIndex());
                xb.appendISUB();
                BranchWrapper iftrue = xb.appendIFEQ(this);
                xb.appendICONST_0();
                xb.appendReturn("int");
                xb.targetNext(iftrue);
            }
            xb.targetNext(ifident);
            xb.appendICONST_1();
            xb.appendReturn("int");
            xb.codeComplete(false);
            xb.addMethod();
            if (hasname && this.m_class.getClassFile() == this.m_class.getMungedFile()) {
                this.addIMarshallableMethod();
            }
            if (this.m_extensions != null) {
                mb = new ContextMethodBuilder(BASEMARSHAL_METHODNAME, Type.VOID, MARSHAL_METHOD_ARGS, cf, 17, 1, "java.lang.Object", 2, MARSHALCONTEXT_INTERFACE);
                mb.addException("org.jibx.runtime.JiBXException");
                mb.loadContext();
                mb.loadObject("org.jibx.runtime.IMarshallable");
                mb.appendCallInterface(GETINDEX_METHOD, PARSERNEXT_SIGNATURE);
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallInterface("org.jibx.runtime.IMarshallingContext.getMarshaller", "(ILjava/lang/String;)Lorg/jibx/runtime/IMarshaller;");
                mb.appendDUP();
                mb.appendLoadConstant(this.getIndex());
                mb.appendCallInterface(CHECKEXTENDS_METHOD, "(I)Z");
                BranchWrapper ifvalid = mb.appendIFNE(this);
                mb.appendCreateNew("java.lang.StringBuffer");
                mb.appendDUP();
                mb.appendLoadConstant("Mapping for type ");
                mb.appendCallInit("java.lang.StringBuffer", "(Ljava/lang/String;)V");
                mb.appendDUP();
                mb.loadObject();
                mb.appendCallVirtual("java.lang.Object.getClass", "()Ljava/lang/Class;");
                mb.appendCallVirtual("java.lang.Class.getName", CURRENTELEMENT_SIGNATURE);
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendDUP();
                mb.appendLoadConstant(" must extend abstract mapping for type " + this.m_class.getClassName());
                mb.appendCallVirtual("java.lang.StringBuffer.append", "(Ljava/lang/String;)Ljava/lang/StringBuffer;");
                mb.appendCallVirtual("java.lang.StringBuffer.toString", CURRENTELEMENT_SIGNATURE);
                mb.appendCreateNew("org.jibx.runtime.JiBXException");
                mb.appendDUP_X1();
                mb.appendSWAP();
                mb.appendCallInit("org.jibx.runtime.JiBXException", "(Ljava/lang/String;)V");
                mb.appendThrow();
                mb.targetNext(ifvalid);
                mb.loadObject();
                mb.loadContext();
                mb.appendCallInterface("org.jibx.runtime.IMarshaller.marshal", "(Ljava/lang/Object;Lorg/jibx/runtime/IMarshallingContext;)V");
                mb.appendReturn();
                mb.codeComplete(false);
                mb.addMethod();
                cf.addInterface("org.jibx.runtime.IAbstractMarshaller");
            }
        }
        this.m_marshaller = this.m_unmarshaller = MungedClass.getUniqueSupportClass(cf);
    }

    public NameDefinition getWrapperName() {
        return this.m_name;
    }

    public void setLinkages() throws JiBXException {
        this.m_component.setLinkages();
        this.m_defContext.setLinkages();
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("mapping class " + this.m_class.getClassFile().getName());
        if (this.m_name != null) {
            System.out.print(" to element " + this.m_name.toString());
        }
        System.out.print(" (#" + this.getIndex() + ')');
        if (this.m_baseMapping != null) {
            System.out.print(" extends " + this.m_baseMapping.getBoundType());
        }
        if (this.m_isAbstract) {
            if (this.m_extensions != null) {
                System.out.print(" (abstract, " + this.m_extensions.size() + " extensions)");
            } else {
                System.out.print(" (abstract)");
            }
        }
        System.out.println();
        this.m_defContext.print(depth + 1);
        this.m_component.print(depth + 1);
    }
}

