/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectGeneric;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.ElementWrapper;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.IMapping;
import org.jibx.binding.def.MappingBase;
import org.jibx.binding.def.MappingDefinition;
import org.jibx.binding.def.MappingDirect;
import org.jibx.binding.def.MappingReference;
import org.jibx.binding.def.NameDefinition;
import org.jibx.binding.def.NamespaceDefinition;
import org.jibx.binding.def.NestedBase;
import org.jibx.binding.def.NestedCollection;
import org.jibx.binding.def.NestedStructure;
import org.jibx.binding.def.ObjectBinding;
import org.jibx.binding.def.ObjectStringConversion;
import org.jibx.binding.def.OptionalStructureWrapper;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.binding.def.StringConversion;
import org.jibx.binding.def.StructureReference;
import org.jibx.binding.def.ValueChild;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.QName;
import org.jibx.runtime.impl.UnmarshallingContext;

public abstract class BindingBuilder {
    private static final String URI_ELEMENTS = null;
    private static final String URI_ATTRIBUTES = null;
    private static final String COMMON_STYLE = "value-style";
    private static final String COMMON_AUTOLINK = "auto-link";
    private static final String COMMON_ACCESSLEVEL = "access-level";
    private static final String COMMON_STRIPPREFIX = "strip-prefix";
    private static final String COMMON_STRIPSUFFIX = "strip-suffix";
    private static final String COMMON_NAMESTYLE = "name-style";
    private static final String COMMON_NAME = "name";
    private static final String COMMON_NAMESPACE = "ns";
    private static final String COMMON_FACTORY = "factory";
    private static final String COMMON_PRESET = "pre-set";
    private static final String COMMON_POSTSET = "post-set";
    private static final String COMMON_PREGET = "pre-get";
    private static final String COMMON_MARSHALLER = "marshaller";
    private static final String COMMON_UNMARSHALLER = "unmarshaller";
    private static final String COMMON_CREATETYPE = "create-type";
    private static final String COMMON_FIELD = "field";
    private static final String COMMON_TYPE = "type";
    private static final String COMMON_USAGE = "usage";
    private static final String COMMON_TESTMETHOD = "test-method";
    private static final String COMMON_GETMETHOD = "get-method";
    private static final String COMMON_SETMETHOD = "set-method";
    private static final String COMMON_DEFAULT = "default";
    private static final String COMMON_SERIALIZER = "serializer";
    private static final String COMMON_DESERIALIZER = "deserializer";
    private static final String COMMON_LABEL = "label";
    private static final String COMMON_USING = "using";
    private static final String COMMON_ORDERED = "ordered";
    private static final String COMMON_CHOICE = "choice";
    private static final String COMMON_FLEXIBLE = "flexible";
    private static final String COMMON_DUPLICATES = "allow-repeats";
    private static final String COMMON_NILLABLE = "nillable";
    private static final String BINDING_ELEMENT = "binding";
    private static final String BINDING_NAME = "name";
    private static final String BINDING_DIRECTION = "direction";
    private static final String BINDING_GLOBALID = "global-id";
    private static final String BINDING_FORWARDS = "forwards";
    private static final String BINDING_PACKAGE = "package";
    private static final String BINDING_TRACKING = "track-source";
    private static final String BINDING_FORCE = "force-classes";
    private static final String NAMESPACE_ELEMENT = "namespace";
    private static final String NAMESPACE_URI = "uri";
    private static final String NAMESPACE_PREFIX = "prefix";
    private static final String NAMESPACE_DEFAULT = "default";
    private static final String FORMAT_ELEMENT = "format";
    private static final String FORMAT_NAME = "label";
    private static final String FORMAT_TYPE = "type";
    private static final String MAPPING_ELEMENT = "mapping";
    private static final String MAPPING_CLASS = "class";
    private static final String MAPPING_ABSTRACT = "abstract";
    private static final String MAPPING_EXTENDS = "extends";
    private static final String MAPPING_TYPENAME = "type-name";
    private static final String VALUE_ELEMENT = "value";
    private static final String VALUE_STYLE = "style";
    private static final String VALUE_FORMAT = "format";
    private static final String VALUE_CONSTANT = "constant";
    private static final String VALUE_IDENT = "ident";
    private static final String STRUCTURE_ELEMENT = "structure";
    private static final String STRUCTURE_MAPAS = "map-as";
    private static final String COLLECTION_ELEMENT = "collection";
    private static final String COLLECTION_LOADMETHOD = "load-method";
    private static final String COLLECTION_SIZEMETHOD = "size-method";
    private static final String COLLECTION_STOREMETHOD = "store-method";
    private static final String COLLECTION_ADDMETHOD = "add-method";
    private static final String COLLECTION_ITERMETHOD = "iter-method";
    private static final String COLLECTION_ITEMTYPE = "item-type";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String INCLUDE_PATH = "path";
    private static final String[] VALUE_STYLE_NAMES = new String[]{"attribute", "cdata", "element", "text"};
    private static final int[] VALUE_STYLE_NUMS = new int[]{0, 3, 1, 2};
    private static final String[] CONTAINING_STYLE_NAMES = new String[]{"attribute", "element"};
    private static final int[] CONTAINING_STYLE_NUMS = new int[]{0, 1};
    static final int LINK_NONE = 0;
    static final int LINK_FIELDS = 1;
    static final int LINK_METHODS = 2;
    private static final String[] AUTO_LINK_NAMES = new String[]{"fields", "none", "methods"};
    private static final int[] AUTO_LINK_NUMS = new int[]{1, 0, 2};
    static final int ACC_PRIVATE = 0;
    static final int ACC_PACKAGE = 1;
    static final int ACC_PROTECTED = 2;
    static final int ACC_PUBLIC = 3;
    private static final String[] ACCESS_LEVEL_NAMES = new String[]{"package", "private", "protected", "public"};
    private static final int[] ACCESS_LEVEL_NUMS = new int[]{1, 0, 2, 3};
    static final int NAME_HYPHENS = 0;
    static final int NAME_MIXED = 1;
    private static final String[] NAME_GENERATE_NAMES = new String[]{"hyphens", "mixed-case"};
    private static final int[] NAME_GENERATE_NUMS = new int[]{0, 1};
    private static final String[] COMPONENT_OBJECT_NAMESPACES = new String[]{URI_ATTRIBUTES, URI_ATTRIBUTES, URI_ATTRIBUTES, URI_ATTRIBUTES};
    private static final String[] COMPONENT_OBJECT_NAMES = new String[]{"factory", "pre-set", "post-set", "pre-get"};
    private static final String[] NAMESPACEACCESS_NAMES = new String[]{"all", "attributes", "elements", "none"};
    private static final int[] NAMESPACEACCESS_NUMS = new int[]{3, 2, 1, 0};
    private static final String[] IDENTTYPE_NAMES = new String[]{"auto", "def", "direct", "ref"};
    private static final int[] IDENTTYPE_NUMS = new int[]{1, 2, 0, 3};
    private static final int DIRECTION_INPUT = 0;
    private static final int DIRECTION_OUTPUT = 1;
    private static final int DIRECTION_BOTH = 2;
    private static final String[] BINDINGDIR_NAMES = new String[]{"both", "input", "output"};
    private static final int[] BINDINGDIR_NUMS = new int[]{2, 0, 1};
    private static final String USAGE_OPTIONAL = "optional";
    private static final String USAGE_REQUIRED = "required";
    private static final String UNMARSHALLER_INTERFACE = "org.jibx.runtime.IUnmarshaller";
    private static final String MARSHALLER_INTERFACE = "org.jibx.runtime.IMarshaller";
    private static final String UNMARSHALLER_INTERFACETYPE = "Lorg/jibx/runtime/IUnmarshaller;";
    private static final String MARSHALLER_INTERFACETYPE = "Lorg/jibx/runtime/IMarshaller;";

    private static boolean isNamePresent(UnmarshallingContext ctx) {
        return ctx.attributeText(URI_ATTRIBUTES, "name", null) != null;
    }

    private static boolean isPropertyPresent(UnmarshallingContext ctx) {
        return ctx.attributeText(URI_ATTRIBUTES, COMMON_FIELD, null) != null || ctx.attributeText(URI_ATTRIBUTES, COMMON_GETMETHOD, null) != null || ctx.attributeText(URI_ATTRIBUTES, COMMON_SETMETHOD, null) != null || ctx.attributeText(URI_ATTRIBUTES, COMMON_TESTMETHOD, null) != null;
    }

    private static boolean isDirectObject(UnmarshallingContext ctx) {
        return ctx.attributeText(URI_ATTRIBUTES, COMMON_MARSHALLER, null) != null || ctx.attributeText(URI_ATTRIBUTES, COMMON_UNMARSHALLER, null) != null;
    }

    private static boolean isMappingRef(UnmarshallingContext ctx) throws JiBXException {
        return ctx.hasAttribute(URI_ATTRIBUTES, STRUCTURE_MAPAS);
    }

    private static boolean isObjectBinding(UnmarshallingContext ctx) throws JiBXException {
        return ctx.hasAnyAttribute(COMPONENT_OBJECT_NAMESPACES, COMPONENT_OBJECT_NAMES);
    }

    private static NameDefinition unmarshalName(UnmarshallingContext ctx, boolean attr) throws JiBXException {
        String name = ctx.attributeText(URI_ATTRIBUTES, "name");
        String ns = ctx.attributeText(URI_ATTRIBUTES, COMMON_NAMESPACE, null);
        return new NameDefinition(name, ns, attr);
    }

    private static NamespaceDefinition unmarshalNamespace(UnmarshallingContext ctx) throws JiBXException {
        String uri = ctx.attributeText(URI_ATTRIBUTES, NAMESPACE_URI);
        String prefix = ctx.attributeText(URI_ATTRIBUTES, NAMESPACE_PREFIX, null);
        if ("".equals(prefix)) {
            prefix = null;
        }
        int usage = ctx.attributeEnumeration(URI_ATTRIBUTES, "default", NAMESPACEACCESS_NAMES, NAMESPACEACCESS_NUMS, 0);
        ctx.parsePastEndTag(URI_ELEMENTS, NAMESPACE_ELEMENT);
        return new NamespaceDefinition(uri, prefix, usage);
    }

    private static StringConversion unmarshalStringConversion(UnmarshallingContext ctx, StringConversion base, String type) throws JiBXException {
        String dflt = ctx.attributeText(URI_ATTRIBUTES, "default", null);
        String ser = ctx.attributeText(URI_ATTRIBUTES, COMMON_SERIALIZER, null);
        String dser = ctx.attributeText(URI_ATTRIBUTES, COMMON_DESERIALIZER, null);
        return base.derive(type, ser, dser, dflt);
    }

    private static boolean isOptionalProperty(UnmarshallingContext ctx) throws JiBXException {
        boolean opt = false;
        String value = ctx.attributeText(URI_ATTRIBUTES, COMMON_USAGE, USAGE_REQUIRED);
        if (USAGE_OPTIONAL.equals(value)) {
            opt = true;
        } else if (!USAGE_REQUIRED.equals(value)) {
            ctx.throwStartTagException("Illegal value for \"usage\" attribute");
        }
        return opt;
    }

    private static PropertyDefinition unmarshalProperty(UnmarshallingContext ctx, IContainer parent, IContextObj cobj, boolean opt) throws JiBXException {
        String type = ctx.attributeText(URI_ATTRIBUTES, "type", null);
        if (!(parent instanceof NestedCollection) && BindingBuilder.isOptionalProperty(ctx)) {
            opt = true;
        }
        PropertyDefinition pdef = null;
        try {
            String fname = ctx.attributeText(URI_ATTRIBUTES, COMMON_FIELD, null);
            String test = ctx.attributeText(URI_ATTRIBUTES, COMMON_TESTMETHOD, null);
            String get = ctx.attributeText(URI_ATTRIBUTES, COMMON_GETMETHOD, null);
            String set = ctx.attributeText(URI_ATTRIBUTES, COMMON_SETMETHOD, null);
            boolean isthis = fname == null && get == null && set == null;
            pdef = new PropertyDefinition(parent, cobj, type, isthis, opt, fname, test, get, set);
        }
        catch (JiBXException ex) {
            ctx.throwStartTagException(ex.getMessage());
        }
        return pdef;
    }

    private static ValueChild unmarshalValue(UnmarshallingContext ctx, IContainer parent, IContextObj cobj, boolean uord, boolean impl, String itype) throws JiBXException {
        boolean nillable;
        int style = ctx.attributeEnumeration(URI_ATTRIBUTES, VALUE_STYLE, VALUE_STYLE_NAMES, VALUE_STYLE_NUMS, parent.getStyleDefault());
        boolean isatt = style == 0;
        NameDefinition name = null;
        if (isatt || style == 1) {
            name = BindingBuilder.unmarshalName(ctx, isatt);
            name.fixNamespace(parent.getDefinitionContext());
        } else if (BindingBuilder.isNamePresent(ctx)) {
            ctx.throwStartTagException("Name not allowed for text or CDATA value");
        }
        String constant = ctx.attributeText(URI_ATTRIBUTES, VALUE_CONSTANT, null);
        int ident = ctx.attributeEnumeration(URI_ATTRIBUTES, VALUE_IDENT, IDENTTYPE_NAMES, IDENTTYPE_NUMS, 0);
        PropertyDefinition prop = null;
        if (ident == 1) {
            ctx.throwStartTagException("Automatic id generation not yet supported");
        } else if (impl) {
            String type = ctx.attributeText(URI_ATTRIBUTES, "type", itype);
            prop = new PropertyDefinition(type, cobj, !(parent instanceof NestedCollection) && BindingBuilder.isOptionalProperty(ctx));
        } else {
            prop = BindingBuilder.unmarshalProperty(ctx, parent, cobj, ctx.hasAttribute(URI_ATTRIBUTES, "default"));
        }
        if (ident != 0 && uord) {
            ctx.throwStartTagException("ident not allowed in unordered structure");
        }
        StringConversion convert = null;
        String type = prop == null || constant != null ? "java.lang.String" : prop.getTypeName();
        String format = ctx.attributeText(URI_ATTRIBUTES, "format", null);
        DefinitionContext defc = parent.getDefinitionContext();
        if (format == null) {
            convert = defc.getSpecificConversion(type);
            if (convert == null) {
                ClassFile target = ClassCache.getClassFile(type);
                convert = defc.getConversion(target);
                boolean isenum = false;
                ClassFile sclas = target;
                while ((sclas = sclas.getSuperFile()) != null) {
                    if (!sclas.getName().equals("java.lang.Enum")) continue;
                    isenum = true;
                    break;
                }
                if (isenum) {
                    String dser = type + '.' + "valueOf";
                    convert = convert.derive(type, null, dser, null);
                } else if (convert.getTypeName().equals("java.lang.Object")) {
                    convert = new ObjectStringConversion(type, (ObjectStringConversion)convert);
                }
            }
        } else {
            String ctype;
            QName qname = QName.deserialize(format, ctx);
            convert = defc.getNamedConversion(qname);
            if (convert == null) {
                ctx.throwStartTagException("Unknown format \"" + format + "\"");
            }
            if (!ClassItem.isAssignable(type, ctype = convert.getTypeName()) && !ClassItem.isAssignable(ctype, type)) {
                ctx.throwStartTagException("Converter type not compatible with value type");
            }
        }
        String dflt = ctx.attributeText(URI_ATTRIBUTES, "default", null);
        String ser = ctx.attributeText(URI_ATTRIBUTES, COMMON_SERIALIZER, null);
        String dser = ctx.attributeText(URI_ATTRIBUTES, COMMON_DESERIALIZER, null);
        if (dflt != null || ser != null || dser != null) {
            convert = convert.derive(type, ser, dser, dflt);
        }
        if (nillable = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_NILLABLE, false)) {
            parent.getBindingRoot().setSchemaInstanceUsed();
        }
        ValueChild value = new ValueChild(parent, cobj, name, prop, convert, style, ident, constant, nillable);
        if (ident == 2 || ident == 1) {
            if (!cobj.setIdChild(value)) {
                ctx.throwStartTagException("Duplicate ID definition for containing mapping");
            } else if (!"java.lang.String".equals(type)) {
                ctx.throwStartTagException("ID property must be a String");
            }
        }
        ctx.parsePastEndTag(URI_ELEMENTS, VALUE_ELEMENT);
        return value;
    }

    private static DirectObject unmarshalDirectObj(UnmarshallingContext ctx, String type, IContainer parent, DefinitionContext defc, int slot, NameDefinition name) throws JiBXException {
        String clas;
        String clas2;
        ClassFile mcf = null;
        if (parent.getBindingRoot().isOutput() && !(mcf = ClassCache.getClassFile(clas2 = ctx.attributeText(URI_ATTRIBUTES, COMMON_MARSHALLER))).isImplements(MARSHALLER_INTERFACETYPE)) {
            ctx.throwStartTagException("Marshaller class " + clas2 + " does not implement required interface " + MARSHALLER_INTERFACE);
        }
        ClassFile ucf = null;
        if (parent.getBindingRoot().isInput() && !(ucf = ClassCache.getClassFile(clas = ctx.attributeText(URI_ATTRIBUTES, COMMON_UNMARSHALLER))).isImplements(UNMARSHALLER_INTERFACETYPE)) {
            ctx.throwStartTagException("Unmarshaller class " + clas + " does not implement required interface " + UNMARSHALLER_INTERFACE);
        }
        if (BindingBuilder.isObjectBinding(ctx)) {
            ctx.throwStartTagException("Other object attributes not allowed when using marshaller or unmarshaller");
        } else if (BindingBuilder.isMappingRef(ctx)) {
            ctx.throwStartTagException("Mapping not allowed when using marshaller or unmarshaller");
        } else if (ctx.hasAttribute(URI_ATTRIBUTES, COMMON_USING)) {
            ctx.throwStartTagException("using attribute not allowed when using marshaller or unmarshaller");
        }
        return new DirectObject(parent, defc, ClassCache.getClassFile(type), false, mcf, ucf, slot, name);
    }

    private static IComponent unmarshalMappingRef(UnmarshallingContext ctx, IContainer parent, IContextObj objc, PropertyDefinition prop, NameDefinition name) throws JiBXException {
        if (BindingBuilder.isObjectBinding(ctx)) {
            ctx.throwStartTagException("Other object attributes not allowed when using mapping reference");
        } else if (ctx.hasAttribute(URI_ATTRIBUTES, COMMON_USING)) {
            ctx.throwStartTagException("using attribute not allowed when using mapping reference");
        }
        String type = prop == null ? null : prop.getTypeName();
        String text = ctx.attributeText(URI_ATTRIBUTES, STRUCTURE_MAPAS, type);
        QName qname = QName.deserialize(text, ctx);
        boolean nillable = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_NILLABLE, false);
        if (nillable) {
            parent.getBindingRoot().setSchemaInstanceUsed();
        }
        return new MappingReference(parent, prop, type, text, qname.toString(), objc, name, false, nillable);
    }

    private static IComponent unmarshalStructureRef(UnmarshallingContext ctx, IContainer contain, NameDefinition name, PropertyDefinition prop, IContextObj cobj) throws JiBXException {
        if (BindingBuilder.isObjectBinding(ctx)) {
            ctx.throwStartTagException("Other object attributes not allowed when using structure reference");
        }
        String ident = ctx.attributeText(URI_ATTRIBUTES, COMMON_USING);
        IComponent comp = new StructureReference(contain, ident, prop, name != null, cobj);
        if (name != null) {
            boolean nillable = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_NILLABLE, false);
            if (nillable) {
                contain.getBindingRoot().setSchemaInstanceUsed();
            }
            comp = new ElementWrapper(contain.getDefinitionContext(), name, comp, nillable);
            if (prop != null && prop.isOptional()) {
                ((ElementWrapper)comp).setOptionalNormal(true);
                ((ElementWrapper)comp).setStructureObject(true);
                comp = new OptionalStructureWrapper(comp, prop, true);
                prop.setOptional(false);
            }
        }
        return comp;
    }

    private static void unmarshalStructureChildren(UnmarshallingContext ctx, NestedBase nest, IContextObj objc, boolean impl, String itype) throws JiBXException {
        boolean uord;
        boolean bl = uord = !nest.isContentOrdered();
        while (true) {
            IComponent comp;
            if (ctx.isAt(URI_ELEMENTS, VALUE_ELEMENT)) {
                ValueChild child;
                comp = child = BindingBuilder.unmarshalValue(ctx, nest, objc, uord, impl, itype);
            } else if (ctx.isAt(URI_ELEMENTS, STRUCTURE_ELEMENT)) {
                comp = BindingBuilder.unmarshalStructure(ctx, nest, objc, false, uord, impl);
            } else {
                if (!ctx.isAt(URI_ELEMENTS, COLLECTION_ELEMENT)) break;
                comp = BindingBuilder.unmarshalStructure(ctx, nest, objc, true, uord, impl);
            }
            nest.addComponent(comp);
        }
    }

    private static ObjectBinding unmarshalObjectBinding(UnmarshallingContext ctx, IContextObj objc, IContainer parent, String type) throws JiBXException {
        String fact = ctx.attributeText(URI_ATTRIBUTES, COMMON_FACTORY, null);
        String pres = ctx.attributeText(URI_ATTRIBUTES, COMMON_PRESET, null);
        String posts = ctx.attributeText(URI_ATTRIBUTES, COMMON_POSTSET, null);
        String preg = ctx.attributeText(URI_ATTRIBUTES, COMMON_PREGET, null);
        String ctype = ctx.attributeText(URI_ATTRIBUTES, COMMON_CREATETYPE, null);
        ObjectBinding bind = null;
        try {
            bind = new ObjectBinding(parent, objc, type, fact, pres, posts, preg, ctype);
        }
        catch (JiBXException ex) {
            ctx.throwStartTagException(ex.getMessage(), ex);
        }
        return bind;
    }

    private static void unmarshalNamespaces(UnmarshallingContext ctx, DefinitionContext defc) throws JiBXException {
        while (ctx.isAt(URI_ELEMENTS, NAMESPACE_ELEMENT)) {
            defc.addNamespace(BindingBuilder.unmarshalNamespace(ctx));
        }
    }

    private static void unmarshalFormats(UnmarshallingContext ctx, DefinitionContext defc) throws JiBXException {
        while (ctx.isAt(URI_ELEMENTS, "format")) {
            String type = ctx.attributeText(URI_ATTRIBUTES, "type");
            String sig = Utility.getSignature(type);
            StringConversion base = null;
            if (sig.length() == 1) {
                base = defc.getSpecificConversion(type);
                if (base == null) {
                    ctx.throwStartTagException("Unsupported \"type\" value");
                }
            } else {
                ClassFile cf = ClassCache.getClassFile(type);
                base = defc.getConversion(cf);
            }
            StringConversion format = BindingBuilder.unmarshalStringConversion(ctx, base, type);
            String text = ctx.attributeText(URI_ATTRIBUTES, "label", null);
            if (text == null) {
                defc.setConversion(format);
            } else {
                QName qname = QName.deserialize(text, ctx);
                defc.setNamedConversion(qname, format);
            }
            ctx.parsePastEndTag(URI_ELEMENTS, "format");
        }
    }

    private static void unmarshalMappings(UnmarshallingContext ctx, IContainer parent, ArrayList nss, boolean uord) throws JiBXException {
        while (ctx.isAt(URI_ELEMENTS, MAPPING_ELEMENT)) {
            BindingBuilder.unmarshalMapping(ctx, parent, nss, uord);
        }
    }

    public static IComponent unmarshalStructure(UnmarshallingContext ctx, IContainer contain, IContextObj cobj, boolean coll, boolean uord, boolean implic) throws JiBXException {
        IComponent comp;
        NameDefinition name = null;
        if (BindingBuilder.isNamePresent(ctx)) {
            name = BindingBuilder.unmarshalName(ctx, false);
        }
        boolean opt = BindingBuilder.isOptionalProperty(ctx);
        boolean incoll = false;
        if (contain instanceof NestedCollection) {
            incoll = true;
            opt = false;
        }
        boolean hasprop = BindingBuilder.isPropertyPresent(ctx);
        boolean thisref = false;
        if (!hasprop) {
            thisref = incoll || ctx.hasAttribute(URI_ATTRIBUTES, "type");
        }
        boolean mapping = BindingBuilder.isMappingRef(ctx);
        if (hasprop || coll || implic || thisref) {
            PropertyDefinition prop = null;
            boolean hasobj = hasprop;
            if (implic) {
                if (hasprop) {
                    ctx.throwStartTagException("Property definition not allowed for collection items");
                } else {
                    String type = ctx.attributeText(URI_ATTRIBUTES, "type", null);
                    if (type == null) {
                        if (!mapping) {
                            if (incoll) {
                                type = ((NestedCollection)contain).getItemType();
                                hasobj = true;
                            } else {
                                type = "java.lang.Object";
                            }
                        }
                    } else {
                        hasobj = true;
                    }
                    prop = new PropertyDefinition(type, cobj, opt);
                }
            } else {
                prop = hasprop || thisref ? BindingBuilder.unmarshalProperty(ctx, contain, cobj, opt) : new PropertyDefinition(cobj, opt);
            }
            if (BindingBuilder.isDirectObject(ctx)) {
                comp = new DirectProperty(prop, BindingBuilder.unmarshalDirectObj(ctx, prop.getTypeName(), contain, null, -1, name));
            } else if (mapping) {
                comp = BindingBuilder.unmarshalMappingRef(ctx, contain, cobj, prop, name);
            } else {
                IContextObj icobj = cobj;
                ObjectBinding bind = null;
                boolean typed = false;
                if (implic) {
                    typed = !prop.getTypeName().equals("java.lang.Object");
                } else {
                    boolean bl = typed = !prop.getTypeName().equals(cobj.getBoundClass().getClassName());
                }
                if (hasobj && !prop.isThis() || !hasobj && typed) {
                    bind = BindingBuilder.unmarshalObjectBinding(ctx, cobj, contain, prop.getTypeName());
                    icobj = bind;
                }
                if (ctx.hasAttribute(URI_ATTRIBUTES, COMMON_USING)) {
                    comp = BindingBuilder.unmarshalStructureRef(ctx, contain, name, prop, icobj);
                } else {
                    NestedBase nest;
                    DefinitionContext defc = contain.getDefinitionContext();
                    IComponent top = bind;
                    String label = ctx.attributeText(URI_ATTRIBUTES, "label", null);
                    NestedCollection.CollectionLoad load = null;
                    NestedCollection.CollectionStore store = null;
                    String itype = null;
                    if (coll) {
                        boolean isdoub;
                        ClassFile cf;
                        String stname = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_STOREMETHOD, null);
                        String aname = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_ADDMETHOD, null);
                        String lname = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_LOADMETHOD, null);
                        String szname = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_SIZEMETHOD, null);
                        String iname = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_ITERMETHOD, null);
                        itype = ctx.attributeText(URI_ATTRIBUTES, COLLECTION_ITEMTYPE, "java.lang.Object");
                        if (!(lname != null && szname != null || lname == null && szname == null)) {
                            ctx.throwStartTagException("load-method and size-method attributes must be used together");
                        }
                        if (iname != null && lname != null) {
                            ctx.throwStartTagException("iter-method and load-method attributes cannot be used together");
                        }
                        if (aname != null && stname != null) {
                            ctx.throwStartTagException("add-method and store-method attributes cannot be used together");
                        }
                        if ((cf = ClassCache.getClassFile(prop.getTypeName())).isSuperclass("java.util.Vector") || cf.isSuperclass("java.util.ArrayList")) {
                            if (stname == null && aname == null) {
                                aname = "add";
                            }
                            if (iname == null && lname == null) {
                                lname = "get";
                                szname = "size";
                            }
                        } else if (cf.isImplements("Ljava/util/Collection;")) {
                            if (stname == null && aname == null) {
                                aname = "add";
                            }
                            if (iname == null && lname == null) {
                                iname = "iterator";
                            }
                        } else if (cf.isArray()) {
                            String ptype = prop.getTypeName();
                            itype = ptype.substring(0, ptype.length() - 2);
                        }
                        BindingDefinition bdef = contain.getBindingRoot();
                        boolean bl = isdoub = "long".equals(itype) || "double".equals(itype);
                        if (bdef.isInput()) {
                            boolean hasval;
                            ClassItem meth;
                            if (aname != null) {
                                meth = cf.getBestMethod(aname, null, new String[]{itype});
                                if (meth == null) {
                                    ctx.throwStartTagException("Add method " + aname + " not found in collection type " + cf.getName());
                                }
                                hasval = !"void".equals(meth.getTypeName());
                                store = new NestedCollection.AddStore(meth, isdoub, hasval);
                            } else if (stname != null) {
                                meth = cf.getBestMethod(stname, null, new String[]{"int", itype});
                                if (meth == null) {
                                    ctx.throwStartTagException("Indexed store method " + stname + " not found in collection type " + cf.getName());
                                }
                                hasval = !"void".equals(meth.getTypeName());
                                store = new NestedCollection.IndexedStore(meth, isdoub, hasval);
                            } else if (cf.isArray()) {
                                store = new NestedCollection.ArrayStore(itype, isdoub);
                            } else {
                                ctx.throwStartTagException("Unknown collection type with no add or store method defined");
                            }
                        }
                        if (bdef.isOutput()) {
                            if (lname != null) {
                                ClassItem lmeth;
                                ClassItem smeth = cf.getMethod(szname, "()I");
                                if (smeth == null) {
                                    ctx.throwStartTagException("Size method " + szname + " not found in collection type " + cf.getName());
                                }
                                if ((lmeth = cf.getBestMethod(lname, itype, new String[]{"int"})) == null) {
                                    ctx.throwStartTagException("Load method " + lname + " not found in collection type " + cf.getName());
                                }
                                load = new NestedCollection.IndexedLoad(smeth, isdoub, lmeth);
                            } else if (iname != null) {
                                String mname = "hasNext";
                                String nname = "next";
                                ClassItem meth = cf.getMethod(iname, "()Ljava/util/Iterator;");
                                if (meth == null) {
                                    mname = "hasMoreElements";
                                    nname = "nextElement";
                                    meth = cf.getMethod(iname, "()Ljava/util/Enumeration;");
                                    if (meth == null) {
                                        ctx.throwStartTagException("Iterator method " + iname + " not found in collection type " + cf.getName());
                                    }
                                }
                                load = new NestedCollection.IteratorLoad(meth, isdoub, "java.util.Iterator." + mname, "java.util.Iterator." + nname);
                            } else if (cf.isArray()) {
                                load = new NestedCollection.ArrayLoad(itype, isdoub);
                            } else {
                                ctx.throwStartTagException("Unknown collection type with no load method defined");
                            }
                        }
                    }
                    boolean ordered = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_ORDERED, true);
                    boolean flex = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_FLEXIBLE, false);
                    boolean nillable = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_NILLABLE, false);
                    if (nillable) {
                        contain.getBindingRoot().setSchemaInstanceUsed();
                    }
                    if (coll) {
                        nest = new NestedCollection(contain, icobj, ordered, opt, flex, itype, load, store);
                        nest.unmarshal(ctx);
                        ctx.parsePastStartTag(URI_ELEMENTS, COLLECTION_ELEMENT);
                    } else {
                        boolean choice = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_CHOICE, false);
                        boolean dupl = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_DUPLICATES, false);
                        nest = new NestedStructure(contain, icobj, ordered, choice, flex, false, hasobj, dupl);
                        nest.unmarshal(ctx);
                        ctx.parsePastStartTag(URI_ELEMENTS, STRUCTURE_ELEMENT);
                    }
                    String ctype = itype == null ? "java.lang.Object" : itype;
                    BindingBuilder.unmarshalFormats(ctx, nest.getDefinitionContext());
                    BindingBuilder.unmarshalMappings(ctx, contain, null, uord);
                    BindingBuilder.unmarshalStructureChildren(ctx, nest, icobj, coll | (implic && !hasobj), ctype);
                    if (top == null) {
                        top = nest;
                    }
                    boolean impstruct = false;
                    boolean childs = nest.hasContent();
                    if (implic && !coll && childs) {
                        ArrayList contents = nest.getContents();
                        impstruct = true;
                        for (int i = 0; i < contents.size(); ++i) {
                            if (!(contents.get(i) instanceof ValueChild)) {
                                impstruct = false;
                                break;
                            }
                            ValueChild vchild = (ValueChild)contents.get(i);
                            if (vchild.isImplicit()) continue;
                            impstruct = false;
                            break;
                        }
                    }
                    if (impstruct) {
                        comp = nest;
                        nest.setObjectContext(cobj);
                        if (name != null) {
                            comp = new ElementWrapper(defc, name, comp, nillable);
                            if (bind != null && implic) {
                                if (!hasprop) {
                                    ArrayList contents = nest.getContents();
                                    impstruct = true;
                                    for (int i = 0; i < contents.size(); ++i) {
                                        if (!(contents.get(i) instanceof ValueChild)) continue;
                                        ValueChild vchild = (ValueChild)contents.get(i);
                                        vchild.switchProperty();
                                    }
                                }
                                prop.setOptional(false);
                            }
                        }
                    } else {
                        boolean addref = false;
                        if (!childs) {
                            if (coll) {
                                if (ctype.equals("java.lang.Object")) {
                                    nest.addComponent(new DirectGeneric(nest, null));
                                } else {
                                    nest.addComponent(new MappingReference(contain, new PropertyDefinition(ctype, cobj, false), ctype, null, null, icobj, null, true, false));
                                }
                                childs = true;
                            } else if (name != null) {
                                addref = true;
                            }
                        }
                        comp = top;
                        if (childs || addref) {
                            boolean optprop;
                            boolean bl = optprop = hasprop && prop.isOptional();
                            if (bind != null) {
                                boolean skip = name != null && optprop;
                                comp = new ComponentProperty(prop, comp, skip);
                                bind.setWrappedComponent(nest);
                            }
                            if (addref) {
                                PropertyDefinition thisprop = new PropertyDefinition(bind, false);
                                nest.addComponent(new MappingReference(nest, thisprop, comp.getType(), null, null, icobj, null, false, false));
                            }
                            if (name != null) {
                                comp = new ElementWrapper(defc, name, comp, nillable);
                                if (bind != null && implic) {
                                    if (!hasprop) {
                                        ((ElementWrapper)comp).setDirect(true);
                                    }
                                    prop.setOptional(false);
                                }
                                if (optprop) {
                                    ((ElementWrapper)comp).setOptionalNormal(true);
                                    boolean isobj = bind != null;
                                    ((ElementWrapper)comp).setStructureObject(isobj);
                                    ((ElementWrapper)comp).setDirect(isobj);
                                    comp = new OptionalStructureWrapper(comp, prop, isobj);
                                    prop.setOptional(false);
                                } else if (opt && !implic) {
                                    ((ElementWrapper)comp).setOptionalNormal(true);
                                    comp = new OptionalStructureWrapper(comp, prop, false);
                                    prop.setOptional(false);
                                }
                            }
                        } else {
                            String type = prop.getTypeName();
                            comp = prop.equals("java.lang.Object") ? new ComponentProperty(prop, new DirectGeneric(contain, null), false) : new MappingReference(contain, prop, type, null, null, icobj, name, false, false);
                        }
                    }
                    if (label != null) {
                        defc.addNamedStructure(label, top);
                    }
                }
            }
        } else {
            if (BindingBuilder.isObjectBinding(ctx)) {
                ctx.throwStartTagException("Object attributes not allowed without property definition");
            } else if (BindingBuilder.isDirectObject(ctx)) {
                ctx.throwStartTagException("Marshaller and unmarshaller not allowed without property definition");
            }
            if (mapping) {
                PropertyDefinition prop = new PropertyDefinition(cobj, opt);
                comp = BindingBuilder.unmarshalMappingRef(ctx, contain, cobj, prop, name);
                implic = true;
            } else if (ctx.hasAttribute(URI_ATTRIBUTES, COMMON_USING)) {
                if (ctx.hasAttribute(URI_ATTRIBUTES, COMMON_ORDERED)) {
                    ctx.throwStartTagException("ordered attribute  not allowed with using attribute");
                }
                comp = BindingBuilder.unmarshalStructureRef(ctx, contain, name, null, cobj);
            } else {
                boolean ordered = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_ORDERED, true);
                boolean choice = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_CHOICE, false);
                boolean flex = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_FLEXIBLE, false);
                boolean dupl = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_DUPLICATES, false);
                NestedStructure nest = new NestedStructure(contain, cobj, ordered, choice, flex, false, hasprop, dupl);
                nest.unmarshal(ctx);
                String label = ctx.attributeText(URI_ATTRIBUTES, "label", null);
                ctx.parsePastStartTag(URI_ELEMENTS, STRUCTURE_ELEMENT);
                BindingBuilder.unmarshalFormats(ctx, nest.getDefinitionContext());
                BindingBuilder.unmarshalMappings(ctx, contain, null, uord);
                BindingBuilder.unmarshalStructureChildren(ctx, nest, cobj, false, "java.lang.Object");
                DefinitionContext defc = contain.getDefinitionContext();
                if (nest.hasContent()) {
                    if (name == null) {
                        comp = nest;
                    } else {
                        comp = new ElementWrapper(defc, name, nest, false);
                        if (opt) {
                            ((ElementWrapper)comp).setOptionalNormal(true);
                            ((ElementWrapper)comp).setStructureObject(true);
                        }
                    }
                    if (label != null) {
                        defc.addNamedStructure(label, nest);
                    }
                } else {
                    if (name == null) {
                        ctx.throwException("Property, name, or child component required");
                    }
                    comp = new ElementWrapper(defc, name, null, false);
                    if (opt) {
                        ((ElementWrapper)comp).setOptionalIgnored(true);
                    }
                }
            }
        }
        ctx.parsePastEndTag(URI_ELEMENTS, coll ? COLLECTION_ELEMENT : STRUCTURE_ELEMENT);
        return comp;
    }

    public static IMapping unmarshalMapping(UnmarshallingContext ctx, IContainer parent, ArrayList nss, boolean uord) throws JiBXException {
        MappingBase mapping;
        boolean abs = ctx.attributeBoolean(URI_ATTRIBUTES, MAPPING_ABSTRACT, false);
        String type = ctx.attributeText(URI_ATTRIBUTES, MAPPING_CLASS);
        NameDefinition name = null;
        if (BindingBuilder.isNamePresent(ctx)) {
            name = BindingBuilder.unmarshalName(ctx, false);
        }
        String text = ctx.attributeText(URI_ATTRIBUTES, MAPPING_TYPENAME, null);
        String tname = null;
        if (text != null) {
            tname = QName.deserialize(text, ctx).toString();
        }
        if (BindingBuilder.isDirectObject(ctx)) {
            DefinitionContext defc = null;
            if (nss != null && nss.size() > 0) {
                defc = new DefinitionContext(parent);
                if (nss != null && nss.size() > 0) {
                    for (int j = 0; j < nss.size(); ++j) {
                        defc.addNamespace((NamespaceDefinition)nss.get(j));
                    }
                }
            }
            int slot = parent.getBindingRoot().getMappedClassIndex(type);
            mapping = new MappingDirect(parent, type, tname, BindingBuilder.unmarshalDirectObj(ctx, type, parent, defc, slot, name), abs);
        } else {
            if (!abs && name == null) {
                ctx.throwStartTagException("Non-abstract mapping must define an element name");
            }
            String label = ctx.attributeText(URI_ATTRIBUTES, "label", null);
            String base = ctx.attributeText(URI_ATTRIBUTES, MAPPING_EXTENDS, null);
            ObjectBinding bind = BindingBuilder.unmarshalObjectBinding(ctx, null, parent, type);
            boolean ordered = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_ORDERED, true);
            boolean choice = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_CHOICE, false);
            boolean flex = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_FLEXIBLE, false);
            boolean nillable = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_NILLABLE, false);
            if (nillable) {
                parent.getBindingRoot().setSchemaInstanceUsed();
            }
            boolean dupl = ctx.attributeBoolean(URI_ATTRIBUTES, COMMON_DUPLICATES, false);
            NestedStructure nest = new NestedStructure(parent, bind, ordered, choice, flex, true, true, dupl);
            nest.unmarshal(ctx);
            DefinitionContext defc = nest.getDefinitionContext();
            if (nss != null && nss.size() > 0) {
                for (int j = 0; j < nss.size(); ++j) {
                    defc.addNamespace((NamespaceDefinition)nss.get(j));
                }
            }
            ctx.parsePastStartTag(URI_ELEMENTS, MAPPING_ELEMENT);
            BindingBuilder.unmarshalNamespaces(ctx, nest.getDefinitionContext());
            BindingBuilder.unmarshalFormats(ctx, nest.getDefinitionContext());
            BindingBuilder.unmarshalMappings(ctx, nest, null, uord);
            BindingBuilder.unmarshalStructureChildren(ctx, nest, bind, false, "java.lang.Object");
            bind.setWrappedComponent(nest);
            mapping = new MappingDefinition(parent, nest.getDefinitionContext(), type, name, tname, abs, base, bind, nillable);
            if (label != null) {
                defc.addNamedStructure(label, bind);
            }
        }
        parent.getDefinitionContext().addMapping(mapping);
        ctx.parsePastEndTag(URI_ELEMENTS, MAPPING_ELEMENT);
        return mapping;
    }

    public static void unmarshalInclude(UnmarshallingContext ctx, BindingDefinition bdef, URL root, ArrayList nslist, HashSet paths) throws JiBXException {
        URL url;
        ctx.parseToStartTag(URI_ELEMENTS, INCLUDE_ELEMENT);
        String path = ctx.attributeText(URI_ATTRIBUTES, INCLUDE_PATH);
        try {
            url = root == null ? new URL(path) : new URL(root, path);
        }
        catch (MalformedURLException e) {
            throw new JiBXException("Unable to handle include path " + path, e);
        }
        String fpath = url.toExternalForm();
        if (paths.add(fpath)) {
            try {
                UnmarshallingContext ictx = new UnmarshallingContext();
                ictx.setDocument(url.openStream(), null);
                ictx.parseToStartTag(URI_ELEMENTS, BINDING_ELEMENT);
                ictx.parsePastStartTag(URI_ELEMENTS, BINDING_ELEMENT);
                ArrayList<NamespaceDefinition> nss = new ArrayList<NamespaceDefinition>(nslist);
                while (ictx.isAt(URI_ELEMENTS, NAMESPACE_ELEMENT)) {
                    nss.add(BindingBuilder.unmarshalNamespace(ictx));
                }
                BindingBuilder.unmarshalFormats(ictx, bdef.getDefinitionContext());
                while (ictx.isAt(URI_ELEMENTS, INCLUDE_ELEMENT)) {
                    BindingBuilder.unmarshalInclude(ictx, bdef, url, nss, paths);
                }
                BindingBuilder.unmarshalMappings(ictx, bdef, nss, false);
            }
            catch (IOException e) {
                throw new JiBXException("Error accessing included binding with path " + path, e);
            }
        }
        ctx.parsePastEndTag(URI_ELEMENTS, INCLUDE_ELEMENT);
    }

    public static BindingDefinition unmarshalBindingDefinition(UnmarshallingContext ctx, String name, URL root) throws JiBXException {
        ctx.parseToStartTag(URI_ELEMENTS, BINDING_ELEMENT);
        name = ctx.attributeText(URI_ATTRIBUTES, "name", name);
        int dir = ctx.attributeEnumeration(URI_ATTRIBUTES, BINDING_DIRECTION, BINDINGDIR_NAMES, BINDINGDIR_NUMS, 2);
        boolean ibind = dir == 2 || dir == 0;
        boolean obind = dir == 2 || dir == 1;
        String tpack = ctx.attributeText(URI_ATTRIBUTES, BINDING_PACKAGE, null);
        boolean glob = ctx.attributeBoolean(URI_ATTRIBUTES, BINDING_GLOBALID, true);
        boolean forward = ctx.attributeBoolean(URI_ATTRIBUTES, BINDING_FORWARDS, true);
        boolean track = ctx.attributeBoolean(URI_ATTRIBUTES, BINDING_TRACKING, false);
        boolean force = ctx.attributeBoolean(URI_ATTRIBUTES, BINDING_FORCE, false);
        BindingDefinition bdef = new BindingDefinition(name, ibind, obind, tpack, glob, forward, track, force);
        bdef.unmarshal(ctx);
        ctx.parsePastStartTag(URI_ELEMENTS, BINDING_ELEMENT);
        ArrayList<NamespaceDefinition> nss = new ArrayList<NamespaceDefinition>();
        while (ctx.isAt(URI_ELEMENTS, NAMESPACE_ELEMENT)) {
            nss.add(BindingBuilder.unmarshalNamespace(ctx));
        }
        BindingBuilder.unmarshalFormats(ctx, bdef.getDefinitionContext());
        HashSet<String> paths = new HashSet<String>();
        if (root != null) {
            paths.add(root.toExternalForm());
        }
        while (ctx.isAt(URI_ELEMENTS, INCLUDE_ELEMENT)) {
            BindingBuilder.unmarshalInclude(ctx, bdef, root, nss, paths);
        }
        BindingBuilder.unmarshalMappings(ctx, bdef, nss, false);
        ctx.parsePastEndTag(URI_ELEMENTS, BINDING_ELEMENT);
        return bdef;
    }

    static class ContainerBase {
        protected IContainer m_container;
        protected int m_styleDefault;
        protected int m_autoLink;
        protected int m_accessLevel;
        protected String m_stripPrefix;
        protected String m_stripSuffix;
        protected int m_nameStyle;

        public ContainerBase(IContainer parent) {
            this.m_container = parent;
        }

        public void unmarshal(UnmarshallingContext ctx) throws JiBXException {
            this.m_styleDefault = ctx.attributeEnumeration(URI_ATTRIBUTES, BindingBuilder.COMMON_STYLE, CONTAINING_STYLE_NAMES, CONTAINING_STYLE_NUMS, this.m_styleDefault);
            this.m_autoLink = ctx.attributeEnumeration(URI_ATTRIBUTES, BindingBuilder.COMMON_AUTOLINK, AUTO_LINK_NAMES, AUTO_LINK_NUMS, this.m_autoLink);
            this.m_accessLevel = ctx.attributeEnumeration(URI_ATTRIBUTES, BindingBuilder.COMMON_ACCESSLEVEL, ACCESS_LEVEL_NAMES, ACCESS_LEVEL_NUMS, this.m_accessLevel);
            this.m_stripPrefix = ctx.attributeText(URI_ATTRIBUTES, BindingBuilder.COMMON_STRIPPREFIX, this.m_stripPrefix);
            this.m_stripSuffix = ctx.attributeText(URI_ATTRIBUTES, BindingBuilder.COMMON_STRIPSUFFIX, this.m_stripSuffix);
            this.m_nameStyle = ctx.attributeEnumeration(URI_ATTRIBUTES, BindingBuilder.COMMON_NAMESTYLE, NAME_GENERATE_NAMES, NAME_GENERATE_NUMS, this.m_nameStyle);
        }

        public int getStyleDefault() {
            if (this.m_styleDefault >= 0) {
                return this.m_styleDefault;
            }
            return this.m_container.getStyleDefault();
        }
    }
}

