/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.jtable;

import jadex.util.jtable.IVisibilityTableColumnModel;
import jadex.util.jtable.VisibilityPopupMenu;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class VisibilityTableColumnModel
extends DefaultTableColumnModel
implements IVisibilityTableColumnModel {
    protected Vector allTableColumns = new Vector();
    protected Vector tableColumnsFixed = new Vector();

    public void addColumn(TableColumn column) {
        this.allTableColumns.addElement(column);
        super.addColumn(column);
    }

    public void removeColumn(TableColumn column) {
        this.allTableColumns.removeElement(column);
        super.removeColumn(column);
    }

    public void moveColumn(int columnIndex, int newIndex) {
        if (columnIndex < 0 || columnIndex >= this.getColumnCount() || newIndex < 0 || newIndex >= this.getColumnCount()) {
            throw new IllegalArgumentException("moveColumn() - Index out of range");
        }
        TableColumn fromColumn = (TableColumn)this.tableColumns.get(columnIndex);
        TableColumn toColumn = (TableColumn)this.tableColumns.get(newIndex);
        int allColumnsOldIndex = this.allTableColumns.indexOf(fromColumn);
        int allColumnsNewIndex = this.allTableColumns.indexOf(toColumn);
        if (columnIndex != newIndex) {
            this.allTableColumns.removeElementAt(allColumnsOldIndex);
            this.allTableColumns.insertElementAt(fromColumn, allColumnsNewIndex);
        }
        super.moveColumn(columnIndex, newIndex);
    }

    public int getAllColumnCount() {
        return this.allTableColumns.size();
    }

    public Enumeration getAllColumns() {
        return this.allTableColumns.elements();
    }

    public int getAllColumnIndex(Object identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier is null");
        }
        Enumeration atc = this.allTableColumns.elements();
        int index = 0;
        while (atc.hasMoreElements()) {
            TableColumn aColumn = (TableColumn)atc.nextElement();
            if (identifier.equals(aColumn.getIdentifier())) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("Identifier not found");
    }

    public TableColumn getAllColumn(int columnIndex) {
        return (TableColumn)this.allTableColumns.elementAt(columnIndex);
    }

    public void setColumnVisible(TableColumn column, boolean visible) {
        if (!visible) {
            super.removeColumn(column);
        } else {
            int noVisibleColumns = this.tableColumns.size();
            int noInvisibleColumns = this.allTableColumns.size();
            int visibleIndex = 0;
            for (int invisibleIndex = 0; invisibleIndex < noInvisibleColumns; ++invisibleIndex) {
                TableColumn visibleColumn = visibleIndex < noVisibleColumns ? (TableColumn)this.tableColumns.get(visibleIndex) : null;
                TableColumn testColumn = (TableColumn)this.allTableColumns.get(invisibleIndex);
                if (testColumn == column) {
                    if (visibleColumn != column) {
                        super.addColumn(column);
                        super.moveColumn(this.tableColumns.size() - 1, visibleIndex);
                    }
                    return;
                }
                if (testColumn != visibleColumn) continue;
                ++visibleIndex;
            }
        }
    }

    public void setAllColumnsVisible() {
        int noColumns = this.allTableColumns.size();
        for (int columnIndex = 0; columnIndex < noColumns; ++columnIndex) {
            TableColumn invisibleColumn;
            TableColumn visibleColumn = columnIndex < this.tableColumns.size() ? (TableColumn)this.tableColumns.get(columnIndex) : null;
            if (visibleColumn == (invisibleColumn = (TableColumn)this.allTableColumns.get(columnIndex))) continue;
            super.addColumn(invisibleColumn);
            super.moveColumn(this.tableColumns.size() - 1, columnIndex);
        }
    }

    public boolean isColumnVisible(TableColumn aColumn) {
        return this.tableColumns.contains(aColumn);
    }

    public void setColumnChangeable(TableColumn column, boolean changeable) {
        this.tableColumnsFixed.remove(column);
        if (!changeable) {
            this.tableColumnsFixed.addElement(column);
        }
    }

    public boolean isColumnChangeable(TableColumn column) {
        return !this.tableColumnsFixed.contains(column);
    }

    public void addMouseListener(final JTable table) {
        table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 1 && event.getButton() == 3) {
                    VisibilityPopupMenu popupMenu = new VisibilityPopupMenu(table);
                    popupMenu.show(table, event.getX(), event.getY());
                }
            }
        });
    }
}

