/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.jtable;

import jadex.util.jtable.IVisibilityTableColumnModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.TableColumn;

public class VisibilityPopupMenu
extends JPopupMenu {
    private IVisibilityTableColumnModel model;

    public VisibilityPopupMenu(JTable table) {
        if (!(table.getColumnModel() instanceof IVisibilityTableColumnModel)) {
            throw new IllegalArgumentException("Jtable has no IVisibilityTableColumnModel");
        }
        this.model = (IVisibilityTableColumnModel)((Object)table.getColumnModel());
    }

    public void show(Component invoker, int x, int y) {
        this.removeAll();
        this.addMenuItems();
        super.show(invoker, x, y);
    }

    private void addMenuItems() {
        Enumeration eac = this.model.getAllColumns();
        while (eac.hasMoreElements()) {
            TableColumn column = (TableColumn)eac.nextElement();
            JCheckBoxMenuItem item = new JCheckBoxMenuItem((String)column.getIdentifier());
            item.setSelected(this.model.isColumnVisible(column));
            item.setEnabled(this.model.isColumnChangeable(column));
            item.addActionListener(new MenuItemActionListener());
            this.add(item);
        }
        this.addSeparator();
        JMenuItem showAll = new JMenuItem("Show all columns");
        showAll.addActionListener(new ShowAllActionListener());
        this.add(showAll);
    }

    private class ShowAllActionListener
    implements ActionListener {
        private ShowAllActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Enumeration eac = VisibilityPopupMenu.this.model.getAllColumns();
            while (eac.hasMoreElements()) {
                TableColumn column = (TableColumn)eac.nextElement();
                if (!VisibilityPopupMenu.this.model.isColumnChangeable(column)) continue;
                VisibilityPopupMenu.this.model.setColumnVisible(column, true);
            }
        }
    }

    private class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JCheckBoxMenuItem item = (JCheckBoxMenuItem)e.getSource();
                TableColumn column = VisibilityPopupMenu.this.model.getAllColumn(VisibilityPopupMenu.this.getComponentIndex(item));
                VisibilityPopupMenu.this.model.setColumnVisible(column, item.isSelected());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

