/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.jtable;

import jadex.util.jtable.ISorterFilterTableModel;
import jadex.util.jtable.SortArrowIcon;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;

public class SortHeaderRenderer
extends DefaultTableCellRenderer {
    public static Icon ASCENDING = new SortArrowIcon(2);
    public static Icon DECENDING = new SortArrowIcon(1);

    public SortHeaderRenderer() {
        this.setHorizontalTextPosition(2);
        this.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        int index = -1;
        int direction = 0;
        if (table != null) {
            JTableHeader header;
            if (table.getModel() instanceof ISorterFilterTableModel) {
                ISorterFilterTableModel model = (ISorterFilterTableModel)table.getModel();
                index = table.convertColumnIndexToView(model.getSortColumn());
                direction = model.getSortDirection();
            }
            if ((header = table.getTableHeader()) != null) {
                this.setForeground(header.getForeground());
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
        }
        this.setIcon(col == index && direction != 0 ? new SortArrowIcon(direction) : null);
        this.setText(value == null ? "" : value.toString());
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        return this;
    }
}

