/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.collection.SCollection;
import jadex.util.concurrent.Executor;
import jadex.util.concurrent.ITimedObject;
import jadex.util.concurrent.ITimerService;
import java.util.Collections;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class TimerService
extends Executor
implements ITimerService {
    protected Map entries = SCollection.createHashMap();
    protected SortedSet timetable = Collections.synchronizedSortedSet(new TreeSet());

    public synchronized void addEntry(ITimedObject to, long time) {
        Entry entry = (Entry)this.entries.get(to);
        if (entry != null) {
            this.timetable.remove(entry);
            entry.time = time;
            this.timetable.add(entry);
        } else {
            entry = new Entry(to, time);
            this.entries.put(to, entry);
            this.timetable.add(entry);
        }
        this.execute();
    }

    public synchronized void removeEntry(ITimedObject to) {
        Entry entry = (Entry)this.entries.remove(to);
        if (entry != null) {
            this.timetable.remove(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean code() {
        long diff;
        Entry next;
        TimerService timerService = this;
        synchronized (timerService) {
            if (this.timetable.isEmpty()) {
                return false;
            }
            next = (Entry)this.timetable.first();
            diff = next.time - System.currentTimeMillis();
            if (diff > 0L) {
                try {
                    this.wait(diff);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (diff <= 0L) {
            this.removeEntry(next.to);
            if (next == null) {
                throw new RuntimeException("next is null");
            }
            if (next.to == null) {
                throw new RuntimeException("next.to is null");
            }
            next.to.timeEventOccurred();
        }
        return !this.timetable.isEmpty();
    }

    public synchronized void execute() {
        super.execute();
        this.notify();
    }

    public synchronized void shutdown() {
        super.shutdown();
        this.notify();
    }

    static class Entry
    implements Comparable {
        protected ITimedObject to;
        protected long time;

        public Entry(ITimedObject to, long time) {
            this.to = to;
            this.time = time;
        }

        public int compareTo(Object o) {
            Entry entry = (Entry)o;
            int ret = (int)(this.time - entry.time);
            if (ret == 0 && entry != this) {
                ret = this.hashCode() - entry.hashCode();
            }
            return ret;
        }

        public String toString() {
            return "Timer.Entry(" + this.to + ", " + this.time + ")";
        }
    }
}

