/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.concurrent.IThreadPool;
import jadex.util.concurrent.ThreadPoolFactory;

public class ThreadTest {
    public static void main(String[] args) {
        new ThreadTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadTest() {
        IThreadPool tp = ThreadPoolFactory.getThreadPool();
        MyTask[] tasks = new MyTask[10];
        MyMonitor[] monitors = new MyMonitor[tasks.length];
        for (int i = 0; i < monitors.length; ++i) {
            monitors[i] = new MyMonitor();
        }
        while (true) {
            int num = (int)(Math.random() * (double)tasks.length);
            System.out.println("now scheduling: " + num);
            MyMonitor myMonitor = monitors[num];
            synchronized (myMonitor) {
                monitors[num].setRunning(true);
                if (tasks[num] == null) {
                    tasks[num] = new MyTask("" + num, monitors[num]);
                    tp.execute(tasks[num]);
                } else {
                    monitors[num].notify();
                }
                Thread.currentThread();
                Thread.yield();
                System.out.println("sleeping scheduler");
                try {
                    monitors[num].wait(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (monitors[num].isRunning()) {
                    System.out.println("Thread was interrupted: " + num);
                }
            }
        }
    }

    class MyMonitor {
        protected boolean running = true;

        public boolean isRunning() {
            return this.running;
        }

        public void setRunning(boolean running) {
            this.running = running;
        }
    }

    class MyTask
    implements Runnable {
        protected String name;
        protected MyMonitor monitor;

        public MyTask(String name, MyMonitor monitor) {
            this.name = name;
            this.monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            System.out.println("here: " + this);
            MyMonitor myMonitor = this.monitor;
            // MONITORENTER : myMonitor
            // MONITOREXIT : myMonitor
            System.out.println("first woken up: " + this);
            while (true) {
                try {
                    Thread.currentThread();
                    Thread.sleep(3000L);
                    myMonitor = this.monitor;
                    // MONITORENTER : myMonitor
                    System.out.println("sleeping: " + this);
                    this.monitor.setRunning(false);
                    this.monitor.notify();
                    this.monitor.wait();
                    // MONITOREXIT : myMonitor
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.out.println("woken up: " + this);
            }
        }

        public String toString() {
            return this.name;
        }
    }
}

