/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.DynamicURLClassLoader;
import jadex.util.SReflect;
import jadex.util.collection.ArrayBlockingQueue;
import jadex.util.collection.IBlockingQueue;
import jadex.util.concurrent.IThreadPool;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ThreadPool
implements IThreadPool,
Runnable {
    protected static final long THREAD_TIMEOUT = -1L;
    protected static int threadcnt = 0;
    protected int min;
    protected int max;
    protected List pool;
    protected IBlockingQueue tasks;
    protected boolean running;
    protected int capacity;
    protected Map threads;
    static int cnt = 0;

    public ThreadPool() {
        this(10, -1);
    }

    private ThreadPool(int min, int max) {
        this.min = min;
        this.max = max;
        this.running = true;
        this.capacity = 0;
        this.tasks = new ArrayBlockingQueue();
        this.pool = new Vector();
        this.threads = new Hashtable();
        this.addThreads(min);
    }

    public synchronized void execute(Runnable task) {
        if (!this.running) {
            throw new RuntimeException("Thread pool not running: " + this);
        }
        --this.capacity;
        if (this.capacity < 0 && (this.max == -1 || this.pool.size() < this.max)) {
            this.addThreads(1);
        }
        this.tasks.enqueue(task);
    }

    public void dispose() {
        this.running = false;
        this.tasks.setClosed(true);
        Thread.yield();
        for (int i = 0; i < this.pool.size(); ++i) {
            Thread t = (Thread)this.pool.get(i);
            t.stop();
        }
    }

    public static void main(String[] args) {
        ThreadPool tp = new ThreadPool(2, 5);
        for (int i = 0; i < 20; ++i) {
            tp.execute(new Runnable(){
                int n = cnt++;

                public void run() {
                    String t = Thread.currentThread().toString();
                    System.out.println("a_" + this + " : " + t);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("b_" + this + " : " + t);
                }

                public String toString() {
                    return "Task_" + this.n;
                }
            });
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(SReflect.getInnerClassName(this.getClass()));
        buf.append("(min=");
        buf.append(this.min);
        buf.append(" max=");
        buf.append(this.max);
        buf.append(", poolsize=");
        buf.append(this.pool.size());
        buf.append(", running=");
        buf.append(this.running);
        buf.append(")");
        return buf.toString();
    }

    protected void addThreads(int num) {
        this.capacity += num;
        for (int i = 0; i < num; ++i) {
            ServiceThread thread = new ServiceThread();
            this.pool.add(thread);
            thread.start();
        }
    }

    public Thread getThread(Runnable task) {
        return (Thread)this.threads.get(task);
    }

    public Runnable getTask(Thread thread) {
        Runnable ret = null;
        if (thread instanceof ServiceThread) {
            ret = ((ServiceThread)thread).getTask();
        }
        return ret;
    }

    public void run() {
        int longrunning = 10000;
        while (true) {
            int i;
            try {
                Thread.sleep(longrunning);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ArrayList<String> longrunners = new ArrayList<String>();
            int cnt = 0;
            for (i = 0; i < this.pool.size(); ++i) {
                ServiceThread st = (ServiceThread)this.pool.get(i);
                long time = st.getTaskExecutionTime();
                if (time <= (long)((int)((double)longrunning * 0.9))) continue;
                longrunners.add(++cnt + ". (" + time / 1000L + "s): " + st.getName());
            }
            System.out.println("\n-----------------------------------");
            System.out.println("Threadpool longrunners: ");
            for (i = 0; i < longrunners.size(); ++i) {
                System.out.println(longrunners.get(i));
            }
            System.out.println("-----------------------------------\n");
        }
    }

    public class ServiceThread
    extends Thread {
        protected Runnable task;
        protected long start;

        public ServiceThread() {
            super("ServiceThread_" + ++threadcnt);
            try {
                this.setContextClassLoader(DynamicURLClassLoader.getInstance());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (ThreadPool.this.running) {
                Object var3_5;
                try {
                    try {
                        this.task = (Runnable)ThreadPool.this.tasks.dequeue(-1L);
                        ThreadPool.this.threads.put(this.task, this);
                        this.start = System.currentTimeMillis();
                        this.setName(this.task.toString());
                        try {
                            this.task.run();
                        }
                        catch (ThreadDeath e) {
                            // empty catch block
                        }
                        ++ThreadPool.this.capacity;
                    }
                    catch (IBlockingQueue.ClosedException e) {
                        var3_5 = null;
                        if (this.task == null) continue;
                        ThreadPool.this.threads.remove(this.task);
                        this.task = null;
                        continue;
                    }
                    catch (IBlockingQueue.TimeoutException e) {
                        if (ThreadPool.this.capacity > ThreadPool.this.min) {
                            --ThreadPool.this.capacity;
                            System.out.println("Thread timeout (queue): " + this);
                            var3_5 = null;
                            if (this.task == null) break;
                            ThreadPool.this.threads.remove(this.task);
                            this.task = null;
                            break;
                        }
                        var3_5 = null;
                        if (this.task == null) continue;
                        ThreadPool.this.threads.remove(this.task);
                        this.task = null;
                        continue;
                    }
                    var3_5 = null;
                    if (this.task == null) continue;
                    ThreadPool.this.threads.remove(this.task);
                }
                catch (Throwable throwable) {
                    var3_5 = null;
                    if (this.task != null) {
                        ThreadPool.this.threads.remove(this.task);
                        this.task = null;
                    }
                    throw throwable;
                }
                this.task = null;
            }
            ThreadPool.this.pool.remove(this);
        }

        public Runnable getTask() {
            return this.task;
        }

        public long getTaskExecutionTime() {
            long ret = 0L;
            if (this.task != null) {
                ret = System.currentTimeMillis() - this.start;
            }
            return ret;
        }
    }
}

