/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.collection.SCollection;
import jadex.util.concurrent.AbstractExecutorService;
import jadex.util.concurrent.Executor;
import jadex.util.concurrent.IExecutable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class SyncExecutorService
extends AbstractExecutorService {
    protected Set wanttorun = Collections.synchronizedSet(SCollection.createLinkedHashSet());
    protected Map running = Collections.synchronizedMap(SCollection.createLinkedHashMap());
    protected Set cancelled = Collections.synchronizedSet(SCollection.createLinkedHashSet());
    protected Executor executor = new Executor(new IExecutable(){

        public boolean execute() {
            IExecutable[] tasks = SyncExecutorService.this.wanttorun.toArray(new IExecutable[SyncExecutorService.this.wanttorun.size()]);
            for (int i = 0; i < tasks.length; ++i) {
                SyncExecutorService.this.running.put(tasks[i], Boolean.FALSE);
                boolean again = tasks[i].execute();
                if (!(again |= ((Boolean)SyncExecutorService.this.running.remove(tasks[i])).booleanValue()) || SyncExecutorService.this.cancelled.contains(tasks[i])) {
                    SyncExecutorService.this.wanttorun.remove(tasks[i]);
                }
                SyncExecutorService.this.cancelled.remove(tasks[i]);
            }
            return SyncExecutorService.this.wanttorun.size() > 0;
        }
    });
    protected boolean suspended;

    public void doExecute(IExecutable task) {
        if (!(this.cancelled.contains(task) || this.wanttorun.contains(task) && !this.running.containsKey(task))) {
            Boolean wtr = (Boolean)this.running.get(task);
            if (wtr != null && !wtr.booleanValue()) {
                this.running.put(task, Boolean.TRUE);
            } else {
                this.wanttorun.add(task);
            }
            if (!this.suspended) {
                this.executor.execute();
            }
        }
    }

    public void doCancel(IExecutable task) {
        this.wanttorun.remove(task);
        if (this.running.containsKey(task)) {
            this.cancelled.add(task);
        }
    }

    public void doSuspend(IExecutable task) {
        this.doCancel(task);
    }

    public synchronized void suspend() {
        if (this.isShutdowned()) {
            return;
        }
        this.suspended = true;
    }

    public synchronized void resume() {
        if (this.isShutdowned()) {
            return;
        }
        this.suspended = false;
        this.executor.execute();
    }

    public void shutdown() {
        if (this.isShutdowned()) {
            return;
        }
        super.shutdown();
        this.wanttorun = null;
        this.running = null;
        this.cancelled = null;
        this.executor.shutdown();
    }
}

