/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.concurrent.IExecutable;
import jadex.util.concurrent.ThreadPoolFactory;

public class Executor
implements Runnable {
    protected boolean running;
    protected boolean wanttorun;
    protected boolean shutdown;
    protected boolean suspended;
    protected IExecutable executable;

    public Executor() {
    }

    public Executor(IExecutable executable) {
        this.executable = executable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean iwanttorun = true;
        while (iwanttorun && !this.shutdown && !this.suspended) {
            iwanttorun = this.code();
            Executor executor = this;
            synchronized (executor) {
                this.running = iwanttorun = iwanttorun || this.wanttorun;
                this.wanttorun = false;
            }
        }
        this.running = false;
    }

    public synchronized void execute() {
        this.wanttorun = true;
        if (!this.running && !this.shutdown) {
            this.running = true;
            ThreadPoolFactory.getThreadPool().execute(this);
        }
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
        this.execute();
    }

    public void shutdown() {
        this.shutdown = true;
    }

    protected boolean code() {
        return this.executable.execute();
    }
}

