/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.collection.SCollection;
import jadex.util.concurrent.Executor;
import jadex.util.concurrent.ICommand;
import java.util.List;

public class AsyncManager {
    protected boolean async;
    protected List requests;
    protected boolean closed;
    protected Executor executor;

    public AsyncManager(boolean async) {
        this.setAsync(async);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ICommand com, Object args) {
        if (this.closed) {
            throw new RuntimeException("AsyncManager already closed.");
        }
        if (this.async) {
            List list = this.requests;
            synchronized (list) {
                this.requests.add(new Object[]{com, args});
            }
            this.executor.execute();
        } else {
            com.execute(args);
        }
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
        if (async) {
            this.requests = SCollection.createArrayList();
            this.executor = new Executor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean code() {
                    List list = AsyncManager.this.requests;
                    synchronized (list) {
                        if (AsyncManager.this.requests.size() > 0) {
                            Object[] req = (Object[])AsyncManager.this.requests.remove(0);
                            ((ICommand)req[0]).execute(req[1]);
                        }
                        return AsyncManager.this.requests.size() > 0;
                    }
                }
            };
        } else {
            this.requests = null;
            this.executor = null;
        }
    }

    public void shutdown() {
        this.closed = true;
        if (this.executor != null) {
            this.executor.shutdown();
        }
        this.executor = null;
    }
}

