/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.collection.SCollection;
import jadex.util.concurrent.AbstractExecutorService;
import jadex.util.concurrent.Executor;
import jadex.util.concurrent.IExecutable;
import java.util.Collections;
import java.util.Map;

public class AsyncExecutorService
extends AbstractExecutorService {
    protected Map executors = Collections.synchronizedMap(SCollection.createHashMap());
    protected boolean shutdown;

    public void doExecute(final IExecutable task) {
        Executor exe = (Executor)this.executors.get(task);
        if (exe == null) {
            exe = new Executor(){

                protected boolean code() {
                    return task.execute();
                }

                public String toString() {
                    return "AsyncExecutable(" + task.toString() + ")";
                }
            };
            this.executors.put(task, exe);
        }
        exe.execute();
    }

    public void doCancel(IExecutable task) {
        Executor exe = (Executor)this.executors.get(task);
        if (exe != null) {
            exe.shutdown();
            this.executors.remove(task);
        }
    }

    public synchronized void suspend() {
        if (this.isShutdowned()) {
            return;
        }
        IExecutable[] keys = this.executors.keySet().toArray(new IExecutable[this.executors.size()]);
        for (int i = 0; i < keys.length; ++i) {
            this.suspend(keys[i]);
        }
    }

    public synchronized void resume() {
        if (this.isShutdowned()) {
            return;
        }
        IExecutable[] keys = this.executors.keySet().toArray(new IExecutable[this.executors.size()]);
        for (int i = 0; i < keys.length; ++i) {
            this.resume(keys[i]);
        }
    }

    public void doSuspend(IExecutable task) {
        Executor exe = (Executor)this.executors.get(task);
        if (exe != null) {
            exe.suspend();
        }
    }

    public void doResume(IExecutable task) {
        Executor exe = (Executor)this.executors.get(task);
        if (exe != null) {
            exe.resume();
        }
    }

    public synchronized void shutdown() {
        if (this.isShutdowned()) {
            return;
        }
        this.shutdown = true;
        IExecutable[] keys = this.executors.keySet().toArray(new IExecutable[this.executors.size()]);
        for (int i = 0; i < keys.length; ++i) {
            Executor exe = (Executor)this.executors.get(keys[i]);
            if (exe == null) continue;
            exe.shutdown();
        }
        this.executors = null;
    }
}

