/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.concurrent;

import jadex.util.collection.SCollection;
import jadex.util.concurrent.IExecutable;
import jadex.util.concurrent.IExecutorService;
import java.util.Collections;
import java.util.Set;

public abstract class AbstractExecutorService
implements IExecutorService {
    protected Set suspended = Collections.synchronizedSet(SCollection.createHashSet());
    protected boolean shutdown;

    public void execute(IExecutable task) {
        if (this.isShutdowned()) {
            return;
        }
        if (!this.suspended.contains(task)) {
            this.doExecute(task);
        }
    }

    public void cancel(IExecutable task) {
        if (this.isShutdowned()) {
            return;
        }
        this.suspended.remove(task);
        this.doCancel(task);
    }

    public void suspend(IExecutable task) {
        if (this.isShutdowned()) {
            return;
        }
        if (!this.suspended.contains(task)) {
            this.suspended.add(task);
            this.doSuspend(task);
        }
    }

    public void resume(IExecutable task) {
        if (this.isShutdowned()) {
            return;
        }
        if (this.suspended.remove(task)) {
            this.doResume(task);
            this.execute(task);
        }
    }

    public void doSuspend(IExecutable task) {
    }

    public void doResume(IExecutable task) {
    }

    public boolean isSuspended(IExecutable task) {
        return this.suspended.contains(task);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public boolean isShutdowned() {
        return this.shutdown;
    }

    public abstract void doCancel(IExecutable var1);

    public abstract void doExecute(IExecutable var1);
}

