/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.WeakObject;
import jadex.util.collection.SCollection;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class WeakSet
extends AbstractSet
implements Serializable {
    protected transient Set set;
    protected transient ReferenceQueue queue = new ReferenceQueue();
    protected Set serialized_set;

    public WeakSet() {
        this.set = SCollection.createHashSet();
    }

    public int size() {
        this.expungeStaleEntries();
        return this.set.size();
    }

    public Iterator iterator() {
        this.expungeStaleEntries();
        return new Iterator(){
            Iterator iter;
            Object next;
            {
                this.iter = WeakSet.this.set.iterator();
                this.next = null;
            }

            public boolean hasNext() {
                while (this.next == null && this.iter.hasNext()) {
                    this.next = ((WeakObject)this.iter.next()).get();
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            public void remove() {
                throw new UnsupportedOperationException("Remove method not supported for iterator of weak set.");
            }
        };
    }

    public Object[] toArray() {
        Object[] result = new Object[this.size()];
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        if (i < result.length) {
            Object[] result2 = new Object[i];
            System.arraycopy(result, 0, result2, 0, i);
            result = result2;
        }
        return result;
    }

    public Object[] toArray(Object[] result) {
        int size = this.size();
        if (result.length < size) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), size);
        }
        int i = 0;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            result[i] = it.next();
            ++i;
        }
        if (i < result.length) {
            Object[] result2 = (Object[])Array.newInstance(result.getClass().getComponentType(), i);
            System.arraycopy(result, 0, result2, 0, i);
            result = result2;
        }
        return result;
    }

    public boolean add(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Must not be null.");
        }
        this.expungeStaleEntries();
        return this.set.add(new WeakObject(obj, this.queue));
    }

    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.set.isEmpty();
    }

    public boolean contains(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Must not be null.");
        }
        this.expungeStaleEntries();
        return this.set.contains(new WeakObject(obj));
    }

    public boolean remove(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Must not be null.");
        }
        this.expungeStaleEntries();
        return this.set.remove(new WeakObject(obj));
    }

    public void clear() {
        this.serialized_set = null;
        this.set.clear();
    }

    public Object clone() {
        this.expungeStaleEntries();
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected final void expungeStaleEntries() {
        WeakObject weak;
        this.serialized_set = null;
        while ((weak = (WeakObject)this.queue.poll()) != null) {
            this.set.remove(weak);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.expungeStaleEntries();
        this.serialized_set = SCollection.createHashSet();
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            Object next = ((WeakObject)it.next()).get();
            if (next == null) continue;
            this.serialized_set.add(next);
        }
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.set = SCollection.createHashSet();
        this.queue = new ReferenceQueue();
        Iterator it = this.serialized_set.iterator();
        while (it.hasNext()) {
            this.set.add(new WeakObject(it.next(), this.queue));
        }
        this.serialized_set = null;
        return this;
    }
}

