/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class WeakList
implements List,
Serializable {
    protected transient Reference[] array = new Reference[10];
    protected int size = 0;
    protected int state = 0;
    private transient ReferenceQueue queue = new ReferenceQueue();
    protected List serialized_list;

    public int size() {
        this.expungeStaleEntries();
        return this.size;
    }

    public boolean isEmpty() {
        this.expungeStaleEntries();
        return this.size == 0;
    }

    public boolean contains(Object o) {
        this.expungeStaleEntries();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i].get())) continue;
            return true;
        }
        return false;
    }

    public Iterator iterator() {
        this.expungeStaleEntries();
        return new Iterator(){
            int i = 0;
            int removeindex = -1;
            int startstate;
            Object next;
            {
                this.startstate = WeakList.this.state;
                this.next = null;
            }

            public boolean hasNext() {
                if (this.startstate != WeakList.this.state) {
                    throw new ConcurrentModificationException("List must not be modified while iterating.");
                }
                if (this.next == null && this.i < WeakList.this.size) {
                    this.next = WeakList.this.array[this.i].get();
                    while (this.next == null && this.i < WeakList.this.size) {
                        ++this.i;
                        this.next = WeakList.this.array[this.i].get();
                    }
                }
                return this.next != null;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements in iterator.");
                }
                Object ret = this.next;
                this.removeindex = this.i++;
                this.next = null;
                return ret;
            }

            public void remove() {
                if (this.removeindex == -1) {
                    throw new IllegalStateException("Remove can only be called once after a call to next() method.");
                }
                if (this.startstate != WeakList.this.state) {
                    throw new ConcurrentModificationException("List must not be modified while iterating.");
                }
                WeakList.this.remove(this.removeindex);
                this.removeindex = -1;
                this.startstate = WeakList.this.state;
            }
        };
    }

    public Object[] toArray() {
        this.expungeStaleEntries();
        Object[] ret = new Object[this.size];
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object o = this.array[i].get();
            if (o == null) continue;
            ret[index++] = o;
        }
        if (index < this.size) {
            Object[] ret2 = new Object[index];
            System.arraycopy(ret, 0, ret2, 0, index);
            ret = ret2;
        }
        return ret;
    }

    public Object[] toArray(Object[] ret) {
        this.expungeStaleEntries();
        if (ret.length < this.size) {
            ret = (Object[])Array.newInstance(ret.getClass().getComponentType(), this.size);
        }
        int index = 0;
        for (int i = 0; i < this.size; ++i) {
            Object o = this.array[i].get();
            if (o == null) continue;
            ret[index++] = o;
        }
        if (index < this.size) {
            Object[] ret2 = (Object[])Array.newInstance(ret.getClass().getComponentType(), index);
            System.arraycopy(ret, 0, ret2, 0, index);
            ret = ret2;
        }
        return ret;
    }

    public boolean add(Object o) {
        this.expungeStaleEntries();
        if (o == null) {
            throw new NullPointerException("Null elements not supported.");
        }
        if (this.array.length == this.size) {
            Reference[] array2 = new Reference[this.array.length * 2];
            System.arraycopy(this.array, 0, array2, 0, this.size);
            this.array = array2;
        }
        this.array[this.size++] = new WeakReference<Object>(o, this.queue);
        ++this.state;
        return true;
    }

    public boolean remove(Object o) {
        this.expungeStaleEntries();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i].get())) continue;
            --this.size;
            if (i < this.size) {
                System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
            }
            this.array[this.size] = null;
            ++this.state;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int index, Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.expungeStaleEntries();
        while (this.queue.poll() != null) {
        }
        for (int i = 0; i < this.size; ++i) {
            this.array[i] = null;
        }
        this.size = 0;
        ++this.state;
    }

    public Object get(int index) {
        Object ret;
        this.expungeStaleEntries();
        while ((ret = this.array[index++].get()) == null) {
        }
        return ret;
    }

    public Object set(int index, Object o) {
        Object ret;
        this.expungeStaleEntries();
        if (o == null) {
            throw new NullPointerException("Null elements not supported.");
        }
        while ((ret = this.array[index].get()) == null) {
            ++index;
        }
        this.array[index] = new WeakReference<Object>(o, this.queue);
        ++this.state;
        return ret;
    }

    public void add(int index, Object o) {
        this.expungeStaleEntries();
        if (o == null) {
            throw new NullPointerException("Null elements not supported.");
        }
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("size=" + this.size + ", index=" + index);
        }
        if (this.array.length == this.size) {
            Reference[] array2 = new Reference[this.array.length * 2];
            if (index > 0) {
                System.arraycopy(this.array, 0, array2, 0, index);
            }
            if (index < this.size - 1) {
                System.arraycopy(this.array, index, array2, index + 1, this.size - index);
            }
            this.array = array2;
        } else {
            System.arraycopy(this.array, index, this.array, index + 1, this.size - index);
        }
        this.array[index] = new WeakReference<Object>(o, this.queue);
        ++this.size;
        ++this.state;
    }

    public Object remove(int index) {
        Object ret;
        this.expungeStaleEntries();
        while ((ret = this.array[index].get()) == null) {
            ++index;
        }
        --this.size;
        if (index < this.size) {
            System.arraycopy(this.array, index + 1, this.array, index, this.size - index);
        }
        this.array[this.size] = null;
        ++this.state;
        return ret;
    }

    public int indexOf(Object o) {
        this.expungeStaleEntries();
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.array[i].get())) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        this.expungeStaleEntries();
        for (int i = this.size - 1; i >= 0; --i) {
            if (!o.equals(this.array[i].get())) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException();
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private void expungeStaleEntries() {
        Reference ref;
        while ((ref = this.queue.poll()) != null) {
            for (int i = 0; i < this.size; ++i) {
                if (ref != this.array[i]) continue;
                --this.size;
                if (i < this.size) {
                    System.arraycopy(this.array, i + 1, this.array, i, this.size - i);
                }
                this.array[this.size] = null;
                ++this.state;
            }
        }
    }

    public String toString() {
        this.expungeStaleEntries();
        return SUtil.arrayToString(this.array);
    }

    protected Object writeReplace() throws ObjectStreamException {
        this.expungeStaleEntries();
        this.serialized_list = SCollection.createLinkedList();
        for (int i = 0; i < this.size; ++i) {
            Object next = this.array[i].get();
            if (next == null) continue;
            this.serialized_list.add(next);
        }
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.array = new Reference[Math.max(this.serialized_list.size(), 10)];
        this.queue = new ReferenceQueue();
        Iterator it = this.serialized_list.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.array[i] = new WeakReference(it.next(), this.queue);
            ++i;
        }
        this.size = this.serialized_list.size();
        this.serialized_list = null;
        return this;
    }

    public static void main(String[] args) {
        int i;
        int index;
        int i2;
        int i3;
        int i4;
        int i5;
        int testsize = 10001;
        WeakList list = new WeakList();
        String teststring = "testvalue ";
        String[] values = WeakList.createTestvalues(teststring, testsize);
        System.out.println("Adding odd values (at end of list).");
        for (i5 = 1; i5 < values.length; i5 += 2) {
            list.add(values[i5]);
        }
        System.out.println("Inserting even values (at correct position of list).");
        for (i5 = 0; i5 < values.length; i5 += 2) {
            list.add(i5, values[i5]);
        }
        System.out.println("Checking positions using toArray().");
        Object[] listvalues = list.toArray();
        for (i4 = 0; i4 < values.length; ++i4) {
            if (values[i4].equals(listvalues[i4])) continue;
            throw new RuntimeException("Test failed.");
        }
        listvalues = null;
        System.out.println("Checking positions using toArray(array).");
        listvalues = list.toArray((T[])new Object[0]);
        for (i4 = 0; i4 < values.length; ++i4) {
            if (values[i4].equals(listvalues[i4])) continue;
            throw new RuntimeException("Test failed.");
        }
        listvalues = null;
        System.out.println("Checking positions using iterator.");
        Iterator it = list.iterator();
        for (i3 = 0; i3 < values.length; ++i3) {
            if (values[i3].equals(it.next())) continue;
            throw new RuntimeException("Test failed.");
        }
        it = null;
        System.out.println("Making some values (x%3==0) available to garbage collection.");
        for (i3 = 0; i3 < values.length; i3 += 3) {
            values[i3] = null;
        }
        System.gc();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("Some elements should have been garbage collected.");
        if (list.size() >= values.length) {
            throw new RuntimeException("Test failed.");
        }
        WeakList.checkForEmptySlots(list);
        System.out.println("Checking positions using iterator.");
        it = list.iterator();
        String value = null;
        for (i2 = 0; i2 < values.length && it.hasNext(); ++i2) {
            if (values[i2] == null) {
                value = (String)it.next();
                index = Integer.parseInt(value.substring(value.indexOf(" ") + 1));
                if (index != i2) continue;
                value = null;
                continue;
            }
            if (value == null) {
                value = (String)it.next();
            }
            if (!values[i2].equals(value)) {
                throw new RuntimeException("Test failed: " + i2 + ", item=" + value + ", test=" + values[i2]);
            }
            value = null;
        }
        it = null;
        value = null;
        System.out.println("Removing some values (x%5==0) using iterator.");
        it = list.iterator();
        while (it.hasNext()) {
            value = (String)it.next();
            int index2 = Integer.parseInt(value.substring(value.indexOf(" ") + 1));
            if (index2 % 5 != 0) continue;
            it.remove();
        }
        it = null;
        value = null;
        WeakList.checkForEmptySlots(list);
        System.out.println("Checking positions using iterator.");
        it = list.iterator();
        value = null;
        for (i2 = 0; i2 < values.length && it.hasNext(); ++i2) {
            if (i2 % 5 == 0) continue;
            if (values[i2] == null) {
                value = (String)it.next();
                index = Integer.parseInt(value.substring(value.indexOf(" ") + 1));
                if (index != i2) continue;
                value = null;
                continue;
            }
            if (value == null) {
                value = (String)it.next();
            }
            if (!values[i2].equals(value)) {
                throw new RuntimeException("Test failed: " + i2 + ", item=" + value + ", test=" + values[i2]);
            }
            value = null;
        }
        it = null;
        value = null;
        System.out.println("Removing even values (including garbage collected ones).");
        for (i2 = 0; i2 < values.length; i2 += 2) {
            list.remove(teststring + i2);
        }
        WeakList.checkForEmptySlots(list);
        System.out.println("Checking positions using iterator.");
        it = list.iterator();
        value = null;
        for (i2 = 0; i2 < values.length && it.hasNext(); ++i2) {
            if (i2 % 5 == 0 || i2 % 2 == 0) continue;
            if (values[i2] == null) {
                value = (String)it.next();
                index = Integer.parseInt(value.substring(value.indexOf(" ") + 1));
                if (index != i2) continue;
                value = null;
                continue;
            }
            if (value == null) {
                value = (String)it.next();
            }
            if (!values[i2].equals(value)) {
                throw new RuntimeException("Test failed: " + i2 + ", item=" + value + ", test=" + values[i2]);
            }
            value = null;
        }
        it = null;
        value = null;
        System.out.println("Removing odd values (including garbage collected ones).");
        for (i2 = 1; i2 < values.length; i2 += 2) {
            list.remove(teststring + i2);
        }
        WeakList.checkForEmptySlots(list);
        System.out.println("Checking if the list is empty now.");
        if (list.size() > 0) {
            throw new RuntimeException("Test failed.");
        }
        System.out.println("Doing some more tests for garbage collection.");
        list = new WeakList();
        String[] ins = new String[testsize];
        for (i = 0; i < ins.length; ++i) {
            ins[i] = "ins_" + Math.random();
        }
        for (i = 0; i < ins.length; ++i) {
            list.add(ins[i]);
            list.add("notrem_" + Math.random());
        }
        System.out.println("Checking if some elements have been garbage collected.");
        if (list.size() >= ins.length * 2) {
            throw new RuntimeException("Test failed.");
        }
        WeakList.checkForEmptySlots(list);
        System.out.println("Removing remebered entries.");
        for (i = 0; i < ins.length; ++i) {
            list.remove(ins[i]);
        }
        WeakList.checkForEmptySlots(list);
        System.out.println("Test successful.");
    }

    protected static String[] createTestvalues(String teststring, int size) {
        String[] values = new String[size];
        for (int i = 0; i < values.length; ++i) {
            values[i] = teststring + i;
        }
        return values;
    }

    protected static void checkForEmptySlots(List list) {
        int i;
        System.out.println("Checking for empty slots in toArray().");
        Object[] listvalues = list.toArray();
        for (i = 0; i < listvalues.length; ++i) {
            if (listvalues[i] != null) continue;
            throw new RuntimeException("Test failed.");
        }
        System.out.println("Checking for empty slots in toArray(array).");
        listvalues = list.toArray(new Object[0]);
        for (i = 0; i < listvalues.length; ++i) {
            if (listvalues[i] != null) continue;
            throw new RuntimeException("Test failed.");
        }
    }
}

