/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class SortedList
extends LinkedList {
    protected boolean ascending;
    protected Comparator comp;

    public SortedList() {
        this(true);
    }

    public SortedList(boolean ascending) {
        this.ascending = ascending;
    }

    public SortedList(Comparator comp, boolean ascending) {
        this.comp = comp;
        this.ascending = ascending;
    }

    public void addFirst(Object o) {
        this.insertElement(0, o);
    }

    public void addLast(Object o) {
        this.insertElement(this.size(), o);
    }

    public boolean add(Object o) {
        this.addLast(o);
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.addLast(it.next());
        }
        return true;
    }

    public boolean addAll(int index, Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            int idx = this.insertElement(index, it.next());
            if (idx > index) continue;
            ++index;
        }
        return true;
    }

    public void add(int index, Object element) {
        this.insertElement(index, element);
    }

    public int insertElement(int index, Object obj) {
        while (index > 0 && this.compare(this.get(index - 1), obj) > 0) {
            --index;
        }
        while (index < this.size() && this.compare(this.get(index), obj) < 0) {
            ++index;
        }
        super.add(index, obj);
        return index;
    }

    protected int compare(Object o1, Object o2) {
        int cmp = this.comp == null ? (o1 == null && o2 == null ? 0 : (o1 != null && o2 == null ? -1 : (o1 == null && o2 != null ? 1 : ((Comparable)o1).compareTo(o2)))) : this.comp.compare(o1, o2);
        return this.ascending ? cmp : -cmp;
    }
}

