/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.collection.ConcurrencyCheckingList;
import jadex.util.collection.FastHashMap;
import jadex.util.collection.IndexMap;
import jadex.util.collection.LRU;
import jadex.util.collection.MultiCollection;
import jadex.util.collection.NestedMap;
import jadex.util.collection.WeakList;
import jadex.util.collection.WeakSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;

public class SCollection {
    public static final boolean DEBUG = false;
    private static Object monitor;
    private static List arraylists;
    private static List fasthashmaps;
    private static List hashmaps;
    private static List hashsets;
    private static List hashtables;
    private static List indexmaps;
    private static List linkedhashsets;
    private static List linkedlists;
    private static List lrus;
    private static List multicollections;
    private static List nestedmaps;
    private static List vectors;
    private static List weakhashmaps;
    private static List weaklists;
    private static List weaksets;
    private static List others;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static IndexMap createIndexMap() {
        IndexMap ret = new IndexMap();
        return ret;
    }

    public static Hashtable createHashtable() {
        Hashtable ret = new Hashtable();
        return ret;
    }

    public static HashMap createHashMap() {
        HashMap ret = new HashMap();
        return ret;
    }

    public static HashMap createLinkedHashMap() {
        LinkedHashMap ret = new LinkedHashMap();
        return ret;
    }

    public static LRU createLRU(int max) {
        LRU ret = new LRU(max);
        return ret;
    }

    public static FastHashMap createFastHashMap() {
        FastHashMap ret = new FastHashMap();
        return ret;
    }

    public static MultiCollection createMultiCollection() {
        MultiCollection ret = new MultiCollection();
        return ret;
    }

    public static WeakHashMap createWeakHashMap() {
        WeakHashMap ret = new WeakHashMap();
        return ret;
    }

    public static WeakList createWeakList() {
        WeakList ret = new WeakList();
        return ret;
    }

    public static WeakSet createWeakSet() {
        WeakSet ret = new WeakSet();
        return ret;
    }

    public static ArrayList createArrayList() {
        ArrayList ret = new ArrayList();
        return ret;
    }

    public static LinkedList createLinkedList() {
        LinkedList ret = new LinkedList();
        return ret;
    }

    public static Vector createVector() {
        Vector ret = new Vector();
        return ret;
    }

    public static HashSet createHashSet() {
        HashSet ret = new HashSet();
        return ret;
    }

    public static LinkedHashSet createLinkedHashSet() {
        LinkedHashSet ret = new LinkedHashSet();
        return ret;
    }

    public static NestedMap createNestedMap(Map map) {
        NestedMap ret = new NestedMap(map);
        return ret;
    }

    public static NestedMap createNestedMap(Map[] map) {
        NestedMap ret = new NestedMap(map);
        return ret;
    }

    public static List concurrencyCheckingList(List list) {
        return new ConcurrencyCheckingList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void addCollection(Object o) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        Object object = monitor;
        synchronized (object) {
            if (o.getClass().equals(ArrayList.class)) {
                if (arraylists != null) {
                    arraylists.add(o);
                }
            } else if (o.getClass().equals(FastHashMap.class)) {
                fasthashmaps.add(o);
            } else if (o.getClass().equals(HashMap.class)) {
                hashmaps.add(o);
            } else if (o.getClass().equals(HashSet.class)) {
                hashsets.add(o);
            } else if (o.getClass().equals(Hashtable.class)) {
                hashtables.add(o);
            } else if (o.getClass().equals(IndexMap.class)) {
                indexmaps.add(o);
            } else if (o.getClass().equals(LinkedHashSet.class)) {
                linkedhashsets.add(o);
            } else if (o.getClass().equals(LinkedList.class)) {
                linkedlists.add(o);
            } else if (o.getClass().equals(LRU.class)) {
                lrus.add(o);
            } else if (o.getClass().equals(MultiCollection.class)) {
                multicollections.add(o);
            } else if (o.getClass().equals(NestedMap.class)) {
                nestedmaps.add(o);
            } else if (o.getClass().equals(Vector.class)) {
                vectors.add(o);
            } else if (o.getClass().equals(WeakHashMap.class)) {
                weakhashmaps.add(o);
            } else if (o.getClass().equals(WeakList.class)) {
                weaklists.add(o);
            } else if (o.getClass().equals(WeakSet.class)) {
                weaksets.add(o);
            } else {
                System.out.println("Unknown collection type: " + o.getClass());
                others.add(o);
            }
        }
    }

    protected static void printCollectionInfo(Iterator it, int boundary) {
        while (it.hasNext()) {
            Object o = it.next();
            if (!($assertionsDisabled || o instanceof Map || o instanceof Collection || o instanceof IndexMap)) {
                throw new AssertionError();
            }
            if (o instanceof Map && ((Map)o).size() > boundary) {
                System.out.println(o.hashCode() + ": " + ((Map)o).size());
                continue;
            }
            if (o instanceof Collection && ((Collection)o).size() > boundary) {
                System.out.println(o.hashCode() + ": " + ((Collection)o).size());
                continue;
            }
            if (!(o instanceof IndexMap) || ((IndexMap)o).size() <= boundary) continue;
            System.out.println(o.hashCode() + ": " + ((IndexMap)o).size());
        }
    }

    public static void main(String[] args) throws InterruptedException {
        for (int i = 1; i < 5000; ++i) {
            ArrayList test1 = SCollection.createArrayList();
            HashMap test2 = SCollection.createHashMap();
            HashSet test3 = SCollection.createHashSet();
            Hashtable test4 = SCollection.createHashtable();
            IndexMap test5 = SCollection.createIndexMap();
            Vector test6 = SCollection.createVector();
            Thread.sleep(10L);
        }
        System.out.println("finished");
        Thread.sleep(10000L);
        System.exit(0);
    }

    static {
        $assertionsDisabled = !SCollection.class.desiredAssertionStatus();
    }

    public static class DebugPrinter
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object mon = new Object();
            int boundary = 20;
            while (true) {
                Object object;
                try {
                    object = mon;
                    synchronized (object) {
                        mon.wait(10000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                object = monitor;
                synchronized (object) {
                    System.gc();
                    System.out.println("*************** DEBUG Collections ***************");
                    System.out.println("*** ArrayLists *** " + arraylists.size());
                    SCollection.printCollectionInfo(arraylists.iterator(), boundary);
                    System.out.println("*** FastHashMaps *** " + fasthashmaps.size());
                    SCollection.printCollectionInfo(fasthashmaps.iterator(), boundary);
                    System.out.println("*** HashMaps *** " + hashmaps.size());
                    SCollection.printCollectionInfo(hashmaps.iterator(), boundary);
                    System.out.println("*** HashSets *** " + hashsets.size());
                    SCollection.printCollectionInfo(hashsets.iterator(), boundary);
                    System.out.println("*** HashTables *** " + hashtables.size());
                    SCollection.printCollectionInfo(hashtables.iterator(), boundary);
                    System.out.println("*** IndexMaps *** " + indexmaps.size());
                    SCollection.printCollectionInfo(indexmaps.iterator(), boundary);
                    System.out.println("*** LinkedHashSets *** " + linkedhashsets.size());
                    SCollection.printCollectionInfo(linkedhashsets.iterator(), boundary);
                    System.out.println("*** LinkedLists *** " + linkedlists.size());
                    SCollection.printCollectionInfo(linkedlists.iterator(), boundary);
                    System.out.println("*** LRUs *** " + lrus.size());
                    SCollection.printCollectionInfo(lrus.iterator(), boundary);
                    System.out.println("*** Multicollections *** " + multicollections.size());
                    SCollection.printCollectionInfo(multicollections.iterator(), boundary);
                    System.out.println("*** NestedMaps *** " + nestedmaps.size());
                    SCollection.printCollectionInfo(nestedmaps.iterator(), boundary);
                    System.out.println("*** Vectors *** " + vectors.size());
                    SCollection.printCollectionInfo(vectors.iterator(), boundary);
                    System.out.println("*** WeakHashMaps *** " + weakhashmaps.size());
                    SCollection.printCollectionInfo(weakhashmaps.iterator(), boundary);
                    System.out.println("*** WeakLists *** " + weaklists.size());
                    SCollection.printCollectionInfo(weaklists.iterator(), boundary);
                    System.out.println("*** WeakSets *** " + weaksets.size());
                    SCollection.printCollectionInfo(weaksets.iterator(), boundary);
                    System.out.println("*** Others *** " + others.size());
                    SCollection.printCollectionInfo(others.iterator(), boundary);
                    System.out.println("*************************************************");
                }
            }
        }
    }
}

