/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.SUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class NestedMap
implements Map,
Serializable {
    protected Map local;
    protected Map[] parents;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NestedMap(Map parent) {
        this(new Map[]{parent});
    }

    public NestedMap(Map[] parents) {
        this(parents, new HashMap());
    }

    protected NestedMap(Map[] parents, Map local) {
        if (!$assertionsDisabled && local == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parents == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < parents.length; ++i) {
            if (!$assertionsDisabled && parents[i] == null) {
                throw new AssertionError(this);
            }
        }
        this.parents = new Map[parents.length];
        System.arraycopy(parents, 0, this.parents, 0, parents.length);
        this.local = local;
    }

    public Map getLocalMap() {
        return this.local;
    }

    public int size() {
        HashSet keys = new HashSet(this.local.keySet());
        for (int i = 0; i < this.parents.length; ++i) {
            keys.addAll(this.parents[i].keySet());
        }
        return keys.size();
    }

    public boolean isEmpty() {
        boolean empty = this.local.isEmpty();
        for (int i = 0; empty && i < this.parents.length; ++i) {
            empty = this.parents[i].isEmpty();
        }
        return empty;
    }

    public boolean containsKey(Object key) {
        boolean contains = this.local.containsKey(key);
        for (int i = 0; !contains && i < this.parents.length; ++i) {
            contains = this.parents[i].containsKey(key);
        }
        return contains;
    }

    public boolean containsValue(Object value) {
        boolean contains = this.local.containsValue(value);
        for (int i = 0; !contains && i < this.parents.length; ++i) {
            contains = this.parents[i].containsValue(value);
        }
        return contains;
    }

    public Object get(Object key) {
        Object value = null;
        boolean found = this.local.containsKey(key);
        if (found) {
            value = this.local.get(key);
        }
        for (int i = 0; !found && i < this.parents.length; ++i) {
            found = this.parents[i].containsKey(key);
            if (!found) continue;
            value = this.parents[i].get(key);
        }
        return value;
    }

    public Object put(Object key, Object value) {
        return this.local.put(key, value);
    }

    public Object remove(Object key) {
        return this.local.remove(key);
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public void clear() {
        this.local.clear();
    }

    public Set keySet() {
        HashSet ret = new HashSet(this.local.keySet());
        for (int i = 0; i < this.parents.length; ++i) {
            ret.addAll(this.parents[i].keySet());
        }
        return ret;
    }

    public Collection values() {
        HashSet ret = new HashSet(this.local.values());
        for (int i = 0; i < this.parents.length; ++i) {
            ret.addAll(this.parents[i].values());
        }
        return ret;
    }

    public Set entrySet() {
        Set ret = this.local.entrySet();
        for (int i = 0; i < this.parents.length; ++i) {
            ret.addAll(this.parents[i].entrySet());
        }
        return ret;
    }

    public boolean equals(Object o) {
        return o instanceof Map && this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        HashSet entries = new HashSet(this.local.entrySet());
        for (int i = 0; i < this.parents.length; ++i) {
            entries.addAll(this.parents[i].entrySet());
        }
        return ((Object)entries).hashCode();
    }

    public String toString() {
        return "NestedMap(local=" + this.local + ", parents=" + SUtil.arrayToString(this.parents) + ")";
    }

    static {
        $assertionsDisabled = !NestedMap.class.desiredAssertionStatus();
    }
}

