/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.SUtil;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MultiCollection
implements Map,
Serializable,
Cloneable {
    protected Map map;
    protected Class type;

    public MultiCollection() {
        this(new HashMap(), ArrayList.class);
    }

    public MultiCollection(Map map, Class type) {
        this.map = map;
        this.type = type;
    }

    public Object clone() {
        HashMap mapcopy = new HashMap();
        mapcopy.putAll(this.map);
        return new MultiCollection(mapcopy, this.type);
    }

    public int size() {
        int size = 0;
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            size += ((Collection)this.map.get(i.next())).size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            if (!((Collection)this.map.get(i.next())).contains(value)) continue;
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        Collection col;
        Object o = this.map.get(key);
        if (o != null) {
            col = (Collection)o;
        } else {
            try {
                col = (Collection)this.type.newInstance();
            }
            catch (InstantiationException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new RuntimeException(sw.toString());
            }
            catch (IllegalAccessException e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                throw new RuntimeException(sw.toString());
            }
            this.map.put(key, col);
        }
        col.add(value);
        return col;
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    public boolean equals(Object o) {
        return o instanceof MultiCollection && this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public String toString() {
        return "MultiCollection(map=" + this.map + ")";
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public Collection getCollection(Object key) {
        Collection ret = (Collection)this.get(key);
        if (ret == null) {
            ret = Collections.EMPTY_LIST;
        }
        return ret;
    }

    public Object[] getObjects() {
        return this.getObjects(Object.class);
    }

    public Object[] getObjects(Class type) {
        Object ret = Array.newInstance(type, 0);
        Iterator i = this.map.keySet().iterator();
        while (i.hasNext()) {
            ret = SUtil.joinArrays(ret, this.getCollection(i.next()).toArray());
        }
        return (Object[])ret;
    }

    public Object[] getKeys() {
        return this.keySet().toArray();
    }

    public Object[] getKeys(Class type) {
        Set keys = this.keySet();
        return keys.toArray((Object[])Array.newInstance(type, keys.size()));
    }

    public void remove(Object key, Object value) {
        Collection coll = (Collection)this.map.get(key);
        if (coll == null) {
            throw new RuntimeException("Key does not exist!" + key);
        }
        coll.remove(value);
        if (coll.isEmpty()) {
            this.map.remove(key);
        }
    }
}

