/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.SUtil;
import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class IndexMap
implements Serializable,
Cloneable {
    protected List list;
    protected Map map;
    protected Map asmap;
    protected List aslist;

    public IndexMap() {
        this(new ArrayList(), new HashMap());
    }

    public IndexMap(List list, Map map) {
        this.list = list;
        this.map = map;
    }

    public Object clone() {
        ArrayList listcopy = SCollection.createArrayList();
        listcopy.addAll(this.list);
        HashMap mapcopy = SCollection.createHashMap();
        mapcopy.putAll(this.map);
        return new IndexMap(listcopy, mapcopy);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        this.list.remove(key);
        this.list.add(key);
        return this.map.put(key, value);
    }

    public void putAll(Map t) {
        Iterator it = t.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            this.put(key, t.get(key));
        }
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    public Set keySet() {
        return new KeySetWrapper();
    }

    public Collection values() {
        return this.getAsList();
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public boolean equals(Object o) {
        return o instanceof IndexMap && this.hashCode() == o.hashCode();
    }

    public int hashCode() {
        return ((Object)this.map).hashCode() + ((Object)this.list).hashCode();
    }

    public String toString() {
        return "IndexMap(map=" + this.map + ", list=" + this.list + ")";
    }

    public boolean contains(Object o) {
        return this.map.containsValue(o);
    }

    public Iterator iterator() {
        return new Iterator(){
            Iterator i;
            {
                this.i = IndexMap.this.list.iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Object next() {
                return IndexMap.this.map.get(this.i.next());
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        Object[] array = new Object[this.list.size()];
        for (int i = 0; i < this.list.size(); ++i) {
            array[i] = this.map.get(this.list.get(i));
        }
        return array;
    }

    public Object[] toArray(Object[] array) {
        if (array.length < this.list.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.list.size());
        }
        for (int i = 0; i < this.list.size(); ++i) {
            array[i] = this.map.get(this.list.get(i));
        }
        return array;
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean removeAll(Collection c) {
        boolean removed = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.removeValue(i.next());
            removed = true;
        }
        return removed;
    }

    public boolean retainAll(Collection c) {
        boolean removed = false;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object key = i.next();
            if (c.contains(this.map.get(key))) continue;
            this.removeKey(key);
            removed = true;
        }
        return removed;
    }

    public Object get(int index) {
        return this.map.get(this.list.get(index));
    }

    public Object set(int index, Object element) {
        return this.map.put(this.list.get(index), element);
    }

    public Object remove(int index) {
        Object del = this.map.remove(this.list.get(index));
        this.list.remove(index);
        return del;
    }

    public int indexOf(Object o) {
        for (int i = 0; i < this.list.size(); ++i) {
            Object key = this.list.get(i);
            if (!this.map.get(key).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        for (int i = this.list.size() - 1; i >= 0; --i) {
            Object key = this.list.get(i);
            if (!this.map.get(key).equals(o)) continue;
            return i;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int index) {
        return new ListIterator(){
            int i;
            {
                this.i = index;
            }

            public boolean hasNext() {
                return this.i < IndexMap.this.size();
            }

            public Object next() {
                return IndexMap.this.get(this.i++);
            }

            public boolean hasPrevious() {
                return this.i > 0;
            }

            public Object previous() {
                return IndexMap.this.get(--this.i);
            }

            public int nextIndex() {
                return this.i;
            }

            public int previousIndex() {
                return this.i - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        throw new UnsupportedOperationException("Unsupported method, due to missing key parameter.");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("Unsupported method, due to missing key parameter.");
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("Unsupported method, due to missing key parameter.");
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException("Unsupported method, due to missing key parameter.");
    }

    public Object removeKey(Object key) {
        this.list.remove(key);
        return this.map.remove(key);
    }

    public boolean removeValue(Object o) {
        for (int i = 0; i < this.list.size(); ++i) {
            Object key = this.list.get(i);
            if (!this.map.get(key).equals(o)) continue;
            this.list.remove(i);
            this.map.remove(key);
            return true;
        }
        return false;
    }

    public void add(Object key, Object o) {
        this.add(this.list.size(), key, o);
    }

    public Object replace(Object key, Object o) {
        if (this.map.get(key) == null) {
            throw new RuntimeException("Old key does not exist: " + key);
        }
        return this.map.put(key, o);
    }

    public Object getKey(int index) {
        return this.list.get(index);
    }

    public void add(int index, Object key, Object o) {
        if (this.map.get(key) != null) {
            throw new RuntimeException("Old key exists: " + index + " " + key);
        }
        this.map.put(key, o);
        this.list.add(index, key);
    }

    public Map getAsMap() {
        return this.asmap != null ? this.asmap : (this.asmap = new MapIndexMap(this.list, this.map));
    }

    public List getAsList() {
        return this.aslist != null ? this.aslist : (this.aslist = new ListIndexMap(this.list, this.map));
    }

    public Object[] getObjects() {
        return this.toArray();
    }

    public Object[] getObjects(Class type) {
        return this.toArray((Object[])Array.newInstance(type, this.list.size()));
    }

    public Object[] getKeys() {
        return this.list.toArray();
    }

    public Object[] getKeys(Class type) {
        return this.list.toArray((Object[])Array.newInstance(type, this.list.size()));
    }

    class KeySetWrapper
    implements Set {
        KeySetWrapper() {
        }

        public int size() {
            return IndexMap.this.list.size();
        }

        public boolean isEmpty() {
            return IndexMap.this.list.isEmpty();
        }

        public boolean contains(Object o) {
            return IndexMap.this.list.contains(o);
        }

        public Iterator iterator() {
            return IndexMap.this.list.iterator();
        }

        public Object[] toArray() {
            return IndexMap.this.list.toArray();
        }

        public Object[] toArray(Object[] a) {
            return IndexMap.this.list.toArray(a);
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException("Unsupported method, due to missing value parameter.");
        }

        public boolean remove(Object o) {
            IndexMap.this.map.remove(o);
            return IndexMap.this.list.remove(o);
        }

        public boolean containsAll(Collection c) {
            return IndexMap.this.list.containsAll(c);
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException("Unsupported method, due to missing value parameter.");
        }

        public boolean retainAll(Collection c) {
            boolean modified = false;
            Iterator i = IndexMap.this.list.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                if (!c.contains(key)) continue;
                modified = this.remove(key);
            }
            return modified;
        }

        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator i = c.iterator();
            while (i.hasNext()) {
                Object key = i.next();
                modified = this.remove(key);
            }
            return modified;
        }

        public void clear() {
            IndexMap.this.clear();
        }

        public boolean equals(Object o) {
            return o instanceof Set && this.size() == ((Collection)o).size() && this.containsAll((Collection)o);
        }

        public int hashCode() {
            int code = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                code += o != null ? o.hashCode() : 0;
            }
            return code;
        }

        public String toString() {
            return SUtil.arrayToString(this.toArray());
        }
    }

    public static class ListIndexMap
    extends IndexMap
    implements List {
        public ListIndexMap() {
        }

        public ListIndexMap(List list, Map map) {
            super(list, map);
        }

        public boolean remove(Object o) {
            return this.removeValue(o);
        }

        public Object clone() {
            ArrayList listcopy = new ArrayList();
            listcopy.addAll(this.list);
            HashMap mapcopy = new HashMap();
            mapcopy.putAll(this.map);
            return new ListIndexMap(listcopy, mapcopy);
        }
    }

    public static class MapIndexMap
    extends IndexMap
    implements Map {
        public MapIndexMap() {
        }

        public MapIndexMap(List list, Map map) {
            super(list, map);
        }

        public Object remove(Object key) {
            return this.removeKey(key);
        }

        public Object clone() {
            ArrayList listcopy = new ArrayList();
            listcopy.addAll(this.list);
            HashMap mapcopy = new HashMap();
            mapcopy.putAll(this.map);
            return new MapIndexMap(listcopy, mapcopy);
        }
    }
}

