/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.collection.FastHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FastHashMap
implements Map,
Serializable {
    private static final int START_CAPACITY = 32;
    private static final double LOAD_FACTOR = 0.75;
    private static final Object NONE = NONE.class;
    private transient Object[] keys = new Object[32];
    private transient Object[] values = new Object[32];
    private transient int size = 0;
    private transient int rehash_limit = (int)((double)this.keys.length * 0.75);
    private transient int hash_range = this.keys.length - 1;
    private transient Object nvar = NONE;
    transient Set key_set = null;
    transient Collection values_col = null;
    transient Set entry_set = null;
    private static final long serialVersionUID = 362722346524651265L;

    public Object put(Object key, Object value) {
        int h;
        if (key == null) {
            Object on = this.nvar == NONE ? null : this.nvar;
            this.nvar = value;
            return on;
        }
        int hc = key.hashCode();
        int i = h = hc & this.hash_range;
        while (i > 0) {
            if (this.keys[--i] == null) {
                this.keys[i] = key;
                this.values[i] = value;
                if (++this.size > this.rehash_limit) {
                    this.rehash();
                }
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            Object ov = this.values[i];
            this.values[i] = value;
            return ov;
        }
        i = this.keys.length;
        while (i > h) {
            if (this.keys[--i] == null) {
                this.keys[i] = key;
                this.values[i] = value;
                if (++this.size > this.rehash_limit) {
                    this.rehash();
                }
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            Object ov = this.values[i];
            this.values[i] = value;
            return ov;
        }
        return null;
    }

    private static final boolean eq(Object a, int ah, Object b) {
        return a == b || ah == b.hashCode() && a.equals(b);
    }

    private static final boolean eq(Object v1, Object v2) {
        return v1 == v2 || v1 != null && v1.equals(v2);
    }

    private final void rehash() {
        Object[] ok = this.keys;
        Object[] ov = this.values;
        this.keys = new Object[this.keys.length << 1];
        this.values = new Object[this.keys.length];
        this.size = 0;
        this.rehash_limit = (int)((double)this.keys.length * 0.75);
        this.hash_range = this.keys.length - 1;
        int i = ok.length;
        while (i > 0) {
            if (ok[--i] == null) continue;
            this.put(ok[i], ov[i]);
        }
    }

    public Object get(Object key) {
        int h;
        if (key == null) {
            return this.nvar == NONE ? null : this.nvar;
        }
        int hc = key.hashCode();
        int i = h = hc & this.hash_range;
        while (i > 0) {
            if (this.keys[--i] == null) {
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            return this.values[i];
        }
        i = this.keys.length;
        while (i > h) {
            if (this.keys[--i] == null) {
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            return this.values[i];
        }
        return null;
    }

    public boolean containsKey(Object key) {
        int h;
        if (key == null) {
            return this.nvar != NONE;
        }
        int hc = key.hashCode();
        int i = h = hc & this.hash_range;
        while (i > 0) {
            if (this.keys[--i] == null) {
                return false;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            return true;
        }
        i = this.keys.length;
        while (i > h) {
            if (this.keys[--i] == null) {
                return false;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            return true;
        }
        return false;
    }

    public Object[] getKeys() {
        return this.keys;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsValue(Object value) {
        int i = this.keys.length;
        while (i > 0) {
            if (this.keys[--i] == null || !FastHashMap.eq(value, this.values[i])) continue;
            return true;
        }
        return false;
    }

    public Object remove(Object key) {
        int h;
        if (key == null) {
            Object ov = this.nvar == NONE ? null : this.nvar;
            this.nvar = NONE;
            return ov;
        }
        int hc = key.hashCode();
        int i = h = hc & this.hash_range;
        while (i > 0) {
            if (this.keys[--i] == null) {
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            this.keys[i] = null;
            --this.size;
            return this.values[i];
        }
        i = this.keys.length;
        while (i > h) {
            if (this.keys[--i] == null) {
                return null;
            }
            if (!FastHashMap.eq(key, hc, this.keys[i])) continue;
            this.keys[i] = null;
            --this.size;
            return this.values[i];
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator ies = map.entrySet().iterator();
        while (ies.hasNext()) {
            Map.Entry entry = ies.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.size = 0;
        int i = this.keys.length;
        while (i > 0) {
            this.keys[--i] = null;
        }
        this.nvar = NONE;
    }

    public Set keySet() {
        if (this.key_set == null) {
            this.key_set = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        int i;
                        private final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                            this.i = 0;
                        }

                        public boolean hasNext() {
                            return this.i < FastHashMap.access$100(1.access$000(this.this$1)).length;
                        }

                        public Object next() {
                            while (this.i < FastHashMap.access$100(1.access$000(this.this$1)).length) {
                                if (FastHashMap.access$100(1.access$000(this.this$1))[this.i] != null) {
                                    return FastHashMap.access$100(1.access$000(this.this$1))[this.i];
                                }
                                ++this.i;
                            }
                            return null;
                        }

                        public void remove() {
                            if (FastHashMap.access$100(1.access$000(this.this$1))[this.i] != null) {
                                FastHashMap.access$100((FastHashMap)1.access$000(this.this$1))[this.i] = null;
                                FastHashMap.access$206(1.access$000(this.this$1));
                            }
                        }
                    };
                }

                public int size() {
                    return FastHashMap.this.size;
                }

                static /* synthetic */ FastHashMap access$000(1 x0) {
                    return x0.FastHashMap.this;
                }
            };
        }
        return this.key_set;
    }

    public Collection values() {
        if (this.values_col == null) {
            this.values_col = new AbstractCollection(){

                public Iterator iterator() {
                    return new Iterator(this){
                        int i;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.i = 0;
                        }

                        public boolean hasNext() {
                            return this.i < FastHashMap.access$100(3.access$300(this.this$1)).length;
                        }

                        public Object next() {
                            while (this.i < FastHashMap.access$100(3.access$300(this.this$1)).length) {
                                if (FastHashMap.access$100(3.access$300(this.this$1))[this.i] != null) {
                                    return FastHashMap.access$400(3.access$300(this.this$1))[this.i];
                                }
                                ++this.i;
                            }
                            return null;
                        }

                        public void remove() {
                            if (FastHashMap.access$100(3.access$300(this.this$1))[this.i] != null) {
                                FastHashMap.access$100((FastHashMap)3.access$300(this.this$1))[this.i] = null;
                                FastHashMap.access$206(3.access$300(this.this$1));
                            }
                        }
                    };
                }

                public int size() {
                    return FastHashMap.this.size;
                }

                static /* synthetic */ FastHashMap access$300(3 x0) {
                    return x0.FastHashMap.this;
                }
            };
        }
        return this.values_col;
    }

    public Set entrySet() {
        if (this.entry_set == null) {
            this.entry_set = new AbstractSet(){

                public Iterator iterator() {
                    return new Iterator(this){
                        int i;
                        private final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = this$1;
                            this.i = 0;
                        }

                        public boolean hasNext() {
                            return this.i < FastHashMap.access$100(5.access$500(this.this$1)).length;
                        }

                        public Object next() {
                            while (this.i < FastHashMap.access$100(5.access$500(this.this$1)).length) {
                                if (FastHashMap.access$100(5.access$500(this.this$1))[this.i] != null) {
                                    return new Map.Entry(this){
                                        final int e_index;
                                        private final /* synthetic */ 6 this$2;
                                        {
                                            this.this$2 = this$2;
                                            this.e_index = this.this$2.i;
                                        }

                                        public Object getKey() {
                                            return FastHashMap.access$100(5.access$500(6.access$600(this.this$2)))[this.e_index];
                                        }

                                        public Object getValue() {
                                            return FastHashMap.access$400(5.access$500(6.access$600(this.this$2)))[this.e_index];
                                        }

                                        public Object setValue(Object arg0) {
                                            Object object = arg0;
                                            FastHashMap.access$400((FastHashMap)5.access$500(6.access$600(this.this$2)))[this.e_index] = object;
                                            return object;
                                        }
                                    };
                                }
                                ++this.i;
                            }
                            return null;
                        }

                        public void remove() {
                            if (FastHashMap.access$100(5.access$500(this.this$1))[this.i] != null) {
                                FastHashMap.access$100((FastHashMap)5.access$500(this.this$1))[this.i] = null;
                                FastHashMap.access$206(5.access$500(this.this$1));
                            }
                        }

                        static /* synthetic */ 5 access$600(6 x0) {
                            return x0.this$1;
                        }
                    };
                }

                public int size() {
                    return FastHashMap.this.size;
                }

                static /* synthetic */ FastHashMap access$500(5 x0) {
                    return x0.FastHashMap.this;
                }
            };
        }
        return this.entry_set;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = this.keys.length;
        sb.append('{');
        while (i > 0) {
            if (this.keys[--i] == null) continue;
            sb.append(this.keys[i]);
            sb.append('=');
            sb.append(this.values[i]);
            sb.append(',');
        }
        sb.append("null=");
        sb.append(this.nvar);
        sb.append('}');
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int i = this.keys.length;
        s.writeInt(i);
        s.writeInt(this.size);
        while (i > 0) {
            if (this.keys[--i] == null) continue;
            s.writeObject(this.keys[i]);
            s.writeObject(this.values[i]);
        }
        s.writeObject(this.nvar);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int i = s.readInt();
        this.keys = new Object[i];
        this.values = new Object[i];
        this.rehash_limit = (int)((double)i * 0.75);
        this.hash_range = i - 1;
        this.size = 0;
        for (i = s.readInt(); i > 0; --i) {
            this.put(s.readObject(), s.readObject());
        }
        this.nvar = s.readObject();
    }

    static /* synthetic */ Object[] access$100(FastHashMap x0) {
        return x0.keys;
    }

    static /* synthetic */ int access$206(FastHashMap x0) {
        return --x0.size;
    }

    static /* synthetic */ Object[] access$400(FastHashMap x0) {
        return x0.values;
    }

    private static final class NONE
    implements Serializable {
        private NONE() {
        }
    }
}

