/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.collection.SCollection;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ConcurrencyCheckingList
implements List,
Serializable {
    protected List list;
    protected transient Map threads;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConcurrencyCheckingList(List list) {
        this.list = list;
    }

    public boolean add(Object o) {
        this.entry();
        boolean ret = this.list.add(o);
        this.exit();
        return ret;
    }

    public void add(int index, Object element) {
        this.entry();
        this.list.add(index, element);
        this.exit();
    }

    public boolean addAll(Collection c) {
        this.entry();
        boolean ret = this.list.addAll(c);
        this.exit();
        return ret;
    }

    public boolean addAll(int index, Collection c) {
        this.entry();
        boolean ret = this.list.addAll(index, c);
        this.exit();
        return ret;
    }

    public void clear() {
        this.entry();
        this.list.clear();
        this.exit();
    }

    public boolean contains(Object o) {
        this.entry();
        boolean ret = this.list.contains(o);
        this.exit();
        return ret;
    }

    public boolean containsAll(Collection c) {
        this.entry();
        boolean ret = this.list.containsAll(c);
        this.exit();
        return ret;
    }

    public Object get(int index) {
        this.entry();
        Object ret = this.list.get(index);
        this.exit();
        return ret;
    }

    public int indexOf(Object o) {
        this.entry();
        int ret = this.list.indexOf(o);
        this.exit();
        return ret;
    }

    public boolean isEmpty() {
        this.entry();
        boolean ret = this.list.isEmpty();
        this.exit();
        return ret;
    }

    public Iterator iterator() {
        this.entry();
        Iterator ret = this.list.iterator();
        this.exit();
        return ret;
    }

    public int lastIndexOf(Object o) {
        this.entry();
        int ret = this.list.lastIndexOf(o);
        this.exit();
        return ret;
    }

    public ListIterator listIterator() {
        this.entry();
        ListIterator ret = this.list.listIterator();
        this.exit();
        return ret;
    }

    public ListIterator listIterator(int index) {
        this.entry();
        ListIterator ret = this.list.listIterator(index);
        this.exit();
        return ret;
    }

    public Object remove(int index) {
        this.entry();
        Object ret = this.list.remove(index);
        this.exit();
        return ret;
    }

    public boolean remove(Object o) {
        this.entry();
        boolean ret = this.list.remove(o);
        this.exit();
        return ret;
    }

    public boolean removeAll(Collection c) {
        this.entry();
        boolean ret = this.list.removeAll(c);
        this.exit();
        return ret;
    }

    public boolean retainAll(Collection c) {
        this.entry();
        boolean ret = this.list.retainAll(c);
        this.exit();
        return ret;
    }

    public Object set(int index, Object element) {
        this.entry();
        Object ret = this.list.set(index, element);
        this.exit();
        return ret;
    }

    public int size() {
        this.entry();
        int ret = this.list.size();
        this.exit();
        return ret;
    }

    public List subList(int fromIndex, int toIndex) {
        this.entry();
        List ret = this.list.subList(fromIndex, toIndex);
        this.exit();
        return ret;
    }

    public Object[] toArray() {
        this.entry();
        Object[] ret = this.list.toArray();
        this.exit();
        return ret;
    }

    public Object[] toArray(Object[] a) {
        this.entry();
        Object[] ret = this.list.toArray(a);
        this.exit();
        return ret;
    }

    protected synchronized void entry() {
        Integer cnt;
        if (this.threads == null) {
            this.threads = SCollection.createHashMap();
        }
        cnt = new Integer((cnt = (Integer)this.threads.get(Thread.currentThread())) != null ? cnt + 1 : 1);
        this.threads.put(Thread.currentThread(), cnt);
        if (this.threads.size() > 1) {
            throw new RuntimeException("Concurrent access to list " + this.list.getClass().getName() + "@" + ((Object)this.list).hashCode());
        }
    }

    protected synchronized void exit() {
        if (this.threads == null) {
            this.threads = SCollection.createHashMap();
        }
        if (this.threads.size() > 1) {
            throw new RuntimeException("Concurrent access to list " + this.list.getClass().getName() + "@" + ((Object)this.list).hashCode());
        }
        Integer cnt = (Integer)this.threads.get(Thread.currentThread());
        if (!($assertionsDisabled || cnt != null && cnt > 0)) {
            throw new AssertionError();
        }
        if (cnt > 1) {
            cnt = new Integer(cnt - 1);
            this.threads.put(Thread.currentThread(), cnt);
        } else {
            this.threads.remove(Thread.currentThread());
        }
    }

    static {
        $assertionsDisabled = !ConcurrencyCheckingList.class.desiredAssertionStatus();
    }
}

