/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.collection.ArrayBlockingQueue;
import jadex.util.collection.IBlockingQueue;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;

public class BlockingQueue
implements IBlockingQueue {
    protected List elems = new LinkedList();
    protected boolean closed;
    protected Object monitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object element) {
        if (this.closed) {
            throw new IBlockingQueue.ClosedException("Queue closed.");
        }
        Object object = this.monitor;
        synchronized (object) {
            this.elems.add(element);
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(long timeout) throws IBlockingQueue.ClosedException, IBlockingQueue.TimeoutException {
        if (this.closed) {
            throw new IBlockingQueue.ClosedException("Queue closed.");
        }
        Object object = this.monitor;
        synchronized (object) {
            if (timeout != -1L) {
                if (this.elems.isEmpty()) {
                    try {
                        this.monitor.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (this.closed) {
                        throw new IBlockingQueue.ClosedException("Queue closed.");
                    }
                    if (this.elems.isEmpty()) {
                        throw new IBlockingQueue.TimeoutException("Timeout during dequeue().");
                    }
                }
            } else {
                while (this.elems.isEmpty()) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (!this.closed) continue;
                    throw new IBlockingQueue.ClosedException("Queue closed.");
                }
            }
            return this.elems.remove(0);
        }
    }

    public Object dequeue() throws IBlockingQueue.ClosedException {
        return this.dequeue(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(boolean closed) {
        if (!this.closed) {
            Object object = this.monitor;
            synchronized (object) {
                this.closed = closed;
                this.monitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.elems.size();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        BlockingQueue.test1(args);
        Thread.sleep(2000L);
        BlockingQueue.test1b(args);
        Thread.sleep(2000L);
        BlockingQueue.test2(args);
    }

    public static void test1(String[] args) throws InterruptedException {
        int max = 5000000;
        final int[] stat = new int[3];
        final BlockingQueue queue = new BlockingQueue();
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Object item = queue.dequeue();
                        stat[1] = Math.max(queue.size(), stat[1]);
                        if (queue.size() != 0) continue;
                        stat[0] = stat[0] + 1;
                        if (queue.size() == 0 && stat[2] != 0) break;
                    }
                    System.out.println("Queue is now empty.");
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    throw new RuntimeException(sw.toString());
                }
            }
        }).start();
        for (int i = 0; i < 5000000; ++i) {
            queue.enqueue("Item");
            stat[1] = Math.max(queue.size(), stat[1]);
        }
        stat[2] = 1;
        System.out.println("Queue was empty " + stat[0] + " times.\n" + "Queue size is now " + queue.size() + ".\n" + "Max queue size was " + stat[1] + ".");
    }

    public static void test1b(String[] args) throws InterruptedException {
        int max = 5000000;
        final int[] stat = new int[3];
        final ArrayBlockingQueue queue = new ArrayBlockingQueue();
        new Thread(new Runnable(){

            public void run() {
                try {
                    while (true) {
                        Object item = queue.dequeue();
                        stat[1] = Math.max(queue.size(), stat[1]);
                        if (queue.size() != 0) continue;
                        stat[0] = stat[0] + 1;
                        if (queue.size() == 0 && stat[2] != 0) break;
                    }
                    System.out.println("Queue is now empty.");
                }
                catch (Exception e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    throw new RuntimeException(sw.toString());
                }
            }
        }).start();
        for (int i = 0; i < 5000000; ++i) {
            queue.enqueue("Item");
            stat[1] = Math.max(queue.size(), stat[1]);
        }
        stat[2] = 1;
        System.out.println("Queue was empty " + stat[0] + " times.\n" + "Queue size is now " + queue.size() + ".\n" + "Max queue size was " + stat[1] + ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void test2(String[] args) throws InterruptedException {
        final Object monitor = new Object();
        int num = 5000000;
        int[] max = new int[1];
        final int[] counter = new int[1];
        final boolean[] finished = new boolean[1];
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                int wait = 0;
                System.out.println("Thread started.");
                while (counter[0] > 0 || !finished[0]) {
                    Object object = monitor;
                    synchronized (object) {
                        try {
                            if (counter[0] == 0) {
                                monitor.wait();
                                ++wait;
                            }
                            if (counter[0] == 0) {
                                throw new RuntimeException();
                            }
                            counter[0] = counter[0] - 1;
                        }
                        catch (InterruptedException e) {
                            StringWriter sw = new StringWriter();
                            e.printStackTrace(new PrintWriter(sw));
                            throw new RuntimeException(sw.toString());
                        }
                    }
                }
                System.out.println("Thread finished. Waits:  " + wait);
            }
        }).start();
        System.out.println("Main started.");
        for (int i = 0; i < 5000000; ++i) {
            Object object = monitor;
            synchronized (object) {
                counter[0] = counter[0] + 1;
                max[0] = Math.max(counter[0], max[0]);
                monitor.notify();
                continue;
            }
        }
        finished[0] = true;
        System.out.println("Main finished. Max is " + max[0]);
    }
}

