/*
 * Decompiled with CFR 0.152.
 */
package jadex.util.collection;

import jadex.util.collection.IBlockingQueue;

public class ArrayBlockingQueue
implements IBlockingQueue {
    protected Object[] elements = new Object[255];
    protected int start;
    protected int end;
    protected int size;
    protected Object monitor = new Object();
    protected boolean closed;

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object o) {
        if (this.closed) {
            throw new IBlockingQueue.ClosedException("Queue closed.");
        }
        Object object = this.monitor;
        synchronized (object) {
            if (this.size == this.elements.length) {
                Object[] newelements = new Object[this.elements.length * 2];
                if (this.start < this.end) {
                    System.arraycopy(this.elements, this.start, newelements, 0, this.size);
                } else {
                    System.arraycopy(this.elements, this.start, newelements, 0, this.elements.length - this.start);
                    System.arraycopy(this.elements, 0, newelements, this.elements.length - this.start, this.end);
                }
                this.elements = newelements;
                this.start = 0;
                this.end = this.size;
            }
            this.elements[this.end] = o;
            this.end = (this.end + 1) % this.elements.length;
            ++this.size;
            this.monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dequeue(long timeout) throws IBlockingQueue.ClosedException, IBlockingQueue.TimeoutException {
        if (this.closed) {
            throw new IBlockingQueue.ClosedException("Queue closed.");
        }
        Object object = this.monitor;
        synchronized (object) {
            while (this.size == 0 && (timeout > 0L || timeout == -1L)) {
                try {
                    if (timeout == -1L) {
                        this.monitor.wait();
                    } else {
                        long starttime = System.currentTimeMillis();
                        this.monitor.wait(timeout);
                        if (this.size == 0) {
                            timeout = Math.max(0L, timeout + starttime - System.currentTimeMillis());
                            System.out.println("Remaining timeout: " + timeout);
                        }
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (this.closed) {
                    throw new IBlockingQueue.ClosedException("Queue closed.");
                }
                if (this.size != 0 || timeout != 0L) continue;
                throw new IBlockingQueue.TimeoutException("Timeout during dequeue().");
            }
            Object ret = this.elements[this.start];
            this.elements[this.start] = null;
            this.start = (this.start + 1) % this.elements.length;
            --this.size;
            return ret;
        }
    }

    public Object dequeue() {
        return this.dequeue(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClosed(boolean closed) {
        if (!this.closed) {
            Object object = this.monitor;
            synchronized (object) {
                this.closed = closed;
                this.monitor.notifyAll();
            }
        }
    }
}

