/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;

public class SimplePropertyChangeSupport
implements Serializable {
    private ArrayList listener;
    private Object source;

    public SimplePropertyChangeSupport(Object sourceBean) {
        if (sourceBean == null) {
            throw new NullPointerException();
        }
        this.listener = new ArrayList();
        this.source = sourceBean;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listener.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listener.remove(listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(this.source, propertyName, oldValue, newValue);
        for (int i = 0; i < this.listener.size(); ++i) {
            PropertyChangeListener oneListener = (PropertyChangeListener)this.listener.get(i);
            oneListener.propertyChange(evt);
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        Object oldValue = evt.getOldValue();
        Object newValue = evt.getNewValue();
        if (oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        for (int i = 0; i < this.listener.size(); ++i) {
            PropertyChangeListener oneListener = (PropertyChangeListener)this.listener.get(i);
            oneListener.propertyChange(evt);
        }
    }
}

