/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import jadex.util.DynamicURLClassLoader;
import jadex.util.ResourceInfo;
import jadex.util.SReflect;
import jadex.util.collection.SCollection;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarFile;

public class SUtil {
    public static final int CONVERT_ALL = 1;
    public static final int CONVERT_ALL_EXCEPT_AMP = 2;
    public static final int CONVERT_NONE = 3;
    public static final String NULL = "NULL";
    protected static Map htmlwraps = new Hashtable();
    protected static String seps;
    public static final int SORT_UP = 0;
    public static final int SORT_DOWN = 1;

    public static String[] getStringArray(String key, Properties props) {
        String[] ret = new String[]{};
        String os = props.getProperty(key);
        if (os != null) {
            StringTokenizer stok = new StringTokenizer(os, ",");
            ret = new String[stok.countTokens()];
            int i = 0;
            while (stok.hasMoreTokens()) {
                ret[i] = stok.nextToken().trim();
                ++i;
            }
        }
        return ret;
    }

    public static Object joinArrays(Object a1, Object a2) {
        int l1 = Array.getLength(a1);
        int l2 = Array.getLength(a2);
        Object res = Array.newInstance(a1.getClass().getComponentType(), l1 + l2);
        System.arraycopy(a1, 0, res, 0, l1);
        System.arraycopy(a2, 0, res, l1, l2);
        return res;
    }

    public static Object[] joinArbitraryArrays(Object[] as) {
        int lsum = 0;
        for (int i = 0; i < as.length; ++i) {
            lsum += Array.getLength(as[i]);
        }
        Object[] ret = new Object[lsum];
        int start = 0;
        for (int i = 0; i < as.length; ++i) {
            int length = Array.getLength(as[i]);
            System.arraycopy(as[i], 0, ret, start, length);
            start += length;
        }
        return ret;
    }

    public static Object cutArrays(Object a1, Object a2) {
        List ar1 = SUtil.arrayToList(a1);
        List ar2 = SUtil.arrayToList(a2);
        ArrayList ret = new ArrayList();
        for (int i = 0; i < ar1.size(); ++i) {
            Object tmp = ar1.get(i);
            if (!ar2.contains(tmp)) continue;
            ret.add(tmp);
        }
        return ret.toArray((Object[])Array.newInstance(a1.getClass().getComponentType(), ret.size()));
    }

    public static Object substractArrays(Object a1, Object a2) {
        List ar1 = SUtil.arrayToList(a1);
        List ar2 = SUtil.arrayToList(a2);
        for (int i = 0; i < ar2.size(); ++i) {
            Object tmp = ar2.get(i);
            if (!ar1.contains(tmp)) continue;
            ar1.remove(tmp);
        }
        return ar1.toArray((Object[])Array.newInstance(a1.getClass().getComponentType(), ar1.size()));
    }

    public static List arrayToList(Object a) {
        int l = Array.getLength(a);
        ArrayList ret = SCollection.createArrayList();
        for (int i = 0; i < l; ++i) {
            ret.add(Array.get(a, i));
        }
        return ret;
    }

    public static Set arrayToSet(Object a) {
        int l = Array.getLength(a);
        HashSet ret = SCollection.createHashSet();
        for (int i = 0; i < l; ++i) {
            ret.add(Array.get(a, i));
        }
        return ret;
    }

    public static List iteratorToList(Iterator it) {
        ArrayList ret = new ArrayList();
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public static List iteratorToList(Iterator it, List ret) {
        if (ret == null) {
            ret = new ArrayList();
        }
        while (it.hasNext()) {
            ret.add(it.next());
        }
        return ret;
    }

    public static Object[] iteratorToArray(Iterator it, Class clazz) {
        List list = SUtil.iteratorToList(it);
        return list.toArray((Object[])Array.newInstance(clazz, list.size()));
    }

    public static boolean arrayContains(Object array, Object value) {
        int l = Array.getLength(array);
        boolean ret = false;
        for (int i = 0; !ret && i < l; ++i) {
            ret = SUtil.equals(Array.get(array, i), value);
        }
        return ret;
    }

    public static boolean equals(Object val1, Object val2) {
        return val1 == null && val2 == null || val1 != null && val1.equals(val2);
    }

    public static boolean arrayEquals(Object array1, Object array2) {
        int l2;
        int l1;
        boolean ret;
        boolean bl = ret = array1 == null && array2 == null;
        if (!ret && array1 != null && array2 != null && (l1 = Array.getLength(array1)) == (l2 = Array.getLength(array2))) {
            ret = true;
            for (int i = 0; i < l1 && ret; ++i) {
                if (Array.get(array1, i).equals(Array.get(array2, i))) continue;
                ret = false;
            }
        }
        return ret;
    }

    public static String arrayToString(Object array) {
        String str = "";
        if (array != null && array.getClass().getComponentType() != null) {
            str = str + "[";
            for (int i = 0; i < Array.getLength(array); ++i) {
                str = str + SUtil.arrayToString(Array.get(array, i));
                if (i >= Array.getLength(array) - 1) continue;
                str = str + ", ";
            }
            str = str + "]";
        } else {
            str = str + "" + array;
        }
        return str;
    }

    public static String getSingular(String s) {
        String sing = s;
        if (s.endsWith("shes") || s.endsWith("ches") || s.endsWith("xes") || s.endsWith("ses")) {
            sing = s.substring(0, s.length() - 2);
        } else if (s.endsWith("ies")) {
            sing = s.substring(0, s.length() - 3) + "y";
        } else if (s.endsWith("s")) {
            sing = s.substring(0, s.length() - 1);
        }
        return sing;
    }

    public static String getPlural(String s) {
        String plu = s;
        plu = s.endsWith("y") ? s.substring(0, s.length() - 1) + "ies" : s + "s";
        return plu;
    }

    public static int compareTo(String a, String b) {
        return a.toUpperCase().toLowerCase().compareTo(b.toUpperCase().toLowerCase());
    }

    public static boolean isInRange(Date date, Date start, Date end) {
        boolean ret = true;
        if (start != null && date.before(start)) {
            ret = false;
        }
        if (ret && end != null && date.after(end)) {
            ret = false;
        }
        return ret;
    }

    public static String removeExtension(String fn) {
        int index = fn.lastIndexOf(".");
        if (index > -1) {
            fn = fn.substring(0, index);
        }
        return fn;
    }

    public static String wrapText(String text) {
        return SUtil.wrapText(text, 80);
    }

    public static String wrapText(String text, int wrap) {
        StringBuffer buf = new StringBuffer(text);
        int i = 0;
        while (buf.length() > i + wrap) {
            int next = buf.substring(i).indexOf("\n");
            if (next != -1 && next - i <= wrap) {
                i = i + next + 1;
                continue;
            }
            buf.insert(i + wrap, '\n');
            i = i + wrap + 1;
        }
        return buf.toString();
    }

    protected static int getExtremeElementIndex(Vector source, int direction) {
        String ret = (String)source.elementAt(0);
        int retidx = 0;
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            String tmp = (String)source.elementAt(i);
            int res = tmp.compareTo(ret);
            if ((res >= 0 || direction != 0) && (res <= 0 || direction != 1)) continue;
            ret = tmp;
            retidx = i;
        }
        return retidx;
    }

    public static String makeConform(String input) {
        return SUtil.makeConform(input, 1);
    }

    public static String makeConform(String input, int flag) {
        String res = input;
        if (flag != 3) {
            StringTokenizer stok = new StringTokenizer(input, seps, true);
            res = "";
            while (stok.hasMoreTokens()) {
                String tmp = stok.nextToken();
                String rep = null;
                if (!tmp.equals("&") || flag != 2) {
                    rep = (String)htmlwraps.get(tmp);
                }
                if (rep != null) {
                    res = res + rep;
                    continue;
                }
                res = res + tmp;
            }
        }
        return res;
    }

    public static String stripTags(String source) {
        int end;
        int start;
        while ((start = source.indexOf("<")) != -1 && (end = source.indexOf(">")) > start) {
            if (end == source.length() - 1) {
                source = source.substring(0, start);
                continue;
            }
            source = source.substring(0, start) + source.substring(end + 1);
        }
        return source;
    }

    public static String makeEnglishConform(String input) {
        StringTokenizer stok = new StringTokenizer(input, seps, true);
        String res = "";
        while (stok.hasMoreTokens()) {
            String tmp = stok.nextToken();
            if (htmlwraps.get(tmp) != null) continue;
            res = res + tmp;
        }
        return res;
    }

    public static String colorToHTML(Color color) {
        return "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
    }

    public static String fontToHTML(Font font) {
        String style = font.isBold() ? (font.isItalic() ? "bolditalic " : "bold ") : (font.isItalic() ? "italic " : "");
        return style + font.getSize() + " " + font.getName();
    }

    public static void replace(String source, StringBuffer dest, String old, String newstring) {
        int index;
        int last = 0;
        while ((index = source.indexOf(old, last)) != -1) {
            dest.append(source.substring(last, index));
            dest.append(newstring);
            last = index + old.length();
        }
        dest.append(source.substring(last));
    }

    public static String replace(String source, String old, String newstring) {
        StringBuffer sbuf = new StringBuffer();
        SUtil.replace(source, sbuf, old, newstring);
        return sbuf.toString();
    }

    public static InputStream getResource(String name) throws IOException {
        InputStream is = SUtil.getResource0(name);
        if (is == null) {
            throw new IOException("Could not load file: " + name);
        }
        return is;
    }

    public static synchronized InputStream getResource0(String name) {
        InputStream is = null;
        try {
            File file = new File(name);
            if (file.exists()) {
                try {
                    is = new FileInputStream(file);
                }
                catch (FileNotFoundException e) {}
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (is == null) {
            is = DynamicURLClassLoader.getInstance().getResourceAsStream(name.startsWith("/") ? name.substring(1) : name);
        }
        if (is == null) {
            try {
                is = new URL(name).openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return is;
    }

    public static synchronized ResourceInfo getResourceInfo0(String name) {
        URLConnection con;
        URL url;
        File file;
        ResourceInfo ret = null;
        try {
            file = new File(name);
            if (file.exists()) {
                if (file.isDirectory()) {
                    ret = new ResourceInfo(file.getAbsolutePath(), null, file.lastModified());
                } else {
                    try {
                        ret = new ResourceInfo(file.getAbsolutePath(), new FileInputStream(file), file.lastModified());
                    }
                    catch (FileNotFoundException e) {}
                }
            }
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (ret == null && (url = DynamicURLClassLoader.getInstance().getResource(name.startsWith("/") ? name.substring(1) : name)) != null) {
            if (url.getProtocol().equals("file")) {
                file = new File(URLDecoder.decode(url.getFile()));
                if (file.exists()) {
                    if (file.isDirectory()) {
                        ret = new ResourceInfo(file.getAbsolutePath(), null, file.lastModified());
                    } else {
                        try {
                            ret = new ResourceInfo(file.getAbsolutePath(), new FileInputStream(file), file.lastModified());
                        }
                        catch (FileNotFoundException fnfe) {}
                    }
                }
            } else {
                try {
                    url = DynamicURLClassLoader.getInstance().getResource(name.startsWith("/") ? name.substring(1) : name);
                    con = url.openConnection();
                    long modified = con.getLastModified();
                    String filename = url.getFile();
                    if (con instanceof JarURLConnection) {
                        JarURLConnection juc = (JarURLConnection)con;
                        if (!filename.startsWith("jar:")) {
                            filename = "jar:" + filename;
                        }
                        if (juc.getJarEntry().getTime() != -1L) {
                            modified = juc.getJarEntry().getTime();
                        }
                        try {
                            ret = new ResourceInfo(filename, con.getInputStream(), modified);
                        }
                        catch (NullPointerException e) {
                            String jarfilename = juc.getJarFile().getName();
                            ret = new ResourceInfo(filename, new JarFile(jarfilename).getInputStream(juc.getJarEntry()), modified);
                        }
                    } else {
                        ret = new ResourceInfo(filename, con.getInputStream(), modified);
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        if (ret == null) {
            try {
                url = new URL(name);
                con = url.openConnection();
                ret = new ResourceInfo(name, con.getInputStream(), con.getLastModified());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static String getDurationHMS(long ms) {
        long h = ms / 3600000L;
        long m = (ms -= h * 3600000L) / 60000L;
        long s = (ms -= m * 60000L) / 1000L;
        ms -= s * 1000L;
        StringBuffer ret = new StringBuffer("");
        if (h > 0L) {
            ret.append(h);
            ret.append("h ");
        }
        if (m > 0L) {
            ret.append(m);
            ret.append("min ");
        }
        ret.append(s);
        ret.append(",");
        ret.append(ms / 100L);
        ret.append("s ");
        return ret.toString();
    }

    public static String convertPathToPackage(String path) {
        ClassLoader cl;
        String ret = null;
        if (new File(path).isDirectory() && (cl = DynamicURLClassLoader.getInstance()) instanceof DynamicURLClassLoader) {
            ArrayList toks = SCollection.createArrayList();
            StringTokenizer stok = new StringTokenizer(path, File.separator);
            while (stok.hasMoreTokens()) {
                toks.add(stok.nextToken());
            }
            List cps = ((DynamicURLClassLoader)cl).getAllClasspathURLs();
            int quality = 0;
            for (int i = 0; i < cps.size(); ++i) {
                String cp = ((URL)cps.get(i)).getFile();
                stok = new StringTokenizer(cp, "/");
                int cplen = stok.countTokens();
                if (cplen > toks.size()) continue;
                int j = 0;
                while (stok.hasMoreTokens() && stok.nextToken().equals(toks.get(j))) {
                    ++j;
                }
                if (j != cplen || cplen <= quality) continue;
                ret = "";
                for (int k = j; k < toks.size(); ++k) {
                    if (k > j && k < toks.size()) {
                        ret = ret + ".";
                    }
                    ret = ret + "" + toks.get(k);
                }
                quality = cplen;
            }
        }
        return ret;
    }

    public static List calculateCartesianProduct(String[] names, Object[] values) {
        int i;
        ArrayList ret = SCollection.createArrayList();
        if (names == null || values == null) {
            return ret;
        }
        if (names.length != values.length) {
            throw new IllegalArgumentException("Must have same length: " + names.length + " " + values.length);
        }
        HashMap binding = SCollection.createHashMap();
        Iterator[] iters = new Iterator[values.length];
        for (i = 0; i < values.length; ++i) {
            iters[i] = SReflect.getIterator(values[i]);
            if (!iters[i].hasNext()) {
                return ret;
            }
            binding.put(names[i], iters[i].next());
        }
        ret.add(binding);
        while (true) {
            binding = (HashMap)binding.clone();
            for (i = 0; i < values.length && !iters[i].hasNext(); ++i) {
                iters[i] = SReflect.getIterator(values[i]);
                binding.put(names[i], iters[i].next());
            }
            if (i >= iters.length) break;
            binding.put(names[i], iters[i].next());
            ret.add(binding);
        }
        return ret;
    }

    public static String getRelativePath(String startdir, String destdir) {
        int i;
        String name;
        String name2;
        File tmp;
        String ret = "";
        File startdirf = new File(startdir);
        if (startdirf.exists() && !startdirf.isDirectory()) {
            startdirf = startdirf.getParentFile();
        }
        ArrayList tmpl = SCollection.createArrayList();
        for (tmp = startdirf; tmp != null && (name2 = tmp.getName()).length() != 0; tmp = tmp.getParentFile()) {
            tmpl.add(0, name2);
        }
        String[] startpath = tmpl.toArray(new String[tmpl.size()]);
        File destdirf = new File(destdir);
        if (destdirf.exists() && !destdirf.isDirectory()) {
            destdirf = startdirf.getParentFile();
        }
        tmpl = SCollection.createArrayList();
        for (tmp = destdirf; tmp != null && (name = tmp.getName()).length() != 0; tmp = tmp.getParentFile()) {
            tmpl.add(0, name);
        }
        String[] destpath = tmpl.toArray(new String[tmpl.size()]);
        int baselength = 0;
        for (i = 0; i < Math.min(startpath.length, destpath.length) && startpath[i].equals(destpath[i]); ++i) {
            ++baselength;
        }
        for (i = startpath.length; i > baselength; --i) {
            ret = ret + (ret.length() != 0 ? File.separator + ".." : "..");
        }
        for (i = baselength; i < destpath.length; ++i) {
            ret = ret + File.separator + destpath[i];
        }
        if (ret.length() > 0) {
            ret = ret + File.separator;
        }
        return ret;
    }

    static {
        htmlwraps.put("\"", "&quot;");
        htmlwraps.put("&", "&amp;");
        htmlwraps.put("'", "&apos;");
        htmlwraps.put("<", "&lt;");
        htmlwraps.put(">", "&gt;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&auml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Auml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&uuml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Uuml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ouml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ouml;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&acute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&agrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&aring;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&acirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Acute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Agrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Aring;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Acirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ecute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&egrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ecirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ecute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Egrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ecirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&icute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&igrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&icirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Icute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Igrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Icirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ocute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ograve;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ocirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&otilde;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ocute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ograve;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ocirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Otilde;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ucute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ugrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&ucirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ucute;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ugrave;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ucirc;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&cccedil;");
        htmlwraps.put("\u00ef\u00bf\u00bd", "&Ccedil;");
        seps = "";
        Iterator it = htmlwraps.keySet().iterator();
        while (it.hasNext()) {
            seps = seps + (String)it.next();
        }
    }
}

