/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import jadex.util.DynamicURLClassLoader;
import jadex.util.collection.SCollection;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public class SReflect {
    protected static final Object NOTFOUND;
    protected static Map classcache;
    protected static Map innerclassnamecache;
    protected static Map methodcache;
    protected static Map fieldcache;
    protected static Map basictypes;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public static Class getWrappedType(Class clazz) {
        if (!$assertionsDisabled && clazz == null) {
            throw new AssertionError();
        }
        Class result = (Class)basictypes.get(clazz);
        return result == null ? clazz : result;
    }

    public static boolean isBasicType(Class clazz) {
        return basictypes.get(clazz) != null;
    }

    public static Class classForName0(String name) {
        return SReflect.classForName0(name, true);
    }

    public static Class classForName0(String name, boolean initialize) {
        Object clazz = classcache.get(name);
        if (clazz == null) {
            try {
                clazz = DynamicURLClassLoader.loadClassWithInstance(name, initialize);
                classcache.put(name, clazz);
            }
            catch (ClassNotFoundException e) {
                classcache.put(name, NOTFOUND);
            }
            catch (LinkageError e) {
                classcache.put(name, NOTFOUND);
            }
        } else if (clazz == NOTFOUND) {
            clazz = null;
        }
        return (Class)clazz;
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        Class clazz = SReflect.classForName0(name);
        if (clazz == null) {
            throw new ClassNotFoundException("Class " + name + " not found.");
        }
        return clazz;
    }

    public static Object createInnerClassInstance(Object object, String name, Class type) {
        Class<?> clazz = object.getClass();
        Object instance = null;
        while (instance == null && !clazz.equals(class$java$lang$Object == null ? SReflect.class$("java.lang.Object") : class$java$lang$Object)) {
            try {
                Class<?> cls = DynamicURLClassLoader.getInstance().loadClass(clazz.getName() + "$" + name);
                Constructor<?> con = cls.getConstructor(clazz);
                instance = con.newInstance(object);
                if (type == null || type.isInstance(instance)) continue;
                instance = null;
                clazz = clazz.getSuperclass();
            }
            catch (ClassNotFoundException e) {
                clazz = clazz.getSuperclass();
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
            catch (IllegalAccessException e) {
                clazz = clazz.getSuperclass();
            }
            catch (InstantiationException e) {
                clazz = clazz.getSuperclass();
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                t.printStackTrace();
                throw new RuntimeException(t.toString());
            }
        }
        return instance;
    }

    public static Class[] getAnonymousInnerClasses(Class clazz) {
        Class inner;
        ArrayList<Class> classes = new ArrayList<Class>();
        int i = 1;
        while ((inner = SReflect.classForName0(clazz.getName() + "$" + i)) != null) {
            classes.add(inner);
            ++i;
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static String getClassName(Class clazz) {
        int dim = 0;
        while (clazz.isArray()) {
            ++dim;
            clazz = clazz.getComponentType();
        }
        String classname = clazz.getName();
        for (int i = 0; i < dim; ++i) {
            classname = classname + "[]";
        }
        return classname;
    }

    public static String getUnqualifiedClassName(Class clazz) {
        String classname = SReflect.getClassName(clazz);
        StringTokenizer stok = new StringTokenizer(classname, ".");
        while (stok.hasMoreTokens()) {
            classname = stok.nextToken();
        }
        return classname;
    }

    public static String getInnerClassName(Class clazz) {
        String classname = (String)innerclassnamecache.get(clazz);
        if (classname == null) {
            classname = SReflect.getUnqualifiedClassName(clazz);
            StringTokenizer stok = new StringTokenizer(classname, "$");
            while (stok.hasMoreTokens()) {
                classname = stok.nextToken();
            }
            innerclassnamecache.put(clazz, classname);
        }
        return classname;
    }

    public static String getPackageName(Class clazz) {
        String classname = clazz.getName();
        StringTokenizer stok = new StringTokenizer(classname, ".");
        String packagename = "";
        while (stok.countTokens() > 1) {
            packagename = packagename + stok.nextToken();
            if (stok.countTokens() <= 1) continue;
            packagename = packagename + ".";
        }
        return packagename;
    }

    public static Field getField(Class clazz, String name) {
        Field field = null;
        Class cls = clazz;
        while (field == null && cls != null && !cls.equals(class$java$lang$Object == null ? SReflect.class$("java.lang.Object") : class$java$lang$Object)) {
            try {
                field = cls.getDeclaredField(name);
            }
            catch (Exception e) {
                cls = cls.getSuperclass();
            }
        }
        if (field == null) {
            try {
                field = clazz.getField(name);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return field;
    }

    public static Field getCachedField(Class clazz, String name) throws NoSuchFieldException {
        Object o;
        Field ret = null;
        HashMap<String, Object> fields = (HashMap<String, Object>)fieldcache.get(clazz);
        if (fields == null) {
            fields = new HashMap<String, Object>();
            fieldcache.put(clazz, fields);
        }
        if ((o = fields.get(name)) instanceof Field) {
            ret = (Field)o;
        } else if (o == null) {
            try {
                ret = clazz.getField(name);
                fields.put(name, ret);
            }
            catch (NoSuchFieldException e) {
                fields.put(name, e);
                throw e;
            }
        } else {
            throw (NoSuchFieldException)o;
        }
        return ret;
    }

    public static Object getDeclared(Object o, String fieldname) {
        Class<?> clazz = o.getClass();
        Object os = null;
        Field field = null;
        try {
            field = clazz.getDeclaredField(fieldname);
            os = field.get(o);
        }
        catch (Exception e) {
            // empty catch block
        }
        return os;
    }

    public static Method getMethod(Class clazz, String name, Class[] types) {
        Method meth = null;
        Method[] ms = SReflect.getMethods(clazz, name);
        for (int i = 0; i < ms.length; ++i) {
            Class<?>[] ptypes = ms[i].getParameterTypes();
            boolean match = ptypes.length == types.length;
            for (int j = 0; match && j < ptypes.length; ++j) {
                match = ptypes[j].equals(types[j]);
            }
            if (!match) continue;
            meth = ms[i];
            break;
        }
        return meth;
    }

    public static Method[] getMethods(Class clazz, String name) {
        Method[] ret;
        Map map = (Map)methodcache.get(clazz);
        if (map == null) {
            map = SCollection.createHashMap();
            methodcache.put(clazz, map);
        }
        if ((ret = (Method[])map.get(name)) == null) {
            int i;
            Method[] ms = clazz.getMethods();
            int cnt = 0;
            for (i = 0; i < ms.length; ++i) {
                if (ms[i].getName().equals(name)) {
                    ++cnt;
                    continue;
                }
                ms[i] = null;
            }
            ret = new Method[cnt];
            cnt = 0;
            for (i = 0; i < ms.length; ++i) {
                if (ms[i] == null) continue;
                ret[cnt++] = ms[i];
            }
            map.put(name, ret);
        }
        return ret;
    }

    public static Class findClass(String clname, String[] imports) throws ClassNotFoundException {
        Class clazz = SReflect.findClass0(clname, imports);
        if (clazz == null) {
            throw new ClassNotFoundException("Class " + clname + " not found in imports: " + imports);
        }
        return clazz;
    }

    public static Class findClass0(String clname, String[] imports) {
        int dimension = 0;
        if (clname.indexOf(91) != -1) {
            int i = clname.indexOf(91);
            while (i != -1) {
                ++dimension;
                i = clname.indexOf(91, i + 1);
            }
            clname = clname.substring(0, clname.indexOf(91));
        }
        Class clazz = null;
        clazz = SReflect.classForName0(clname);
        if (clazz == null && imports != null) {
            for (int i = -1; clazz == null && i < imports.length; ++i) {
                String imp;
                String string = imp = i == -1 ? "java.lang.*" : imports[i];
                if (imp.endsWith(".*")) {
                    clazz = SReflect.classForName0(imp.substring(0, imp.length() - 1) + clname);
                    continue;
                }
                if (!imports[i].endsWith(clname)) continue;
                clazz = SReflect.classForName0(imp);
            }
        } else if (clazz == null) {
            clazz = SReflect.classForName0("java.lang." + clname);
        }
        if (clazz != null && dimension > 0) {
            clazz = Array.newInstance(clazz, new int[dimension]).getClass();
        }
        return clazz;
    }

    public static int[] matchArgumentTypes(Class[] argtypes, Class[][] paramtypes) {
        int[] matches = new int[paramtypes.length];
        int hq = 0;
        int cnt = 0;
        for (int i = 0; i < paramtypes.length; ++i) {
            if (paramtypes[i].length == argtypes.length) {
                for (int j = 0; j < argtypes.length && matches[i] != -1; ++j) {
                    if (argtypes[j] == null) continue;
                    if (!SReflect.isSupertype(paramtypes[i][j], argtypes[j])) {
                        matches[i] = -1;
                        continue;
                    }
                    if (SReflect.getWrappedType(paramtypes[i][j]) != SReflect.getWrappedType(argtypes[j])) continue;
                    int n = i;
                    matches[n] = matches[n] + 1;
                    if (matches[i] <= hq) continue;
                    hq = matches[i];
                }
                if (matches[i] == -1) continue;
                ++cnt;
                continue;
            }
            matches[i] = -1;
        }
        int[] ret = new int[cnt];
        cnt = 0;
        while (hq >= 0) {
            for (int i = 0; i < matches.length; ++i) {
                if (matches[i] != hq) continue;
                ret[cnt++] = i;
            }
            --hq;
        }
        return ret;
    }

    public static boolean isSupertype(Class clazz1, Class clazz2) {
        if ((clazz1 = SReflect.getWrappedType(clazz1)) == (clazz2 = SReflect.getWrappedType(clazz2))) {
            return true;
        }
        if (clazz1 == Double.class && (clazz2 == Float.class || clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class || clazz2 == Character.class)) {
            return true;
        }
        if (clazz1 == Float.class && (clazz2 == Long.class || clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class || clazz2 == Character.class)) {
            return true;
        }
        if (clazz1 == Long.class && (clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Byte.class || clazz2 == Character.class)) {
            return true;
        }
        if (clazz1 == Integer.class && (clazz2 == Short.class || clazz2 == Byte.class || clazz2 == Character.class)) {
            return true;
        }
        if (clazz1 == Short.class && clazz2 == Byte.class) {
            return true;
        }
        return clazz1.isAssignableFrom(clazz2);
    }

    public static Object convertWrappedValue(Object value, Class clazz) {
        if (SReflect.isSupertype(Number.class, clazz = SReflect.getWrappedType(clazz))) {
            if (value instanceof Character) {
                value = new Integer(((Character)value).charValue());
            }
            Number num = null;
            try {
                num = (Number)value;
            }
            catch (ClassCastException e) {
                System.out.println(":: " + value + " " + value.getClass() + " " + clazz);
            }
            if (clazz.equals(Double.class)) {
                value = new Double(num.doubleValue());
            } else if (clazz.equals(Float.class)) {
                value = new Float(num.floatValue());
            } else if (clazz.equals(Long.class)) {
                value = new Long(num.longValue());
            } else if (clazz.equals(Integer.class)) {
                value = new Integer(num.intValue());
            } else if (clazz.equals(Short.class)) {
                value = new Short(num.shortValue());
            }
        }
        return value;
    }

    public static Iterator getIterator(Object collection) {
        if (collection == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (collection instanceof Iterator) {
            return (Iterator)collection;
        }
        if (collection instanceof Enumeration) {
            final Enumeration eoc = (Enumeration)collection;
            return new Iterator(){

                public boolean hasNext() {
                    return eoc.hasMoreElements();
                }

                public Object next() {
                    return eoc.nextElement();
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove() not supported for enumerations");
                }
            };
        }
        if (collection instanceof Collection) {
            return ((Collection)collection).iterator();
        }
        if (collection instanceof Map) {
            return ((Map)collection).values().iterator();
        }
        if (collection != null && collection.getClass().isArray()) {
            final Object array = collection;
            return new Iterator(){
                int i = 0;

                public boolean hasNext() {
                    return this.i < Array.getLength(array);
                }

                public Object next() {
                    return Array.get(array, this.i++);
                }

                public void remove() {
                    throw new UnsupportedOperationException("remove() not supported for arrays");
                }
            };
        }
        throw new IllegalArgumentException("Cannot iterate over " + collection);
    }

    public static boolean instanceOf(Object o, Class c) {
        return SReflect.isSupertype(c, o.getClass());
    }

    public static boolean instanceOf(Object o, String c) {
        boolean ret = false;
        try {
            Class<?> clazz = DynamicURLClassLoader.getInstance().loadClass(c);
            ret = SReflect.isSupertype(clazz, o.getClass());
        }
        catch (Exception e) {
            // empty catch block
        }
        return ret;
    }

    public static void clearClassCache() {
        classcache = new Hashtable();
        classcache.put("boolean", Boolean.TYPE);
        classcache.put("int", Integer.TYPE);
        classcache.put("double", Double.TYPE);
        classcache.put("float", Float.TYPE);
        classcache.put("long", Long.TYPE);
        classcache.put("short", Short.TYPE);
        classcache.put("byte", Byte.TYPE);
        classcache.put("char", Character.TYPE);
        methodcache.clear();
        fieldcache.clear();
    }

    static {
        $assertionsDisabled = !SReflect.class.desiredAssertionStatus();
        NOTFOUND = new Object();
        innerclassnamecache = new WeakHashMap();
        methodcache = new WeakHashMap();
        fieldcache = new WeakHashMap();
        basictypes = new Hashtable();
        basictypes.put("boolean", Boolean.class);
        basictypes.put("int", Integer.class);
        basictypes.put("double", Double.class);
        basictypes.put("float", Float.class);
        basictypes.put("long", Long.class);
        basictypes.put("short", Short.class);
        basictypes.put("byte", Byte.class);
        basictypes.put("char", Character.class);
        basictypes.put(Boolean.TYPE, Boolean.class);
        basictypes.put(Integer.TYPE, Integer.class);
        basictypes.put(Double.TYPE, Double.class);
        basictypes.put(Float.TYPE, Float.class);
        basictypes.put(Long.TYPE, Long.class);
        basictypes.put(Short.TYPE, Short.class);
        basictypes.put(Byte.TYPE, Byte.class);
        basictypes.put(Character.TYPE, Character.class);
        SReflect.clearClassCache();
    }
}

