/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.UIDefaults;

public class SGUI {
    public static final String AUTO_ADJUST = "auto-adjust";

    public static JMenuBar createMenuBar(Action[] actions) {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu("Actions");
        menubar.add(menu);
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                menu.addSeparator();
                continue;
            }
            menu.add(new JMenuItem(actions[i]));
        }
        return menubar;
    }

    public static JToolBar createToolBar(String name, Action[] actions) {
        JToolBar toolbar = new JToolBar(name);
        toolbar.addSeparator();
        for (int i = 0; i < actions.length; ++i) {
            if (actions[i] == null) {
                toolbar.addSeparator();
                continue;
            }
            JButton button = new JButton(actions[i]);
            button.setToolTipText((String)actions[i].getValue("Name"));
            button.setText("");
            button.setActionCommand((String)actions[i].getValue("Name"));
            button.setRequestFocusEnabled(false);
            button.setMargin(new Insets(1, 1, 1, 1));
            toolbar.add(button);
        }
        return toolbar;
    }

    public static Action createAction(String name, Icon icon, final ActionListener listener) {
        return new AbstractAction(name, icon){

            public void actionPerformed(ActionEvent ae) {
                listener.actionPerformed(ae);
            }
        };
    }

    public static Object makeIcon(final Class baseclass, final String imgloc) {
        return new UIDefaults.LazyValue(){

            public Object createValue(UIDefaults table) {
                URL url = baseclass.getResource(imgloc);
                if (url == null) {
                    throw new RuntimeException("Cannot load image: " + imgloc);
                }
                return new ImageIcon(url);
            }
        };
    }

    public static void renderObject(Graphics g, Component comp, double cellw, double cellh, int x, int y, int gridwidth) {
        Rectangle bounds = new Rectangle((int)(cellw * (double)x) + gridwidth, (int)(cellh * (double)y) + gridwidth, (int)(cellw * (double)(x + 1)) - (int)(cellw * (double)x) - gridwidth * 2, (int)(cellh * (double)(y + 1)) - (int)(cellh * (double)y) - gridwidth * 2);
        comp.setBounds(bounds);
        g.translate(bounds.x, bounds.y);
        comp.paint(g);
        g.translate(-bounds.x, -bounds.y);
    }

    public static Point calculateMiddlePosition(Window win) {
        return SGUI.calculateMiddlePosition(null, win);
    }

    public static Point calculateMiddlePosition(Window outer, Window win) {
        int ry;
        int rx;
        if (outer != null && outer.isVisible()) {
            Point p = outer.getLocationOnScreen();
            rx = (int)(p.getX() + (double)(outer.getWidth() / 2));
            ry = (int)(p.getY() + (double)(outer.getHeight() / 2));
        } else {
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            rx = (int)size.getWidth() / 2;
            ry = (int)size.getHeight() / 2;
        }
        int x = rx - win.getWidth() / 2;
        int y = ry - win.getHeight() / 2;
        return new Point(x, y);
    }

    public static Window getWindowParent(Component comp) {
        while (comp != null && !(comp instanceof Window)) {
            comp = comp.getParent();
        }
        return (Window)comp;
    }

    public static void showMessageDialog(Component parent, Object message, String title, int msgtype) {
        JOptionPane pane = new JOptionPane(message, msgtype);
        final JDialog dialog = pane.createDialog(parent, title);
        dialog.setModal(false);
        pane.selectInitialValue();
        dialog.setVisible(true);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                dialog.removeWindowListener(this);
                dialog.dispose();
            }
        });
    }

    public static void adjustComponentSizes(JComponent[] components) {
        int minimumwidth = 0;
        int minimumheight = 0;
        int maximumwidth = 0;
        int maximumheight = 0;
        int preferredwidth = 0;
        int preferredheight = 0;
        for (int i = 0; i < components.length; ++i) {
            Dimension minimum = components[i].getMinimumSize();
            Dimension maximum = components[i].getMaximumSize();
            Dimension preferred = components[i].getPreferredSize();
            minimumwidth = Math.max(minimumwidth, minimum.width);
            minimumheight = Math.max(minimumheight, minimum.height);
            maximumwidth = Math.max(maximumwidth, maximum.width);
            maximumheight = Math.max(maximumheight, maximum.height);
            preferredwidth = Math.max(preferredwidth, preferred.width);
            preferredheight = Math.max(preferredheight, preferred.height);
        }
        Dimension minimum = new Dimension(minimumwidth, minimumheight);
        Dimension maximum = new Dimension(maximumwidth, maximumheight);
        Dimension preferred = new Dimension(preferredwidth, preferredheight);
        for (int i = 0; i < components.length; ++i) {
            components[i].setMinimumSize(minimum);
            components[i].setMaximumSize(minimum);
            components[i].setPreferredSize(preferred);
        }
    }

    public static void adjustComponentSizes(Container parent) {
        LinkedList<Component> components = new LinkedList<Component>();
        ArrayList<JComponent> adjustables = new ArrayList<JComponent>();
        components.add(parent);
        while (components.size() > 0) {
            JComponent jcomp;
            Object comp = components.remove(0);
            if (comp instanceof JComponent && (jcomp = (JComponent)comp).getClientProperty(AUTO_ADJUST) != null) {
                adjustables.add(jcomp);
            }
            if (!(comp instanceof Container)) continue;
            Container container = (Container)comp;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                components.add(container.getComponent(i));
            }
        }
        if (adjustables.size() > 1) {
            JComponent[] jcomps = adjustables.toArray(new JComponent[adjustables.size()]);
            SGUI.adjustComponentSizes(jcomps);
        }
    }
}

