/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import jadex.util.CachedObject;
import jadex.util.collection.SCollection;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Map;

public class ObjectCache
implements Serializable {
    protected boolean persist_always;
    protected boolean persist_single;
    protected String filename;
    protected Map cache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ObjectCache(String filename) {
        this(filename, false, false);
    }

    public ObjectCache(String filename, boolean persist_always, boolean persist_single) {
        this(filename, persist_always, persist_single, 25);
    }

    public ObjectCache(String filename, boolean persist_always, boolean persist_single, int max) {
        if (!persist_single && filename == null) {
            throw new IllegalArgumentException("Filename must not null when saving to single file.");
        }
        this.persist_always = persist_always;
        this.persist_single = persist_single;
        this.filename = filename;
        this.cache = SCollection.createLRU(max);
    }

    public synchronized CachedObject loadCachedObject(String filename, long lastmodified) {
        if (!$assertionsDisabled && filename == null) {
            throw new AssertionError();
        }
        CachedObject ret = (CachedObject)this.cache.get(filename);
        if (ret == null && this.persist_single) {
            InputStream fis = null;
            ObjectInputStream ois = null;
            try {
                fis = filename.startsWith("jar:") || filename.startsWith("http:") || filename.startsWith("ftp:") ? new URL(filename).openStream() : new FileInputStream(filename);
                ois = new ObjectInputStream(fis);
                ret = (CachedObject)ois.readObject();
                this.cache.put(filename, ret);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!(ret == null || lastmodified == -1L || lastmodified == ret.getLastModified() || filename.startsWith("jar:") && Math.abs(lastmodified - ret.getLastModified()) < 2000L)) {
            System.out.println("Cache outdated: " + filename);
            ret = null;
            this.cache.remove(filename);
        }
        return ret;
    }

    public synchronized void add(CachedObject co) {
        if (this.cache.containsKey(co.getFilename())) {
            return;
        }
        this.cache.put(co.getFilename(), co);
        if (this.persist_always) {
            if (!this.persist_single) {
                try {
                    this.persist();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not persist object cache: " + this.filename);
                }
            }
            try {
                co.persist();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not persist cached object: " + this.filename);
            }
        }
    }

    public synchronized void remove(String filename) {
        this.cache.remove(filename);
    }

    public synchronized void persist() throws IOException {
        if (!this.persist_single) {
            if (!this.filename.startsWith("jar:")) {
                try {
                    ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));
                    oos.writeObject(this);
                    oos.close();
                }
                catch (FileNotFoundException e) {
                    throw new IOException("Could not write cache to disk: " + this.filename);
                }
            }
        } else {
            CachedObject[] cos = this.cache.values().toArray(new CachedObject[this.cache.size()]);
            for (int i = 0; i < cos.length; ++i) {
                cos[i].persist();
            }
        }
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public static synchronized ObjectCache loadObjectCache(String filename) {
        ObjectCache ret = null;
        InputStream fis = null;
        ObjectInputStream ois = null;
        try {
            fis = filename.startsWith("jar:") || filename.startsWith("http:") || filename.startsWith("ftp:") ? new URL(filename).openStream() : new FileInputStream(filename);
            ois = new ObjectInputStream(fis);
            ret = (ObjectCache)ois.readObject();
        }
        catch (Exception e) {
            System.out.println("Could not load models cache: " + filename);
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (ois != null) {
                ois.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    static {
        $assertionsDisabled = !ObjectCache.class.desiredAssertionStatus();
    }
}

