/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import jadex.util.collection.SCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;

public class MultiStream
extends OutputStream {
    protected OutputStream[] outs;
    protected Set disabled;

    public MultiStream(OutputStream[] outs) {
        this.outs = outs;
        this.disabled = SCollection.createHashSet();
    }

    public void write(int b) throws IOException {
        for (int i = 0; i < this.outs.length; ++i) {
            if (this.disabled.contains(this.outs[i])) continue;
            this.outs[i].write(b);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < this.outs.length; ++i) {
            if (this.disabled.contains(this.outs[i])) continue;
            this.outs[i].write(b, off, len);
        }
    }

    public void close() throws IOException {
        for (int i = 0; i < this.outs.length; ++i) {
            this.outs[i].close();
        }
    }

    public void flush() throws IOException {
        for (int i = 0; i < this.outs.length; ++i) {
            if (this.disabled.contains(this.outs[i])) continue;
            this.outs[i].flush();
        }
    }

    public OutputStream[] getOutputStreams() {
        return this.outs;
    }

    public void setOutputStreams(OutputStream[] outs) {
        this.outs = outs;
    }

    public void setEnabled(OutputStream out, boolean enabled) {
        if (enabled) {
            this.disabled.remove(out);
        } else {
            this.disabled.add(out);
        }
    }
}

