/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import java.util.StringTokenizer;
import java.util.Vector;

public class ExpressionTokenizer {
    public static final String ESCAPE_CHARACTERS = "\\";
    protected String source;
    protected String separators;
    protected String open;
    protected String close;
    protected boolean retsep;
    protected String allseps;
    protected int pos;

    public ExpressionTokenizer(String string, String separators, String[] metas) {
        this(string, separators, metas, false);
    }

    public ExpressionTokenizer(String string, String separators, String[] metas, boolean retsep) {
        this.source = string;
        this.separators = separators;
        this.retsep = retsep;
        this.open = "";
        this.close = "";
        for (int i = 0; i < metas.length; ++i) {
            this.open = this.open + metas[i].charAt(0);
            this.close = this.close + metas[i].charAt(1);
        }
        this.allseps = separators + this.open + this.close;
        this.pos = 0;
    }

    public String nextToken() {
        if (this.separatorAt(this.pos)) {
            if (this.retsep) {
                return String.valueOf(this.source.charAt(this.pos++));
            }
            while (this.separatorAt(++this.pos)) {
            }
        }
        StringBuffer token = new StringBuffer();
        Vector<Character> closings = new Vector<Character>();
        StringTokenizer stok = new StringTokenizer(this.source.substring(this.pos), this.allseps, true);
        while (stok.hasMoreTokens() && (closings.size() > 0 || !this.separatorAt(this.pos))) {
            String tmp = stok.nextToken();
            if (this.nestingSeparatorAt(this.pos)) {
                char sepel = tmp.charAt(0);
                int index = closings.lastIndexOf(new Character(sepel));
                if (index != -1) {
                    for (int i2 = closings.size() - 1; i2 >= index; --i2) {
                        closings.remove(i2);
                    }
                } else {
                    int idx = this.open.indexOf(sepel);
                    if (idx != -1) {
                        closings.addElement(new Character(this.close.charAt(idx)));
                    }
                }
            }
            token.append(tmp);
            this.pos += tmp.length();
        }
        return token.toString();
    }

    public String remainingTokens() {
        if (!this.retsep) {
            while (this.separatorAt(this.pos)) {
                ++this.pos;
            }
        }
        return this.source.substring(this.pos);
    }

    public boolean hasMoreTokens() {
        int nextpos;
        for (nextpos = this.pos; nextpos < this.source.length() && !this.retsep && this.separatorAt(nextpos); ++nextpos) {
        }
        return nextpos < this.source.length();
    }

    public int countTokens() {
        int oldpos = this.pos;
        int toks = 0;
        while (this.hasMoreTokens()) {
            this.nextToken();
            ++toks;
        }
        this.pos = oldpos;
        return toks;
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    protected boolean separatorAt(int pos) {
        return this.separators.indexOf(this.source.charAt(pos)) != -1 && (pos == 0 || ESCAPE_CHARACTERS.indexOf(this.source.charAt(pos - 1)) == -1);
    }

    protected boolean nestingSeparatorAt(int pos) {
        return !(this.open.indexOf(this.source.charAt(pos)) == -1 && this.close.indexOf(this.source.charAt(pos)) == -1 || pos != 0 && ESCAPE_CHARACTERS.indexOf(this.source.charAt(pos - 1)) != -1);
    }

    public static void main(String[] args) {
        ExpressionTokenizer etok = new ExpressionTokenizer("get(a, get(x)[a, b]), c, ,\"\\\"\"", ", ", new String[]{"()", "[]", "\"\""});
        while (etok.hasMoreTokens()) {
            System.out.println("found: " + etok.nextToken());
        }
        System.out.println("\n");
        etok = new ExpressionTokenizer("get(a, get(x)[a, b]), c, ,\"\\\"\"", ", ", new String[]{"()", "[]", "\"\""}, true);
        while (etok.hasMoreTokens()) {
            System.out.println("found: " + etok.nextToken());
        }
        String test = "steppable_dispatcher_step_done :steps \"0\" :state \"applicable candidates\" :applicables (sequence \"Tuple[MPlan( name = decrement, waitqueuefilter = null, filter = MExpression(expression = new GoalEventFilter(\\\"keep\\\")), condition = null, initial = false ), RBDIAgent(name=ca)]\")";
        System.out.println("\n" + test);
        etok = new ExpressionTokenizer(test, ", ", new String[]{"()", "\"\""});
        while (etok.hasMoreTokens()) {
            System.out.println("found: " + etok.nextToken());
        }
    }
}

