/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import jadex.util.SReflect;
import jadex.util.SUtil;
import jadex.util.collection.IndexMap;
import jadex.util.collection.SCollection;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DynamicURLClassLoader
extends ClassLoader {
    protected IndexMap urls;
    protected Map classdates = SCollection.createHashMap();
    protected static Date creation = new Date();
    protected static ClassLoader instance;

    public DynamicURLClassLoader(ClassLoader parent) {
        super(parent);
        this.urls = SCollection.createIndexMap();
    }

    public void addURL(URL url) {
        if (!this.urls.containsKey(url)) {
            this.urls.put(url, new InnerURLClassLoader(url, (ClassLoader)this));
            SReflect.clearClassCache();
        }
    }

    public void removeURL(URL url) {
        if (this.urls.removeKey(url) != null) {
            SReflect.clearClassCache();
        }
    }

    public void reset() {
        if (!this.urls.isEmpty()) {
            this.urls.clear();
            SReflect.clearClassCache();
        }
    }

    public URL[] getURLs() {
        return (URL[])this.urls.getKeys(URL.class);
    }

    public Class loadModifiedClass(Class clazz) {
        try {
            Date last;
            ProtectionDomain pDomain = clazz.getProtectionDomain();
            CodeSource cSource = pDomain.getCodeSource();
            URL loc = cSource.getLocation();
            if (loc.toString().endsWith("/")) {
                loc = new URL(loc, clazz.getName().replace('.', '/') + ".class");
            }
            URLConnection uc = loc.openConnection();
            uc.setUseCaches(false);
            Date modified = new Date(uc.getLastModified());
            if (modified.after(creation) && ((last = (Date)this.classdates.get(clazz.getName())) == null || modified.after(last))) {
                InnerURLClassLoader reloader = new InnerURLClassLoader(cSource.getLocation(), (ClassLoader)this);
                clazz = reloader.internalLoadModifiedClass(clazz);
                this.classdates.put(clazz.getName(), modified);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Modification date of reloadable class not available: " + clazz);
        }
        return clazz;
    }

    public List getAllClasspathURLs() {
        ArrayList ret = SCollection.createArrayList();
        StringTokenizer stok = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (stok.hasMoreTokens()) {
            try {
                String entry = stok.nextToken();
                File file = new File(entry);
                if (file.isDirectory() && !entry.endsWith(System.getProperty("file.separator"))) {
                    entry = entry + System.getProperty("file.separator");
                }
                ret.add(new URL("file:///" + entry));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ret.addAll(this.urls.keySet());
        return ret;
    }

    public String getPackageOfFile(String filename) {
        String pkg = null;
        StringTokenizer stok = new StringTokenizer(System.getProperty("java.class.path"), System.getProperty("path.separator"));
        while (pkg == null && stok.hasMoreElements()) {
            String entry = stok.nextToken();
            entry = new File(entry).getAbsolutePath();
            pkg = this.extractPackage(filename, entry);
        }
        if (pkg == null) {
            URL[] urls = this.getURLs();
            for (int i = 0; pkg == null && i < urls.length; ++i) {
                String entry = urls[i].getFile();
                if (entry.endsWith("/")) {
                    entry = entry.substring(0, entry.length() - 1);
                }
                pkg = this.extractPackage(filename, entry);
            }
        }
        return pkg;
    }

    protected String extractPackage(String filename, String entry) {
        filename = SUtil.replace(filename, System.getProperty("file.separator"), "/");
        entry = SUtil.replace(entry, System.getProperty("file.separator"), "/");
        String pkg = null;
        int index = filename.indexOf(entry);
        if (index != -1) {
            pkg = filename.substring(index + entry.length() + 1);
            if (pkg.startsWith("/")) {
                pkg = pkg.substring(1);
            }
            if ((index = pkg.lastIndexOf("/")) != -1) {
                pkg = pkg.substring(0, index);
                pkg = SUtil.replace(pkg, "/", ".");
            }
        }
        return pkg;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (NoClassDefFoundError e) {
            throw new ClassNotFoundException(name);
        }
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        Class ret = null;
        InnerURLClassLoader[] loaders = (InnerURLClassLoader[])this.urls.getObjects(InnerURLClassLoader.class);
        for (int i = 0; ret == null && i < loaders.length; ++i) {
            ret = loaders[i].loadClassFromURL(name);
        }
        if (ret == null) {
            throw new ClassNotFoundException(name);
        }
        return ret;
    }

    protected URL findResource(String name) {
        URL ret = null;
        InnerURLClassLoader[] loaders = (InnerURLClassLoader[])this.urls.getObjects(InnerURLClassLoader.class);
        for (int i = 0; ret == null && i < loaders.length; ++i) {
            ret = loaders[i].findResource(name);
        }
        return ret;
    }

    public static synchronized ClassLoader getInstance() {
        if (instance == null) {
            try {
                instance = new DynamicURLClassLoader(DynamicURLClassLoader.class.getClassLoader());
            }
            catch (SecurityException e) {
                instance = DynamicURLClassLoader.class.getClassLoader();
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addURLToInstance(URL url) {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).addURL(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeURLFromInstance(URL url) {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).removeURL(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetInstance() {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getURLsFromInstance() {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                return ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).getURLs();
            }
            return new URL[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadClassWithInstance(String name, boolean resolve) throws ClassNotFoundException {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                return ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).loadClass(name, resolve);
            }
            return Class.forName(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadModifiedClassWithInstance(Class clazz) {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                return ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).loadModifiedClass(clazz);
            }
            return clazz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPackageOfFileFromInstance(String filename) {
        ClassLoader classLoader = DynamicURLClassLoader.getInstance();
        synchronized (classLoader) {
            if (DynamicURLClassLoader.getInstance() instanceof DynamicURLClassLoader) {
                return ((DynamicURLClassLoader)DynamicURLClassLoader.getInstance()).getPackageOfFile(filename);
            }
            return null;
        }
    }

    static class InnerURLClassLoader
    extends URLClassLoader {
        public InnerURLClassLoader(URL url, ClassLoader parent) {
            super(new URL[]{url}, parent);
        }

        protected Class loadClassFromURL(String name) {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = super.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return clazz;
        }

        protected Class internalLoadModifiedClass(Class clazz) {
            try {
                Class[] inner = SReflect.getAnonymousInnerClasses(clazz);
                for (int i = 0; i < inner.length; ++i) {
                    this.internalLoadModifiedClass(inner[i]);
                }
                clazz = super.findClass(clazz.getName());
                System.out.println("Loaded modified class: " + clazz.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Reloadable class not available: " + clazz);
            }
            return clazz;
        }
    }
}

