/*
 * Decompiled with CFR 0.152.
 */
package jadex.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class CachedObject
implements Serializable {
    protected Serializable cachedobject;
    protected String filename;
    protected long lastmodified;

    public CachedObject(String filename, long lastmodified, Serializable cachedobject) {
        this.filename = filename;
        this.lastmodified = lastmodified;
        this.cachedobject = cachedobject;
    }

    public void setObject(Serializable cachedobject) {
        this.cachedobject = cachedobject;
    }

    public Serializable getObject() {
        return this.cachedobject;
    }

    public long getLastModified() {
        return this.lastmodified;
    }

    public void setLastModified(long lastmodified) {
        this.lastmodified = lastmodified;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public synchronized void persist() throws IOException {
        if (this.filename == null) {
            throw new IOException("Filename nulls.");
        }
        if (this.filename.startsWith("jar:")) {
            return;
        }
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.filename));
            oos.writeObject(this);
            oos.close();
        }
        catch (FileNotFoundException e) {
            throw new IOException("Could not write cache to disk: " + this.filename);
        }
    }
}

